<?php
namespace App\Helpers;

class Stripe
{
    //Payment API's start
    public static function createCharge($payload){
        try{
            $stripe = new \Stripe\StripeClient(getenv('STRIPE_SK'));
            //Create customer
            $customer = $stripe->customers->create([
            	'email' => $payload['email'],
            	'name'  => $payload['name']
            ]);
            
            //Initialize payment
            $create_payment = $stripe->paymentIntents->create(
            	[
            		'amount' => 100 * $payload['amount'],
            		'currency' => getenv('STRIPE_currency'),
            		'payment_method_types' => ['card'],
            		'customer' => $customer->id,
            		'confirmation_method' => 'manual',
            		'confirm' => true,
            		'payment_method_data' => [
            			'type' => 'card',
            			'card' => [
            				'token' => $payload['stripeToken'],
            			]
            		],
            		"description" => "Payment for Adding amount in Wallet"
            	] 
            );
            if(!empty($create_payment->id)){
                $response = ['success'=>'1','transactionID'=>$create_payment->id,'msg'=>"Payment done successfully"];
            }else{
                $response = ['success'=>'0','msg'=>"Something went wrong, try again"];
            }
        }catch(Exception $e){
            $messages=$e->getMessage();
            $response = ["success"=>0,"message"=>$messages];
        }
        return $response;
    }
    
    public static function transferMoneyToBank($payload){
        try{
            $stripe = new \Stripe\StripeClient(getenv('STRIPE_SK'));
            $create_transfer = $stripe->transfers->create([ 
        	  'amount' => 100 * $payload['amount'],
        	  'currency' => getenv('STRIPE_currency'),
        	  'destination' => $payload['accountID'],
        	]);
        	if(!empty($create_transfer->id)){
                $response = ['success'=>'1','message'=>"Money successfully added"];
            }else{
                $response = ['success'=>'0','message'=>"Something went wrong, try again"];
            }
        }catch(Exception $e){
            $messages=$e->getMessage();
            $response = ["success"=>0,"message"=>$messages];
        }
        return $response;
	}
	//Payment API's end
	
	//Bank API's start
	//Create account process
    public static function arrayOfConnectAccount($payload){
        $dobD = explode("-",$payload['dob']);
        $array =  [
            'type' => 'custom',
            'country' => 'GB',//$payload['country'],
            'email' => $payload['email'],
            'business_type' => 'individual',
            'capabilities' => [
                'card_payments' => ['requested' => true],//$payload['country'] == 'US' ? ['requested' => true] : ['requested' => false] ,
                'transfers' => ['requested' => true],
            ],
            "business_profile" => [
                "url"=> $payload['businessURL'] ? $payload['businessURL'] : "https://www.instagram.com/encro_org/",
                //"product_description"=> $payload['productDescription'] ? $payload['productDescription'] : null,
                "mcc"=> 6012,
                //"name" => ""
            ],
            "individual" => [
                "id_number" => $payload['id_number'],
                //"ssn_last_4" => substr($payload['id_number'], -4),
                "first_name"  => $payload['firstName'],
                "last_name" => $payload['lastName'],
                "email" => $payload['email'],
                "phone" => $payload['phoneNumber'],
                 "address" => [
                    "city" => $payload['city'],
                    "country"=> 'GB',//$payload['country'],
                    "line1"=> $payload['street'],
                    "line2"=> null,
                    "postal_code"=> $payload['postalCode'],
                    //"state"=> $payload['state']
                ],
                'dob' => [
                    'day' => $dobD[2],
                    'month' => $dobD[1],
                    'year' => $dobD[0],
                ],
            ],
            "tos_acceptance" =>[
                "date"=> time(),
                "ip"=> $_SERVER['REMOTE_ADDR'],
                //"service_agreement" => $payload['country'] == 'US' ? "full" : "recipient",
                "service_agreement" => "full",
                "user_agent"=> null
            ],
        ];
        return $array;
    }
    
    public static function updatedArray($payload){
		$dobD = explode("-",$payload['dob']);
        $array =  [
            'email' => $payload['email'],
            "business_profile" => [
                "url"=> $payload['businessURL'] ? $payload['businessURL'] : "https://www.instagram.com/encro_org/",
            ],
            "individual" => [
                "id_number" => $payload['id_number'],
                //"ssn_last_4" => substr($payload['id_number'], -4),
                "first_name"  => $payload['firstName'],
                "last_name" => $payload['lastName'],
                "email" => $payload['email'],
                "phone" => $payload['phoneNumber'],
                 "address" => [
                    "city" => $payload['city'],
                    "country"=> $payload['country'],
                    "line1"=> $payload['street'],
                    "line2"=> null,
                    "postal_code"=> $payload['postalCode'],
                    //"state"=> $payload['state']
                ],
                'dob' => [
                    'day' => $dobD[2],
                    'month' => $dobD[1],
                    'year' => $dobD[0],
                ],
            ],
        ];
        return $array;
	}
	
	public static function createAccount($payload){
        try{
            $array =  static::arrayOfConnectAccount($payload);
            $Account=\Stripe\Account::create($array);
            $response = ["success" => 1,"accountID" => $Account->id];
        }catch(Exception $e){
            $messages=$e->getMessage();
            $response = ["success" => 0,"message" => $messages];
        }
        return $response;
    }
    
    public static function updateConnectAccount($payload,$accountID){
		try{
		    $array =  static::updatedArray($payload);
			$Account=\Stripe\Account::update($accountID,$array);
			$response = ["success"=>1];
		}catch (Exception $e) {
            $messages=$e->getMessage();
            $response = ["success"=>0,"message"=>$messages];
        }
        return $response;
    }
    
	//Docs. verification process
    public static function createFileVerificationFront($accountID,$filenameFront,$filenameBack){
	    try{
            $file = \Stripe\File::create([
                'purpose' => 'identity_document',
                'file' => fopen('storage/app/public/uploads/externalAccounts/'.$filenameFront, 'r'),
                ], [
                'stripe_account' => $accountID,
            ]);
            $fileID = $file->id;
            
            $Backfile = \Stripe\File::create([
                'purpose' => 'identity_document',
                'file' => fopen('storage/app/public/uploads/externalAccounts/'.$filenameBack, 'r'),
                ], [
                'stripe_account' => $accountID,
            ]);
            $BackfileID = $Backfile->id;
            
            if($fileID && $BackfileID){
                $account = \Stripe\Account::update($accountID,[
    				"individual" => [
    					"verification"=> [
    					"document"=> [
    					"back"=> $BackfileID,
    					"details"=> null,
    					"details_code"=> null,
    					"front"=> $fileID
    				],
    				],
                ]
    			]);
    			$response = ["success" => 1,"status" => $account['individual']['verification']->status];
	        }else{
	            $response = ["success" => 0,"message" => "something went wrong"];
	        }
	    }catch(Exception $e)
	    {
	        $messages=$e->getMessage();
            $response = ["success" => 0,"message" => $messages];
	    }
	    return $response;
    }
    
    //Add bank process
    public static function createBankOfConnectedAccountUser($payload){
        try{
            $TokenInfo = \Stripe\Token::create(array(
				"bank_account" => array(
					"country" => env('STRIPE_country'),
					"currency" => env('STRIPE_currency'),
					"account_holder_name" => $payload['accountHolderName'],
					"account_holder_type" => "individual",
					"routing_number" => $payload['routingNumber'],
					"account_number" => $payload['accountNumber']
				)
			));
			$response = ["success" => 1,"tokenID" => $TokenInfo->id,'bank_name'=>$TokenInfo->bank_name];
        }catch(Exception $e)
        {
            $messages=$e->getMessage();
            $response = ["success" => 0,"message" => $messages];
        }
        return $response;
    }
    
    public static function createExternalAccountOfUser($TokenID,$accountID){
        try{
			$external_account = \Stripe\Account::createExternalAccount($accountID,['external_account' => $TokenID]);
			$response = ["success"=>1];
		}catch (Exception $e){
            $messages=$e->getMessage();
            $response = ["success"=>0,"message"=>$messages];
        }
        return $response;
    }
    
    //Retrieve bank details
    public static function retrieveAccountDetailFromStripe($accountID){
		$accountDetail = \Stripe\Account::retrieve($accountID);
		return $accountDetail;
	}
	
	//Delete Bank
	public static function deleteBank($accountID){
	    try{
	        $stripe = new \Stripe\StripeClient(getenv('STRIPE_SK'));
            $stripe->accounts->delete($accountID, []);
            $response = ["success" => 1,"message" =>"Bank account deleted successfully"];
        }catch(Exception $e){
            $messages=$e->getMessage();
            $response = ["success" => 0,"message" => $messages];
        }
        return $response;
	}
	//Bank API's end
} 

?>