<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Contracts\Authenticatable;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use URL;

//Models
use App\Models\Admin;
use App\Models\Users;
use App\Models\Pages;
use App\Models\Contactus;
use App\Models\externalAccounts;
use App\Models\UserCards;
use App\Models\Transactions;

class AdminController extends Controller
{
    public function index(){
        return view('admin.login');
    }
    
    public function login(Request $request){
        $this->validate($request, [
            'email'    => 'required|email',
            'password' => 'required',
        ]);
 
        if( auth()->guard('admin')->attempt(['email' => $request->input('email'),  'password' => $request->input('password')]) ){
            $user = auth()->guard('admin')->user();
            if($user){
                Session::put('id', $user['id']);
                Session::put('name', $user['first_name']." ".$user['last_name']);
                Session::put('email', $user['email']);
                Session::put('profile_img', $user['profile_image']);
                return redirect()->route('adminDashboard')->with('success','You are Logged in sucessfully.');
            }
        }else {
            return back()->with('error','Whoops! invalid email and password.');
        }
    }
	
	public function getNotifications(){
		return view('admin.notifications');
	}
    
    public function logout(Request $request){
        auth()->guard('admin')->logout();
        Session::flush();
        Session::put('success', 'You are logout sucessfully');
        return redirect(route('adminLogin'));
    }
    
    public function dashboard(){
		//Users		
		$usersCount = count(Users::where('isSuspend',0)->get());
		if( $usersCount == '0' ){
			$data['active_users'] = 0;
		}else{
			$data['active_users'] = $usersCount - 1;
		}
		
        $newUsers = Users::newUsersAdmin();
		if($newUsers[0]->count_today == 0){
			$data['new_users'] = 0;
		}else{
			$data['new_users'] = $newUsers[0]->count_today - 1;
		}
		
		//Transactions
		$transactionsCount = count(Transactions::where(['type'=>'2'])->orWhere(['type'=>'4'])->get());
		if( $transactionsCount == 0 ){
			$data['transactions'] = 0;
		}else{
			$data['transactions'] = $transactionsCount - 1;
		}
        
        $newTransactions = Transactions::newTransactionsAdmin();
		if( $newTransactions[0]->count_today  == 0 ){
			$data['new_transactions'] = 0;
		}else{
			$data['new_transactions'] = $newTransactions[0]->count_today - 1;
		}
        return view('admin.dashboard',$data);
    }
    
    public function userManagement(){
        $data['users'] = Users::orderBy('id','DESC')->get();
        return view('admin.user_mgt',$data);
    }
    
    public function approveRejectProfile(Request $request){
        $id = $request->input('user_id');
        $type = $request->input('type');
        $user = Users::find($id);   
        if( $type == 0 ){
            $user->status = 2;
			$msg = "User profile rejected";
        }elseif( $type == 1 ){
            $user->status = 1;
			$msg = "User profile approved";
        }
		
		$execute = $user->update();
		if($execute){
            $data = ['success'=>true,'message'=>$msg];
        }else{
            $data = ['success'=>false,'message'=>"Something went wrong, please try again"];
        }
		return response()->json($data);
    } 
    
    public function suspendActivateUser(Request $request){
        $id = $request->input('user_id');
        $type = $request->input('type');
        $user = Users::find($id);
        if( $type == 0 ){
            $user->isSuspend = 0;
			$msg = "User account activated";
        }else{
            $user->isSuspend = 1;
            $user->tokens()->delete();
			$msg = "User account deactivated";
        }
        
		$execute = $user->update();
		if($execute){
            $data = ['success'=>true,'message'=>$msg];
        }else{
            $data = ['success'=>false,'message'=>"Something went wrong, please try again"];
        }
		return response()->json($data);
    }
    
    public function userDetails($id){
        $data['user_details'] = Users::where('id',$id)->first();
        $data['user_bank'] = externalAccounts::where('userID',$id)->first();
        return view('admin.user_mgt_detail',$data);
    }
    
    public function paymentManagement(){
        $data['transactions'] = Transactions::whereIn('type',['2','4'])->orderBy('id','DESC')->get();
        return view('admin.payment_management',$data);
    }
    
    public function paymentDetails($id){
        $data['userIp'] = parent::getUserCurrentTimeZone();
        $data['transaction_details'] = Transactions::where('id',$id)->first();
        return view('admin.payment_detail',$data);
    }
    
    public function reportManagement(){
        $data['userIp'] = parent::getUserCurrentTimeZone();
        $data['reports'] = DB::table('tbl_contactus')->join('tbl_users', 'tbl_contactus.userID', '=', 'tbl_users.id')
          ->select('tbl_contactus.*', 'tbl_users.firstName', 'tbl_users.lastName', 'tbl_users.userProfile')
          ->orderBy('tbl_contactus.id','DESC')->get();
        return view('admin.report_management',$data);
    }
    
    public function replyToUser(Request $request){
        $report_id = $request->input('report_id');
        $email = $request->input('user_email');
        $msg = $request->input('reply_msg');
    	
    	$get_user_id = Contactus::where('id',$report_id)->first();
    	$user = Users::where('id',$get_user_id->user_id)->first();
        $data['type'] = 3;
        $data['subject'] = 'Encro Support';
        $data['title'] = 'Hi';
        $data['message'] = $msg;
        $data['regards'] = getenv('ADMIN_EMAIL');
        $sendEmail = $this->sendEmail($email,$data);
		$delete = DB::table('tbl_contactus')->where('id', $report_id)->delete();
        if($delete){
            $data = ['success' => true,'message'=> 'Message posted successfully'];
        }else{
            $data = ['success' => false,'message'=> 'Something went wrong, please try again later'];
        }
		return response()->json($data);
    }
    
    public function aboutUsManagement(){
        $data['data'] = Pages::where('slug','about-us')->first();
        return view('admin.aboutus_management',$data);
    }
    
    public function aboutUs(){
        $data['data'] = Pages::where('slug','about-us')->first();
        return view('admin.about_us',$data);
    }
    
    public function uploadContent(Request $request){
        $content = strip_tags($request->editor);
        $data['content'] = $request->editor;
        $upload = Pages::where('slug','about-us')->update($data);
        if($upload){
            $data = ['success' => true,'message'=> 'Content posted successfully'];
        }else{
            $data = ['success' => false,'message'=> 'Something went wrong, please try again later'];
        }
		return response()->json($data);
    }
    
    public function termAndPolicy (){
        $data['data'] = Pages::where('slug','term-policy')->first();
        return view('admin.term_and_policy',$data);
    }
    
    public function settings(){
        return view('admin.settings');
    }
    
    public function changePassword(Request $request){
		if(strlen($request->password) > 0 && strlen(trim($request->password)) == 0){
			$data = ['success' => false,'message'=> 'Please enter your new password'];
		}elseif(strlen($request->confirm_password) > 0 && strlen(trim($request->confirm_password)) == 0){
			$data = ['success' => false,'message'=> 'Please re-enter your new password'];
		}else{
			$data = array('password'=>bcrypt($request->password));
			$update = Admin::where('id',session('id'))->update($data);
			if($update){
				$adminLogin = URL::to('/admin/login');
				$data = ['success' => true,'message'=> 'Password changed successfully','url'=>$adminLogin];
			}else{
				$data = ['success' => false,'message'=> 'Something went wrong, please try again!'] ;
			}
		}
        return response()->json($data);
    }
    
    public function uploadImg(Request $request){
        if(!empty($request->picture__input) && isset($request->picture__input)){
            $img = $request->picture__input;
            $imageName = time().uniqid().'.'.$request->picture__input->extension();
            
            //Unlink old image
            $oldImg = Admin::where('id',session('id'))->first();
            if( !empty($oldImg->profile_image) && isset($oldImg->profile_image) ){
                $file_path = public_path('admin/assets/images/admin/').$oldImg->profile_image;
                unlink($file_path);
            }
             
            //Upload new image
            $request->picture__input->move(public_path('admin/assets/images/admin/'), $imageName);
            $data = array('profile_image'=>$imageName);
            $update = Admin::where('id',session('id'))->update($data);
            Session::forget('profile_img');
            $data = ['success' => true,'message'=> 'Image uploaded successfully'] ;
        }else{
            $data = ['success' => false,'message'=> 'Please select image to upload!'] ;
        }
        return response()->json($data);
    }
    
}
