<?php
namespace App\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use App\Models\Requests;
use App\Models\Users;
use Carbon\Carbon;

class CronJobController extends Controller
{
    
    //Decline pending requests after 15 minutes if receiver does not take any action on request
    public function declinePendingRequests(){
        $getRequests = Requests::where('status','0')->get();
        if($getRequests->isNotEmpty()){
            foreach($getRequests as $getRequest){
                $lastActivity = Carbon::parse($getRequest->updated_at);
                $currentTime = Carbon::now();
                if ($lastActivity->diffInMinutes($currentTime) >= 15) {
                    Requests::where('status','')->update(['status'=>'2']);
                    //Send Notification start
                        $receiver = Users::where('id',$getRequest->senderID)->first();
                        $sender   = Users::where('id',$getRequest->receiverID)->first();
                        
                        $data = [
                            'receiverID'   => $getRequest['senderID'], 
                            'senderID'     => $getRequest['receiverID'],
                            'requestID'    => $getRequest['id'],
                            'amount'       => $getRequest['amount'],
                        ];
                        $title = "Payment Request Declined";
                        $body = "Hlo, ".$receiver->firstName." ".$receiver->lastName." Your request for amount $".$getRequest->amount." to ".$sender->firstName." ".$sender->lastName." has been declined.";
                        parent::sendNotification( $data, $title, $body, 3 );
                    //Send Notification end
                }
            }
        }
    }

}