<?php
namespace App\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Validator;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Auth;

use App\Http\Traits\AuthTrait;
use App\Http\Traits\ExternalAccountTrait;
use App\Helpers\Stripe;
use URL;
use DB;

use App\Models\Users;
use App\Models\UserCards;
use App\Models\Contactus;
use App\Models\externalAccounts;
use App\Models\Requests;
use App\Models\Wallet;
use App\Models\Transactions;
use App\Models\WalletAmount;
use App\Models\Notifications;

use OpenApi\Annotations as OA;


class UsersController extends Controller
{
    use AuthTrait,ExternalAccountTrait;   
    
    public function profileDetail(Request $request){
        try{
            $user = parent::decryptToken();
            if($user){
                $response = [
                    "data" => $user,
                    "status" => parent::statusCode()['success'],
                    "message" => __('messages.dataFound'),
                ];
            }else{
                $response = [
                    "status" => parent::statusCode()['success'],
                    "message" => __('messages.dataNotFound'),
                ];
            }
        }catch(\Exception $e){
            $response = [
                "status" => parent::statusCode()['error'],
                "message" => $e->getMessage(),
            ];
        }
        return parent::sendResponse($response);
    }
    
    public function createProfile(Request $request){
        try{
            $user = parent::decryptToken();
            $userID = $user->id;
            $payload = $request->all();
            $payload['isTrack'] = 2;
            $payload['country'] = 'UK';
            
            $validator = Validator::make($request->all(),
            [
                "phoneNumber" => ['required',Rule::unique('tbl_users')->ignore($userID)],
            ]);
            if($validator->fails()){
                $response = 
                [
                    "status" => parent::statusCode()['error'],
                    "message" => $validator->messages()->first('phoneNumber')
                ];
            }else{
                /*$phoneNumber = "+".$request->countryCode." ".$request->phoneNumber; 
                $sendPhoneOtp = $this->sendPhoneOtp($phoneNumber);die('stop');
                if($sendPhoneOtp['status'] == 1){
                    $payload['isOtpSent'] = 1;
                    $otpSendDate = $sendPhoneOtp['data']['otpSendDate'];
                    $otpSendCountInDay = $sendPhoneOtp['data']['otpSendCountInDay'];
                    $payload['otpSendDate'] = $otpSendDate;
                    $payload['otpSendCountInDay'] = $otpSendCountInDay;
                }die('stop');*/
                if($request->file()){
                    parent::unlinkFile($this->folder,$user->userProfile);
                    $upload = parent::uploadSingleFile($this->folder,$request,'userProfile');
                    if($upload['success'] == 1){
                        $payload['userProfile'] = $upload['filename'];
                        $update = Users::where('id',$userID)->update($payload);
                        if($update){
                            $getUpdatedData = Users::where('id',$userID)->first();
                            $response = [
                                "data" => $getUpdatedData,
                                "status" => parent::statusCode()['success'],
                                "message" => __('messages.dataFound'),
                            ];
                        }else{
                            $response = [
                                "status" => parent::statusCode()['error'],
                                "message" => __('messages.wrong')
                            ];
                        }
                    }else{
                        $response = [
                            "status" => parent::statusCode()['error'],
                            "message" => $upload['message']
                        ];
                    }
                }else{
                    $update = Users::where('id',$userID)->update($payload);
                    if($update){
                        $getUpdatedData = Users::where('id',$userID)->first();
                        $response = [
                            "data" => $getUpdatedData,
                            "status" => parent::statusCode()['success'],
                            "message" => __('messages.dataFound'),
                        ];
                    }else{
                        $response = [
                            "status" => parent::statusCode()['error'],
                            "message" => __('messages.wrong')
                        ];
                    }
                }
            }
        }catch(\Exception $e){
            $response = [
                "status" => parent::statusCode()['error'],
                "message" => $e->getMessage()
            ];
        }
        return parent::sendResponse($response);
    }
    
    public function updateProfile(Request $request){
        try{
            $user = parent::decryptToken();
            $userID = $user->id;
            $payload = $request->all();
            
            if($request->file() && !empty($request->file()) ){
                parent::unlinkFile($this->folder,$user->userProfile);
                $upload = parent::uploadSingleFile($this->folder,$request,'userProfile');
                if($upload['success'] == 1){
                    $payload['userProfile'] = $upload['filename'];
                    $update = Users::where('id',$userID)->update($payload);
                    if($update){
                        $userDetail = Users::where('id',$userID)->first();
                        $response = [
                            "data" => $userDetail,
                            "status" => parent::statusCode()['success'],
                            "message" => __('messages.profileCreated')
                        ];
                    }else{
                        $response = [
                            "status" => parent::statusCode()['error'],
                            "message" => __('messages.wrong')
                        ];
                    }
                }else{
                    $response = [
                        "status" => parent::statusCode()['error'],
                        "message" => $upload['message']
                    ];
                }
            }else{
                unset($payload['userProfile']);
                $update = Users::where('id',$userID)->update($payload);
                if($update){
                    $userDetail = Users::where('id',$userID)->first();
                    $response = [
                        "data" => $userDetail,
                        "status" => parent::statusCode()['success'],
                        "message" => __('messages.profileCreated')
                    ];
                }else{
                    $response = [
                        "status" => parent::statusCode()['error'],
                        "message" => __('messages.wrong')
                    ];
                }
            }
        }catch(\Exception $e){
            $response = [
                "status" => parent::statusCode()['error'],
                "message" => $e->getMessage()
            ];
        }
        return parent::sendResponse($response);
    }
    
    public function uploadDocuments(Request $request){
        try{
            $user = parent::decryptToken();
            $userID = $user->id;
            if( $request->file() && !empty($request->file()) ){
                parent::unlinkFile($this->documents,$user->identityFront);
                parent::unlinkFile($this->documents,$user->identityBack);
                $uploadIdentityFront = parent::uploadSingleFile($this->documents,$request,$this->identityFront);
                $uploadIdentityBack = parent::uploadSingleFile($this->documents,$request,$this->identityBack);
                if($uploadIdentityFront['success'] == 1 && $uploadIdentityBack['success'] == 1){
                    $payload['isTrack'] = 3;
                    $payload[$this->identityFront] = $uploadIdentityFront['filename'];
                    $payload[$this->identityBack] = $uploadIdentityBack['filename'];
                    $payload['otp'] = 1234;//rand(1000,9999);
                    $update = Users::where('id',$userID)->update($payload);
                    if($update){
                        $userData = Users::where('id',$userID)->first();
                        $response = [
                            "data" => $userData,
                            "token" => parent::encryptToken($user),
                            "status" => parent::statusCode()['success'],
                            "message" => __('messages.doumentUpload')
                        ];
                    }else{
                        $response = [
                            "status" => parent::statusCode()['error'],
                            "message" => __('messages.wrong')
                        ];
                    }
                }else{
                    $response = [
                        "status" => parent::statusCode()['error'],
                        "message" => $uploadIdentityFront['success'] == 0 ?  $uploadIdentityFront['message']  : $uploadIdentityBack['message'] 
                    ];
                }
            }else{
                $reponse = [
                    "status" => parent::statusCode()['error'],
                    "message" => __('messages.documentRequired')
                ];   
            }
        }catch(\Exception $e){
            $response = [
                "status" => parent::statusCode()['error'],
                "message" => $e->getMessage(),
            ];
        }
        return parent::sendResponse($response);
    }
    
    public function addCard(Request $request){
        try{
            $user = parent::decryptToken();
            $userID = $user->id;
            $payload = $request->all();
            $payload['userID'] = $userID;
            $payload['status'] = 1;
            $payload['cardNumber'] = parent::encryptDataInSecureForm($userID,$request->cardNumber);
            $getCards = UserCards::where(['userID'=>$userID,'cardNumber'=>$payload['cardNumber'],'status'=>'1'])->first();
            if( !empty($getCards) && ($getCards->cardNumber == $payload['cardNumber'])){
                $response = [
                    "status" => parent::statusCode()['error'],
                    "message" => __('messages.cardError')
                ]; 
            }else{
                $create = UserCards::create($payload);
                if($create){
                    $card = UserCards::where('userID',$userID)->count();
                    if($card == 1){
                        Users::where('id',$userID)->update(['isTrack' => 5]);   
                    }
                    $response = [
                        "status" => parent::statusCode()['success'],
                        "message" => __('messages.card',['key' => 'added']),
                    ];
                }else{
                    $response = [
                        "status" => parent::statusCode()['error'],
                        "message" => __('messages.wrong'),
                    ];
                }
            }
        }catch(\Exception $e){
            $response = [
                "status" => parent::statusCode()['error'],
                "message" => $e->getMessage(),
            ];
        }
        return parent::sendResponse($response);
    }
    
    public function deleteCard(Request $request,$id){
        try{
            $user = parent::decryptToken();
            $payload = $request->all();
            $delete = UserCards::where(['id'=>$id,'userID'=>$user->id])->update(['status'=>'0']);
            if($delete){
                $response = [
                    "status" => parent::statusCode()['success'],
                    "message" => __('messages.card',['key' => 'deleted']),
                ];
            }else{
                $response = [
                    "status" => parent::statusCode()['error'],
                    "message" => __('messages.wrong'),
                ];
            }
        }catch(\Exception $e){
            $response = [
                "status" => parent::statusCode()['error'],
                "message" => $e->getMessage(),
            ];
        }
        return parent::sendResponse($response);
    }
      
    public function cards(Request $request){
        try{
            $user = parent::decryptToken();
            $cards = UserCards::where(['userID'=>$user->id,'status'=>"1"])->orderBy('id','desc')->get();
            if($cards->isNotEmpty()){
                $data = [];
                foreach($cards as $card){
                    $card['cardNumber'] = parent::decryptDataInSecureForm($user->id,$card->cardNumber);
                    $data[] = $card;
                }
                $response = [
                    "data" => $data,
                    "status" => parent::statusCode()['success'],
                    "message" => __('messages.dataFound'),
                ];
            }else{
                $response = [
                    "status" => parent::statusCode()['success'],
                    "message" => __('messages.dataNotFound'),
                ];
            }
        }catch(\Exception $e){
            $response = [
                "status" => parent::statusCode()['error'],
                "message" => $e->getMessage(),
            ];
        }
        return parent::sendResponse($response);
    }
    
    public function changePassword(Request $request){
        try{
            $user = $this->decryptToken();
            $validator = Validator::make($request->all(), [
                'password' => 'required',
                'oldPassword' => 'required',
            ]);
       
            if($validator->fails()){
                $response = [
                    "status" => parent::statusCode()['error'],
                    "message" => __('messages.passworRequired'),
                ];
            }else {
                $userDetail = Users::select('password')->where('id',$user->id)->first();;
                if(password_verify($request->oldPassword,$userDetail['password'])){ 
                    $update = Users::where(['id' => $user->id])->update(['password' => bcrypt($request->password),"updated_at" => date('Y-m-d H:i:s')]);
                    if($update){
                        $response = [
                            "status" => parent::statusCode()['success'],
                            "message" => __('messages.passwordChanged'),
                        ];    
                    }else{
                        $response = [
                            "status" => parent::statusCode()['error'],
                            "message" => __('messages.wrong'),
                        ];
                    }   
                }else{
                    $response = [
                        "status" => parent::statusCode()['error'],
                        "message" => __('messages.oldPassword'),
                    ];
                }
            }
        }catch(Exception $e){
            $response = [
                "status" => parent::statusCode()['error'],
                "message" => $e->getMessage(),
            ];
        }
        return $this->sendResponse($response);
    }
    
    public function contactus(Request $request){
        try{
            $user = $this->decryptToken();
            $validator = Validator::make($request->all(), [
                'email' => 'required',
                'subject' => 'required',
                'message' => 'required'
            ]);
       
            if($validator->fails()){
                $response = [
                    "status" => parent::statusCode()['error'],
                    "message" => __('messages.contactusRequired'),
                ];
            }else {
                $payload = $request->all();
                $payload['userID'] = $user->id;
                $adminEmail = getenv('ADMIN_EMAIL');
                $payload['updated_at'] = date('Y-m-d h:i:s');
                $payload['created_at'] = date('Y-m-d h:i:s');
                $payload['status'] = 1;
                $data['type'] = 2;
                $data['subject'] = $payload['subject'];
                $data['title'] = 'Hi ';
                $data['regards'] = getenv('ADMIN_EMAIL');
                $data['message'] = $payload['message'];
                $respo = $this->sendEmail($adminEmail,$data);
                $update = Contactus::create($payload);
                if($update){
                    $response = [
                        "status" => parent::statusCode()['success'],
                        "message" => __('messages.mailSent'),
                    ]; 
                }else{
                    $response = [
                        "status" => parent::statusCode()['error'],
                        "message" => __('messages.wrong'),
                    ];
                }
            }
        }catch(Exception $e){
            $response = [
                "status" => parent::statusCode()['error'],
                "message" => $e->getMessage(),
            ];
        }
        return $this->sendResponse($response);
    }
    
    public function getQrCode(Request $request){
        try {
            $user = parent::decryptToken();
            if($user){
                $qrData['name'] = $user->firstName." ".$user->lastName;
                $qrData['email'] = $user->email;
                $qrData['qrCode'] = URL::to('public/qrCodes/'.$user->qrCode);
                $qrData['qrLogo'] = URL::to('public/admin/assets/images/Encro_logo.svg');
                $response = [
                    "data" => $qrData,
                    "status" => parent::statusCode()['success'],
                    "message" => __('messages.dataFound'),
                ];
            }else{
                $response = [
                    "status" => parent::statusCode()['success'],
                    "message" => __('messages.dataNotFound'),
                ];
            }
        }catch(\Exception $e){
            $response = [
                "status" => parent::statusCode()['error'],
                "message" => $e->getMessage(),
            ];
        }
        return parent::sendResponse($response);
    }
    
    public function bankDetails(Request $request){
        try{
            $user = parent::decryptToken();
            $banks = externalAccounts::where(['userID'=>$user->id,'isDelete'=>'0'])->orderBy('id','DESC')->get();
            if($banks->isNotEmpty()){
                $data =[];
                foreach($banks as $k => $bank){
                    $data[$k]['id'] = $bank->id;
                    $data[$k]['accountHolderName'] = $bank->accountHolderName;
                    $data[$k]['routingNumber'] = parent::decryptDataInSecureForm($user->id,$bank->routingNumber);
                    $data[$k]['accountNumber'] = parent::decryptDataInSecureForm($user->id,$bank->accountNumber);
                }
                
                $response = [
                    "data" => $data,
                    "status" => parent::statusCode()['success'],
                    "message" => __('messages.dataFound'),
                ];
            }else{
                $response = [
                    "status" => parent::statusCode()['success'],
                    "message" => __('messages.dataNotFound'),
                ];
            }
        }catch(\Exception $e){
            $response = [
                "status" => parent::statusCode()['error'],
                "message" => $e->getMessage(),
            ];
        }
        return parent::sendResponse($response);
    }
    
    public function requestPayment(Request $request){
        try{
            $validator = Validator::make($request->all(), [
                'phoneNumber'  => 'required',
                'amount'  => 'required', 
            ]);
            if($validator->fails()){
                $response = ["status" => 400,"message" => $this->getValidationError($validator)];
            }else{
                $user = parent::decryptToken();
                $payload = $request->all();
                if( $user->status != "1" && $request->amount >= 1000 ){
                    $response = [    
                    	"status" => parent::statusCode()['error'],
                    	"message" => __('messages.profileVerification'),
                    ];
                }else{
                    $checkUser = Users::where(['phoneNumber'=>$payload['phoneNumber']])->first();
                    if(!empty($checkUser)){
                        if($user->phoneNumber == $checkUser->phoneNumber){
                            $response = [    
                                "status" => parent::statusCode()['error'],
                                "message" => "User not found",
                            ];
                        }else{
                            $payload['senderID'] = $user->id;
                            $payload['receiverID'] = $checkUser->id;
                            $payload['type'] = "1";
                            $payload['requestDate'] = date('Y-m-d');
                            $sendRequest = Requests::create($payload);
                            if($sendRequest){
                                $responseData['profileStatus'] = $user->status;
                                $responseData['amount'] = $payload['amount'];
                                $responseData['receiverName'] = $checkUser['firstName']." ".$checkUser['lastName'];
                                $responseData['date'] = date("d M Y");
                                $responseData['time'] = parent::getUserCurrentTimeZone();
                                
                                //Send Notification start
                                    $receiver = Users::where('id',$sendRequest->receiverID)->first();
                                    $sender   = Users::where('id',$sendRequest->senderID)->first();
                                    
                                    $data = [
                                    	'receiverID'   => $sendRequest['receiverID'], 
                                    	'senderID'     => $sendRequest['senderID'],
                                    	'requestID'    => $sendRequest['id'],
                                    	'amount'       => $sendRequest['amount'],
                                    ];
                                    $title = "Amount Requested";
                                    $msg = "Hlo, ".$receiver->firstName." ".$receiver->lastName." You have a payment request for $".$payload['amount']." from ".$sender->firstName." ".$sender->lastName.".";
                                    parent::sendNotification( $data, $title, $msg, 0 );
                                //Send Notification end
                                
                                $response = [
                                    "status" => parent::statusCode()['success'],
                                    "message" => __('messages.requestSent'),
                                    "data" => $responseData,
                                ];
                            }else{
                                $response = [    
                                    "status" => parent::statusCode()['error'],
                                    "message" => __('messages.wrong'),
                                ];
                            }
                        }
                    }else{
                        $response = ["status" => parent::statusCode()['success'],"message" => 'User not found'];
                    }
                }
            }
        }catch(\Exception $e){
            $response = [
                "status" => parent::statusCode()['error'],
                "message" => $e->getMessage(),
            ];
        }
        return parent::sendResponse($response);
    }
    
    public function makePayment(Request $request){
    	try{
    		$validator = Validator::make($request->all(), [
    				'requestID' => 'required',
    				'amount'     => 'required',
    			],
    			[
    				'requestID.required' => 'The requestID field is required',
    			]
    		);
    
    		if($validator->fails()){
    			$response = ["status" => 400,"message" => $this->getValidationError($validator)];
    		}else{
    			$user = parent::decryptToken();
    			if( $user->status != "1" && $request->amount >= 1000 ){
    			    $response = [    
                    	"status" => parent::statusCode()['error'],
                    	"message" => __('messages.profileVerification'),
                    ];
    			}else{
    			    $payload = $request->all();
    			    $checkMoneyInSenderWallet = WalletAmount::where('userID',$user->id)->first();
                    if(empty($checkMoneyInSenderWallet)){
                        $response = [    
                        	"status" => parent::statusCode()['error'],
                        	"message" => __('messages.walletEmpty'),
                        ];
                    }else{
                        if($payload['amount'] > $checkMoneyInSenderWallet->totalAmount){
                            $response = [    
                                "status" => parent::statusCode()['error'],
                                "message" => __('messages.walletBalanceLow'),
                            ];
                        }else{
                            $getRequest = Requests::where('id',$payload['requestID'])->first();
                            $checkUser = Users::where('id',$getRequest->senderID)->first();
                            $payload['senderID'] = $user->id;
                            $payload['receiverID'] = $getRequest->senderID;
                            $payload['userID'] = $getRequest->senderID;
                            $payload['requestID'] = $getRequest->id;
                            $payload['transactionID'] = $this->generateCode();
                            $payload['paymentType'] = '2';
                            $payload['type'] = '2';
                            $payload['paymentStatus'] = 'paid';
                            $payload['requestDate'] = date('Y-m-d');
                            $walletCreate = Wallet::create($payload);
                            $payload['walletID'] = $walletCreate->id;
        			        $createTransaction = Transactions::create($payload);
                            if($createTransaction){
                                $payload['status'] = "1";
                                Requests::create($payload);
                                Requests::where('id',$payload['requestID'])->update(['status'=>"1"]);
                                /*** Add/Update amount in receiver wallet ***/
                        		$checkWallet = WalletAmount::where('userID',$getRequest->senderID)->first();
                        		if(!empty($checkWallet)){
                        			$updatedAmount = $checkWallet->totalAmount + $payload['amount'];
                        			$walletAmount = array('totalAmount'=>$updatedAmount);
                        			WalletAmount::where('userID',$getRequest->senderID)->update($walletAmount);
                        		}else{
                        			$payload['totalAmount'] = $payload['amount'];
                        			WalletAmount::create($payload);
                        		}
                        		
                        		/*** Update amount in sender wallet ***/
                        		$updatedAmountOfSender = $checkMoneyInSenderWallet->totalAmount - $payload['amount'];
                        		$walletAmountOfSender = array('totalAmount'=>$updatedAmountOfSender);
                        		WalletAmount::where('userID',$user->id)->update(array('totalAmount'=>$updatedAmountOfSender));
                                
                                $responseData['profileStatus'] = $user->status;
                                $responseData['amount'] = $payload['amount'];
                                $responseData['description'] = $payload['description'];
                                $responseData['transactionID'] = $payload['transactionID'];
                                $responseData['receiver'] = $checkUser->firstName." ".$checkUser->lastName;
                                $responseData['date'] = date("d M Y");
                                $responseData['time'] = parent::getUserCurrentTimeZone();
                                
                                //Send Notification start
                                	$receiver = Users::where('id',$getRequest->senderID)->first();
                                	$sender   = Users::where('id',$getRequest->receiverID)->first();
                                
                                	$data = [
                                		'receiverID'   => $getRequest['senderID'], 
                                		'senderID'     => $getRequest['receiverID'],
                                		'requestID'    => $getRequest['id'],
                                		'amount'       => $getRequest['amount'],
                                	];
                                	$title = "Payment Received Successful";
                                	$msg = "Hlo, ".$receiver->firstName." ".$receiver->lastName." You have received $".$getRequest->amount." amount from ".$sender->firstName." ".$sender->lastName.".";
                                	parent::sendNotification( $data, $title, $msg, 2 );
                                //Send Notification end
                                
                                $response = [    
                                    "status" => parent::statusCode()['success'],
                                    "message" => "Transaction successfully sent",
                                    "data"=>$responseData
                                ];
                            }else{
                                $response = [
                                    "status" => parent::statusCode()['error'],
                                    "message" => __('messages.wrong'),
                                ];
                            }
                        }
                    } 
    			}
    		}
    	}catch(\Exception $e){
    		$response = [
    			"status" => parent::statusCode()['error'],
    			"message" => $e->getMessage(),
    		];
    	}
    	return parent::sendResponse($response);
    }	
    
    public function declinePaymentRequest(Request $request){
        try{
            $validator = Validator::make($request->all(), 
                [
                    'requestID'  => 'required', 
                ],
                [
                    'requestID.required' => "Please enter request id"
                ]
            );
            if($validator->fails()){
                $response = ["status" => 400,"message" => $this->getValidationError($validator)];
            }else{
                $user = parent::decryptToken();
                $checkRequestStaus = Requests::where(['id'=>$request->requestID])->first();
                if( $checkRequestStaus->status == "2" ){
                    $response = ["status" => 200,"message" => "Request already declined."];
                }else{
                    $decline = Requests::where(['id'=>$request->requestID])->update(['status'=>"2"]);
                    if($decline){
                        $payload ['senderID'] = $user->id;
                        $payload ['receiverID'] = $checkRequestStaus->senderID;
                        $payload ['amount'] = $checkRequestStaus->amount;
                        $payload ['description'] = $checkRequestStaus->description;
                        $payload ['type'] = '3';
                        $payload ['requestDate'] = date('Y-m-d');
                        $payload ['status'] = '2';
                        $payload ['requestID'] = $request->requestID;
                        $createUpdatedRequest = Requests::create($payload);
                        $updatedRequest = Requests::where(['id'=>$request->requestID])->first();
                        $receiver = Users::where(['id'=>$checkRequestStaus->senderID])->first();
                        $sender = Users::where(['id'=>$checkRequestStaus->receiverID])->first();
                        
                        $responseData['amount'] = $checkRequestStaus['amount'];
                        $responseData['receiverName'] = $receiver['firstName']." ".$receiver['lastName'];
                        $responseData['description'] = $updatedRequest['description'];
                        $responseData['date'] = date("d M Y");
                        $responseData['time'] = parent::getUserCurrentTimeZone();
                        
                        //Send Notification start
                        	$data = [
                        		'receiverID'   => $checkRequestStaus['senderID'], 
                        		'senderID'     => $checkRequestStaus['receiverID'],
                        		'requestID'    => $checkRequestStaus['id'],
                        		'amount'       => $checkRequestStaus['amount'],
                        	];
                        	$title = "Payment Request Declined";
                        	$msg = "Hlo, ".$receiver->firstName." ".$receiver->lastName." Your request for amount $".$checkRequestStaus['amount']." to ".$sender->firstName." ".$sender->lastName." has been declined.";
                        	parent::sendNotification( $data, $title, $msg, 1 );
                        //Send Notification end
                        
                        $response = [
                            "status" => parent::statusCode()['success'],
                            "message" => __('messages.requestDeclined'),
                            "data" => $responseData,
                        ];
                    }else{
                        $response = [
                            "status" => parent::statusCode()['error'],
                            "message" => __('messages.wrong')
                        ];
                    }
                }
            }
        }catch(\Exception $e){
            $response = [
                "status" => parent::statusCode()['error'],
                "message" => $e->getMessage(),
            ];
        }
        return parent::sendResponse($response);
    }
    
    public function sendMoneyToPhoneNumber(Request $request){
        try{
    		$validator = Validator::make($request->all(), [
				'phoneNumber' => 'required',
				'amount'     => 'required',]
    		);
    
    		if($validator->fails()){
    			$response = ["status" => 400,"message" => $this->getValidationError($validator)];
    		}else{
    			$user = parent::decryptToken();
    			if( $user->status != "1" && $request->amount >= 1000 ){
    			    $response = [    
                    	"status" => parent::statusCode()['error'],
                    	"message" => __('messages.profileVerification'),
                    ];
    			}else{
    			    $payload = $request->all();
    			    $checkMoneyInSenderWallet = WalletAmount::where('userID',$user->id)->first();
                    if(empty($checkMoneyInSenderWallet)){
                        $response = [    
                        	"status" => parent::statusCode()['error'],
                        	"message" => __('messages.walletEmpty'),
                        ];
                    }else{
                        if($payload['amount'] > $checkMoneyInSenderWallet->totalAmount){
                            $response = [    
                                "status" => parent::statusCode()['error'],
                                "message" => __('messages.walletBalanceLow'),
                            ];
                        }else{
                            $checkUser = Users::where('phoneNumber',$payload['phoneNumber'])->first();
                            if($user->phoneNumber == $checkUser->phoneNumber){
                			    $response = [    
                                    "status" => parent::statusCode()['error'],
                                    "message" => "User not found",
                                ];
                			}else{
                			    if($payload['amount'] < 15){ //Phone no. transaction will be greater than or equal to 15
                			        $response = [    
                                        "status" => parent::statusCode()['error'],
                                        "message" => __('messages.lessTransactionPhoneNumber'),
                                    ];
                			    }else{
                			        $payload['senderID'] = $user->id;
                			        $payload['userID'] = $checkUser->id;
                                    $payload['receiverID'] = $checkUser->id;
                                    $payload['transactionID'] = $this->generateCode();
                                    $payload['paymentType'] = '2';
                                    $payload['type'] = '2';
                                    $payload['paymentStatus'] = 'paid';
                			        $createTransaction = Transactions::create($payload);
                                    if($createTransaction){
                                        Wallet::create($payload);
                                        /*** Add/Update amount in receiver wallet ***/
                                		$checkWallet = WalletAmount::where('userID',$checkUser->id)->first();
                                		if(!empty($checkWallet)){
                                			$updatedAmount = $checkWallet->totalAmount + $payload['amount'];
                                			$walletAmount = array('totalAmount'=>$updatedAmount);
                                			WalletAmount::where('userID',$checkUser->id)->update($walletAmount);
                                		}else{
                                			$payload['totalAmount'] = $payload['amount'];
                                			WalletAmount::create($payload);
                                		}
                                		
                                		/*** Update amount in sender wallet ***/
                                		$updatedAmountOfSender = $checkMoneyInSenderWallet->totalAmount - $payload['amount'];
                                		$walletAmountOfSender = array('totalAmount'=>$updatedAmountOfSender);
                                		WalletAmount::where('userID',$user->id)->update(array('totalAmount'=>$updatedAmountOfSender));
                                        
                                        $responseData['profileStatus'] = $user->status;
                                        $responseData['amount'] = $payload['amount'];
                                        $responseData['description'] = $payload['description'];
                                        $responseData['transactionID'] = $payload['transactionID'];
                                        $responseData['receiver'] = $checkUser->firstName." ".$checkUser->lastName;
                                        $responseData['date'] = date("d M Y");
                                        $responseData['time'] = parent::getUserCurrentTimeZone();
                                        
                                        //Send Notification start
                                        	$receiver = Users::where('id',$checkUser->id)->first();
                                        	$sender   = Users::where('id',$user->id)->first();
                                        
                                        	$data = [
                                        		'receiverID'   => $checkUser->id, 
                                        		'senderID'     => $user->id,
                                        		'requestID'    => null,
                                        		'amount'       => $payload['amount'],
                                        	];
                                        	$title = "Payment Received Successful";
                                        	$msg = "Hlo, ".$receiver->firstName." ".$receiver->lastName." You have received $".$payload['amount']." amount from ".$sender->firstName." ".$sender->lastName.".";
                                        	parent::sendNotification( $data, $title, $msg, 2 );
                                        //Send Notification end
                                
                                        $response = [    
                                            "status" => parent::statusCode()['success'],
                                            "message" => "Transaction successfully sent",
                                            "data"=>$responseData
                                        ];
                                    }else{
                                        $response = [
                                            "status" => parent::statusCode()['error'],
                                            "message" => __('messages.wrong'),
                                        ];
                                    }
                			    }
                			}
                        }
                    } 
    			}
    		}
    	}catch(\Exception $e){
    		$response = [
    			"status" => parent::statusCode()['error'],
    			"message" => $e->getMessage(),
    		];
    	}
    	return parent::sendResponse($response);
    }
    
    public function sendMoneyToQrCode(Request $request){
    	try{
    		$validator = Validator::make($request->all(), [
    				'referralCode' => 'required',
    				'amount' => 'required',
    			],
    			[
    				'referralCode.required' => 'Please select scanner',
    			]
    		);
    
    		if($validator->fails()){
    			$response = ["status" => 400,"message" => $this->getValidationError($validator)];
    		}else{
    			$user = parent::decryptToken();
                $payload = $request->all();
    			$checkUser = Users::where('referralCode',$request->referralCode)->first();
    			if(empty($checkUser)){
    				$response = [
    					"status" => parent::statusCode()['success'],
    					"message" => __('messages.dataNotFound'),
    				];
    			}else{
    			    if( $user->status != "1" && $request->amount >= 1000 ){
        				$response = [    
        					"status" => parent::statusCode()['error'],
        					"message" => __('messages.profileVerification'),
        				];
        			}else{
        			    $checkUser = Users::where('referralCode',$payload['referralCode'])->first();
                        if($user->referralCode == $checkUser->referralCode){
            			    $response = [    
                                "status" => parent::statusCode()['error'],
                                "message" => "User not found",
                            ];
            			}else{
            				$checkMoneyInSenderWallet = WalletAmount::where('userID',$user->id)->first();
            				if(empty($checkMoneyInSenderWallet)){
            					$response = [    
            						"status" => parent::statusCode()['error'],
            						"message" => __('messages.walletEmpty'),
            					];
            				}else{
            					if($payload['amount'] > $checkMoneyInSenderWallet->totalAmount){
            						$response = [    
            							"status" => parent::statusCode()['error'],
            							"message" => __('messages.walletBalanceLow'),
            						];
            					}else{
        							if($payload['amount'] < 20){ //Barcode/Scanner transaction will be greater than or equal to 20
        								$response = [    
        									"status" => parent::statusCode()['error'],
        									"message" => __('messages.lessTransactionScanner'),
        								];
        							}else{
        								$payload['senderID'] = $user->id;
        								$payload['userID'] = $checkUser->id;
        								$payload['receiverID'] = $checkUser->id;
        								$payload['transactionID'] = $this->generateCode();
        								$payload['paymentType'] = '1';
        								$payload['type'] = '2';
        								$payload['paymentStatus'] = 'paid';
        								$createTransaction = Transactions::create($payload);
        								if($createTransaction){
        									Wallet::create($payload);
        									/*** Add/Update amount in receiver wallet ***/
        									$checkWallet = WalletAmount::where('userID',$checkUser->id)->first();
        									if(!empty($checkWallet)){
        										$updatedAmount = $checkWallet->totalAmount + $payload['amount'];
        										$walletAmount = array('totalAmount'=>$updatedAmount);
        										WalletAmount::where('userID',$checkUser->id)->update($walletAmount);
        									}else{
        										$payload['totalAmount'] = $payload['amount'];
        										WalletAmount::create($payload);
        									}
        									
        									/*** Update amount in sender wallet ***/
        									$updatedAmountOfSender = $checkMoneyInSenderWallet->totalAmount - $payload['amount'];
        									$walletAmountOfSender = array('totalAmount'=>$updatedAmountOfSender);
        									WalletAmount::where('userID',$user->id)->update(array('totalAmount'=>$updatedAmountOfSender));
        									
        									$responseData['profileStatus'] = $user->status;
        									$responseData['amount'] = $payload['amount'];
        									$responseData['description'] = $payload['description'];
        									$responseData['transactionID'] = $payload['transactionID'];
        									$responseData['receiver'] = $checkUser->firstName." ".$checkUser->lastName;
        									$responseData['date'] = date("d M Y");
        									$responseData['time'] = parent::getUserCurrentTimeZone();
        									
        									//Send Notification start
                                            	$receiver = Users::where('id',$checkUser->id)->first();
                                            	$sender   = Users::where('id',$user->id)->first();
                                            
                                            	$data = [
                                            		'receiverID'   => $checkUser->id, 
                                            		'senderID'     => $user->id,
                                            		'requestID'    => null,
                                            		'amount'       => $payload['amount'],
                                            	];
                                            	$title = "Payment Received Successful";
                                            	$msg = "Hlo, ".$receiver->firstName." ".$receiver->lastName." You have received $".$payload['amount']." amount from ".$sender->firstName." ".$sender->lastName.".";
                                            	parent::sendNotification( $data, $title, $msg, 2 );
                                            //Send Notification end
                                        
        									$response = [    
        										"status" => parent::statusCode()['success'],
        										"message" => "Transaction successfully sent",
        										"data"=>$responseData
        									];
        								}else{
        									$response = [
        										"status" => parent::statusCode()['error'],
        										"message" => __('messages.wrong'),
        									];
        								}
        							}
            					}
            				} 
            			}
        			}
    			}
    		}
    	}catch(\Exception $e){
    		$response = [
    			"status" => parent::statusCode()['error'],
    			"message" => $e->getMessage(),
    		];
    	}
    	return parent::sendResponse($response);
    }
    
    public function scannedUserDetails(Request $request){
    	try{
    		$validator = Validator::make($request->all(), [
    				'referralCode' => 'required',
    			]
    		);
    
    		if($validator->fails()){
    			$response = ["status" => 400,"message" => $this->getValidationError($validator)];
    		}else{
    			$checkUser = Users::select('id','firstName','lastName','countryCode','phoneNumber','userProfile')->where('referralCode',$request->referralCode)->first();
    			if(!empty($checkUser)){
    				$response = [
    					"status" => parent::statusCode()['success'],
    					"message" => __('messages.dataFound'),
    					"data" => $checkUser,
    				];
    			}else{
    				$response = [
    					"status" => parent::statusCode()['success'],
    					"message" => __('messages.dataNotFound'),
    				];
    			}
    		}
    	}catch(\Exception $e){
    		$response = [
    			"status" => parent::statusCode()['error'],
    			"message" => $e->getMessage(),
    		];
    	}
    	return parent::sendResponse($response);
    }
    
    public function addMoneyToWallet(Request $request){
        try{
        	$validator = Validator::make($request->all(), [
        			'cardID'    => 'required',
        			'amount'    => 'required',
        			'stripeToken'    => 'required',
        		],
        		[
        			'cardID.required' => 'Please select card',
        		]
        	);
        
        	if($validator->fails()){
        		$response = ["status" => 400,"message" => $this->getValidationError($validator)];
        	}else{
        	    $user = parent::decryptToken();
        	    $payload = $request->all();
                $payload['userID'] = $user->id;
                $payload['email'] = $user->email;
                $payload['name'] = $user->firstName." ".$user->lastName;
                $payload['receiverID'] = $user->id;
                $payload['type'] = 1;
        		$add = Wallet::create($payload);
        		if($add){
                    $payload['walletID'] = $add->id;
                    $cardDetails = UserCards::where('userID',$user->id)->first();
                    //Create transaction in stripe
                    $createCharge = Stripe::createCharge($payload,$cardDetails);
                    if($createCharge['success'] == "1"){
                        /*** Add/Update amount in self wallet ***/
                        $checkWallet = WalletAmount::where('userID',$user->id)->first();
                        if(!empty($checkWallet)){
                            $updatedAmount = $checkWallet->totalAmount + $payload['amount'];
                            $walletAmount = array('totalAmount'=>$updatedAmount);
                            WalletAmount::where('userID',$user->id)->update($walletAmount);
                        }else{
                            $payload['totalAmount'] = $payload['amount'];
                            WalletAmount::create($payload);
                        }
                        
                        $payload['transactionID'] = $createCharge['transactionID'];
                        $payload['paymentStatus'] = 'paid';
                        $createTransaction = Transactions::create($payload);
                        $cardDetails = UserCards::where('id',$payload['cardID'])->first();
                        $cardNumber = parent::decryptDataInSecureForm($user->id,$cardDetails->cardNumber);
                        
                        $walletData['cardNumber'] = substr_replace($cardNumber, 'XXXX', 0, 4);
                        $walletData['transactionID'] = $payload['transactionID'];
                        $walletData['amount'] = $payload['amount'];
                        $walletData['date'] = date("d M Y");
                        $walletData['time'] = parent::getUserCurrentTimeZone();
                        
                        //Send Notification start
                        	$data = [
                        		'receiverID'   => $user->id, 
                        		'senderID'     => $user->id,
                        		'requestID'    => null,
                        		'amount'       => $payload['amount'],
                        	];
                        	$title = "Wallet Transaction Successful";
                        	$msg = "$".$payload['amount']." added successfully to your Wallet.";
                        	parent::sendNotification( $data, $title, $msg, 4 );
                        //Send Notification end
                                            
                        $response = [
                            "status" => parent::statusCode()['success'],
                            "message" => __('messages.moneyAddToWallet'),
                            "data" => $walletData,
                        ];
                    }else{
                        $response = [
                            "status" => parent::statusCode()['error'],
                            "message" => __('messages.wrong')
                        ];
                    }
        		}else{
        		    $response = [
                        "status" => parent::statusCode()['error'],
                        "message" => __('messages.wrong')
                    ];
        		}
        	}
        }catch(\Exception $e){
        	$response = [
        		"status" => parent::statusCode()['error'],
        		"message" => $e->getMessage(),
        	];
        }
        return parent::sendResponse($response);	
    }
    
    public function sendMoneyToBank(Request $request){
        try{
        	$validator = Validator::make($request->all(), [
        			'bankID' => 'required',
        			'amount'     => 'required',
        		],
        		[
        			'bankID.required' => 'Please select bank',
        		]
        	);
        
        	if($validator->fails()){
        		$response = ["status" => 400,"message" => $this->getValidationError($validator)];
        	}else{
        	    $user = parent::decryptToken();
        	    $payload = $request->all();
        	    $checkMoneyInSenderWallet = WalletAmount::where('userID',$user->id)->first();
                if(!empty($checkMoneyInSenderWallet)){
                    if($payload['amount'] > $checkMoneyInSenderWallet->totalAmount){
                        $response = [    
                            "status" => parent::statusCode()['error'],
                            "message" => __('messages.walletBalanceLow'),
                        ];
                    }else{
                        $getAccID = externalAccounts::where(['userID'=>$user->id,'id'=>$request->bankID,'isDelete'=>'0'])->first();
                	    if(!empty($getAccID->accountID)){
                    	    $payload['accountID'] = $getAccID->accountID; 
                    		$transferMoney = Stripe::transferMoneyToBank($payload);
                    		if($transferMoney['success'] == "1"){
                    		    /*** Update amount in self wallet ***/
                                $updatedAmountOfSender = $checkMoneyInSenderWallet->totalAmount - $payload['amount'];
                                $walletAmountOfSender = array('totalAmount'=>$updatedAmountOfSender);
                                WalletAmount::where('userID',$user->id)->update($walletAmountOfSender);
                                
                                $payload['receiverID'] = $user->id;
                                $payload['transactionID'] = parent::generateCode();
                                $payload['paymentStatus'] = 'paid';
                                $payload['type'] = 4;
                                $payload['cardID'] = $request->bankID;
                                $createTransaction = Transactions::create($payload);
                                $bankNumber = parent::decryptDataInSecureForm($user->id,$getAccID->accountNumber);
                                
                                $responseData['bankNumber'] = substr_replace($bankNumber, 'XXXX', 0, 4);
                                $responseData['transactionID'] = $payload['transactionID'];
                                $responseData['amount'] = $payload['amount'];
                                $responseData['date'] = date("d M Y");
                                $responseData['time'] = parent::getUserCurrentTimeZone();
                                
                                //Send Notification start
                                	$data = [
                                		'receiverID'   => $user->id, 
                                		'senderID'     => $user->id,
                                		'requestID'    => null,
                                		'amount'       => $payload['amount'],
                                	];
                                	$title = "Bank Transaction Successful";
                                	$msg = "$".$payload['amount']." added successfully to your Bank ending with ".$responseData['bankNumber'].".";
                                	parent::sendNotification( $data, $title, $msg, 5 );
                                //Send Notification end
                        
                                $response = [
                                    "status" => parent::statusCode()['success'],
                                    "message" => $transferMoney['message'],
                                    "data" => $responseData,
                                ];
                            }else{
                                $response = [
                                    "status" => parent::statusCode()['error'],
                                    "message" => __('messages.wrong')
                                ];
                            }
                	    }else{
                	        $response = [
                                "status" => parent::statusCode()['error'],
                                "message" => __('messages.bankNotAdded')
                            ];
                	    }
                    }
                }else{
                    $response = [    
                        "status" => parent::statusCode()['error'],
                        "message" => __('messages.walletEmpty'),
                    ];
                }
        	}
        }catch(\Exception $e){
        	$response = [
        		"status" => parent::statusCode()['error'],
        		"message" => $e->getMessage(),
        	];
        }
        return parent::sendResponse($response);	
    }
    
    public function homeSearchUser(Request $request){
        try{
    		$validator = Validator::make($request->all(), [
    				'search' => 'required',
    			],
    			[
    			    'search.required' => "Enter user name or phone number to search"    
    			]
    		);
    
    		if($validator->fails()){
    			$response = ["status" => 400,"message" => $this->getValidationError($validator)];
    		}else{
    		    $search = Users::homeSearchUser($request->search);
    			if($search->isNotEmpty()){
    				$response = [
    					"status" => parent::statusCode()['success'],
    					"message" => __('messages.dataFound'),
    					"data" => $search,
    				];
    			}else{
    				$response = [
    					"status" => parent::statusCode()['success'],
    					"message" => __('messages.dataNotFound'),
    					"data" => $search,
    				];
    			}
    		}
    	}catch(\Exception $e){
    		$response = [
    			"status" => parent::statusCode()['error'],
    			"message" => $e->getMessage(),
    		];
    	}
    	return parent::sendResponse($response);
    }
    
    public function homeScreenContacts(Request $request){
    	try{
    		$user = parent::decryptToken();
    		$limit_per_page	= 10;
		    $current_page	= $request->has('pageNo') ? $request->pageNo : 0;
		    $offset	= $current_page * $limit_per_page;
    		$checkTransactions = Transactions::userContacts($user->id,$limit_per_page,$offset);
    		if(!empty($checkTransactions)){
	            foreach($checkTransactions as $key => $checkTransaction){
	                if($checkTransaction->userID != NULL){
	                    $columns = ['id','firstName','lastName','phoneNumber','userProfile'];
    	                $getUser = Users::select($columns)->where('id',$checkTransaction->userID)->first();
    	                $checkTransactions[$key]->firstName = $getUser->firstName;
    	                $checkTransactions[$key]->lastName = $getUser->lastName;
    	                $checkTransactions[$key]->phoneNumber = $getUser->phoneNumber;
    	                $checkTransactions[$key]->userProfile = $getUser->userProfile;
	                }else{
	                    unset($checkTransactions[$key]);
	                }
	            }
	            
	            $response = [
                	"status" => parent::statusCode()['success'],
                	"message" => __('messages.dataFound'),
                	"data" => array_values($checkTransactions),
                ];
	        }else{
	            $response = [
                	"status" => parent::statusCode()['success'],
                	"message" => __('messages.dataNotFound'),
                	"data" => $checkTransactions,
                ];
	        }
    	}catch(\Exception $e){
    		$response = [
    			"status" => parent::statusCode()['error'],
    			"message" => $e->getMessage(),
    		];
    	}
    	return parent::sendResponse($response);
    }
    
    public function transactions(Request $request){
        try{
    		$user = parent::decryptToken();
    		$limit_per_page	= 10;
		    $current_page	= $request->has('pageNo') ? $request->pageNo : 0;
		    $offset	= $current_page * $limit_per_page;
		    
    		$walletBalance = WalletAmount::where('userID',$user->id)->first();
    		if(!empty($walletBalance->totalAmount)){
    		    $transactions['walletBalance'] = $walletBalance->totalAmount;
    		}else{
    		    $transactions['walletBalance'] = '0';
    		}
    		$columns = array('id','receiverID','cardID','transactionID','amount','type','created_at');
    		$getTransactions = DB::table('tbl_transactions')->select($columns)->whereIn('type',['1','4'])->
    		        where('receiverID',$user->id)->orderBy('id','DESC')->limit($limit_per_page)->offset($offset)->get();
    		if(!empty($getTransactions)){
    		    foreach($getTransactions as $key => $getTransaction){
    		        $getTransactions[$key]->date = date("d M Y",strtotime($getTransaction->created_at));
    		        if($getTransaction->type == "1"){
    		            $getTransactions[$key]->title = 'Money Added To Wallet';
    		            $cardDetails = UserCards::where('id',$getTransaction->cardID)->first();
    		            if(!empty($cardDetails)){
    		                $cardNumber = parent::decryptDataInSecureForm($getTransaction->receiverID,$cardDetails->cardNumber);
                            $getTransactions[$key]->accNumber = substr_replace($cardNumber, 'XXXX', 0, 4);
    		            }else{
    		                $getTransactions[$key]->accNumber = "";
    		            }
    		        }else{
    		            $getTransactions[$key]->title = 'Transfer To bank';
    		            $bankDetails = externalAccounts::where(['id'=>$getTransaction->cardID])->first();
    		            if(!empty($bankDetails)){
        		            $bankNumber = parent::decryptDataInSecureForm($getTransaction->receiverID,$bankDetails->accountNumber);
                            $getTransactions[$key]->accNumber = substr_replace($bankNumber, 'XXXX', 0, 4);
    		            }else{
    		                $getTransactions[$key]->accNumber = "";
    		            }
    		        }
    		    }
    		    $msg = "Data found";
    		    $transactions['transactions'] = $getTransactions;
    		}else{
    		    $msg = "Data not found";
    		    $transactions['transactions'] = $getTransactions;
    		}
    		
    		$response = [
                "status" => parent::statusCode()['success'],
                "message" => $msg,
                "data"   => $transactions
            ];
    	}catch(\Exception $e){
    		$response = [
    			"status" => parent::statusCode()['error'],
    			"message" => $e->getMessage(),
    		];
    	}
    	return parent::sendResponse($response);
    }
    
    public function transactionHistory(Request $request){
        try{
    		$validator = Validator::make($request->all(), [
    				'type' => 'required'
    			]
    		);
    
    		if($validator->fails()){
    			$response = ["status" => 400,"message" => $this->getValidationError($validator)];
    		}else{
    			$user = parent::decryptToken();
    			$limit_per_page	= 10;
    		    $current_page	= $request->has('pageNo') ? $request->pageNo : 0;
    		    $offset	= $current_page * $limit_per_page;
		    
    		    //if($request->type != "5" && $request->type != "6"){
    		        $getTransactionHistory = Transactions::getTransactionHistory($user->id,$request->type,$limit_per_page,$offset);
    		        if($getTransactionHistory->isNotEmpty()){
        			    foreach($getTransactionHistory as $key => $getTransactionHist){
        			        if($request->type == "0"){
            			        if($getTransactionHist->type == "2"){
            			            if($getTransactionHist->senderID == $user->id && $getTransactionHist->requestID == ""){
            			                $title = "Paid To";
            			                $userName = Users::where('id',$getTransactionHist->receiverID)->first();
            			                $content = $userName->firstName." ".$userName->lastName;
            			                $getTransactionHistory[$key]->profileImg = $userName->userProfile;
            			            }elseif($getTransactionHist->receiverID == $user->id && $getTransactionHist->requestID == ""){
            			                $title = "Received from";
            			                $userName = Users::where('id',$getTransactionHist->senderID)->first();
            			                $content = $userName->firstName." ".$userName->lastName;
            			                $getTransactionHistory[$key]->profileImg = $userName->userProfile;
            			            }elseif($getTransactionHist->receiverID == $user->id && $getTransactionHist->requestID != ""){
            			                $title = "Requested to";
            			                $userName = Users::where('id',$getTransactionHist->senderID)->first();
            			                $content = $userName->firstName." ".$userName->lastName;
            			                $getTransactionHistory[$key]->profileImg = $userName->userProfile;
            			            }elseif($getTransactionHist->senderID == $user->id && $getTransactionHist->requestID != ""){
            			                $title = "Requested by";
            			                $userName = Users::where('id',$getTransactionHist->receiverID)->first();
            			                $content = $userName->firstName." ".$userName->lastName;
            			                $getTransactionHistory[$key]->profileImg = $userName->userProfile;
            			            }
            			        }elseif($getTransactionHist->type == "1" || $getTransactionHist->type == "4"){
            			            if($getTransactionHist->type == "1"){
            			                $title = "Money Added To Wallet";
            			                $cardNumber = UserCards::where('id',$getTransactionHist->cardID)->first();
            			                $content = parent::decryptDataInSecureForm($user->id,$cardNumber->cardNumber);
            			                $getTransactionHistory[$key]->profileImg = "";
            			            }else{
            			                $title = "Transfer To Bank";
            			                $bankAccNumber = externalAccounts::where(['id'=>$getTransactionHist->cardID])->first();
            			                $content = parent::decryptDataInSecureForm($user->id,$bankAccNumber->accountNumber);
            			                $getTransactionHistory[$key]->profileImg = "";
            			            }
            			        }
        			        }elseif($request->type == "1"){
        			            $title = "Paid To";
        			            $userName = Users::where('id',$getTransactionHist->receiverID)->first();
    			                $content = $userName->firstName." ".$userName->lastName;
    			                $getTransactionHistory[$key]->profileImg = $userName->userProfile;
                			}elseif($request->type == "2"){
                			    $title = "Received from";
    			                $userName = Users::where('id',$getTransactionHist->senderID)->first();
    			                $content = $userName->firstName." ".$userName->lastName;
    			                $getTransactionHistory[$key]->profileImg = $userName->userProfile;
                			}elseif($request->type == "3"){
                			    $title = "Money Added To Wallet";
    			                $cardNumber = UserCards::where('id',$getTransactionHist->cardID)->first();
    			                $content = parent::decryptDataInSecureForm($user->id,$cardNumber->cardNumber);
    			                $getTransactionHistory[$key]->profileImg = "";
                			}elseif($request->type == "4"){
                			    $title = "Transfer To Bank";
    			                $bankAccNumber = externalAccounts::where(['id'=>$getTransactionHist->cardID])->first();
    			                $content = parent::decryptDataInSecureForm($user->id,$bankAccNumber->accountNumber);
    			                $getTransactionHistory[$key]->profileImg = "";
                			}elseif($request->type == "5"){
                			    $title = "Requested to";
    			                $userName = Users::where('id',$getTransactionHist->senderID)->first();
    			                $content = $userName->firstName." ".$userName->lastName;
    			                $getTransactionHistory[$key]->profileImg = $userName->userProfile;
                			}elseif($request->type == "6"){
                			    $title = "Requested by";
    			                $userName = Users::where('id',$getTransactionHist->receiverID)->first();
    			                $content = $userName->firstName." ".$userName->lastName;
    			                $getTransactionHistory[$key]->profileImg = $userName->userProfile;
                			}
                			    
        			        $getTransactionHistory[$key]->title = $title;
        			        $getTransactionHistory[$key]->content = $content;
        			        $getTransactionHistory[$key]->transactionDate = date("d M Y",strtotime($getTransactionHist->created_at));
        			    }
        			    
        			    $response = [
        					"status" => parent::statusCode()['success'],
        					"message" => __('messages.dataFound'),
        					"data" => $getTransactionHistory,
        				];
        			}else{
        				$response = [
        					"status" => parent::statusCode()['success'],
        					"message" => __('messages.dataNotFound'),
        					"data" => $getTransactionHistory,
        				];
        			}
    		   /* }else{
    		        if($request->type == "5"){
        			    $title = "Requested To";
        			    $getRequests = Requests::select('id','requestID',senderID','receiverID','amount','type','created_at','status')->where(['senderID'=>$user->id,'type'=>"1"])->get();
        			}else{
        			    $title = "Requested By";
        			    $getRequests = Requests::select('id','requestID','senderID','receiverID','amount','type','created_at','status')->where(['receiverID'=>$user->id,'type'=>"1"])->get();
        			}
        			
        			if($getRequests->isNotEmpty()){
        			    foreach($getRequests as $key => $getRequest){
        			        $getRequests[$key]->title = $title;
        			        
        			        if($getRequest->type == "1" && $request->type == "5"){
        			            $userName = Users::where('id',$getRequest->receiverID)->first();
        			        }else{
        			            $userName = Users::where('id',$getRequest->senderID)->first();
        			        }
            			    
        			        $getRequests[$key]->content = $userName->firstName." ".$userName->lastName;;
        			        $getRequests[$key]->profileImg = $userName->userProfile;
        			        $getRequests[$key]->cardID = 1; //Static
        			    }
        			    
        			    $response = [
        					"status" => parent::statusCode()['success'],
        					"message" => __('messages.dataFound'),
        					"data" => $getRequests,
        				];
        			}else{
        			    $response = [
        					"status" => parent::statusCode()['success'],
        					"message" => __('messages.dataNotFound'),
        					"data" => $getRequests,
        				];
        			}
    		    }*/
    		}
    	}catch(\Exception $e){
    		$response = [
    			"status" => parent::statusCode()['error'],
    			"message" => $e->getMessage(),
    		];
    	}
    	return parent::sendResponse($response);
    }
    
    public function transactionDetails(Request $request){
    	try{
    		$validator = Validator::make($request->all(), [
    			'otherUserID' => 'required_if:type,=,2',
    			'type' => 'required',
    		]);
    
    		if($validator->fails()){
    			$response = ["status" => 400,"message" => $this->getValidationError($validator)];
    		}else{
    			$user = parent::decryptToken();
    			$transactionDetails = Transactions::transactionDetails($request->otherUserID,$user->id,$request->type);
    			if(!empty($transactionDetails)){
    			    foreach($transactionDetails as $key => $transactionDetail){
    			        if($request->type == "2"){
    			            if($user->id == $transactionDetail->senderID){
    			                $title = "Send To";
    			                $isSender = "1";
    			            }elseif($user->id == $transactionDetail->receiverID){
    			                $title = "Received From";
    			                $isSender = "0";
    			            }
    			            
    			            if(!empty($transactionDetail->requestID)){
    			                $getRequest = Requests::where(['id'=>$transactionDetail->requestID])->first();
    			                $paymentStatus = $getRequest->status;
    			                $description = $getRequest->description;
    			                if($user->id == $transactionDetail->senderID){
    			                    $transactionType = "6";
    			                }else{
    			                    $transactionType = "5";
    			                }
    			            }else{
    			                $paymentStatus = 1;
    			                $description = "";
    			                if($user->id == $transactionDetail->senderID){
    			                    $transactionType = "1";
    			                }else{
    			                    $transactionType = "2";
    			                }
    			            }
    			            
    			            $transactionDetails[$key]->paymentStatus = $paymentStatus;
    			            $transactionDetails[$key]->desc = $description;
    			            $OtherUser = Users::where('id',$request->otherUserID)->first();
			                $content = $OtherUser->firstName." ".$OtherUser->lastName;
			                if(!empty($OtherUser->userProfile)){
			                    $transactionDetails[$key]->profileImg = $OtherUser->userProfile;
			                }else{
			                    $transactionDetails[$key]->profileImg = "";
			                }
			                $otherContent = $OtherUser->phoneNumber;
    			        }elseif($request->type == "1"){
    			            $isSender = "0";
    			            $title = "Added To Wallet From";
    			            $selfUser = Users::where('id',$user->id)->first();
    			            $content = $selfUser->email;
    			            if(!empty($selfUser->userProfile)){
			                    $transactionDetails[$key]->profileImg = $selfUser->userProfile;
			                }else{
			                    $transactionDetails[$key]->profileImg = "";
			                }
			                $transactionType = "3";
    			            $cardNumber = UserCards::where('id',$transactionDetail->cardID)->first();
    			            $otherContent = parent::decryptDataInSecureForm($user->id,$cardNumber->cardNumber);
    			        }elseif($request->type == "4"){
    			            $isSender = "0";
    			            $transactionType = "4";
    			            $title = "Added To Bank";
    			            $selfUser = Users::where('id',$user->id)->first();
    			            $content = $selfUser->email;
    			            if(!empty($selfUser->userProfile)){
			                    $transactionDetails[$key]->profileImg = $selfUser->userProfile;
			                }else{
			                    $transactionDetails[$key]->profileImg = "";
			                }
    			            $bankAccNumber = externalAccounts::where(['id'=>$transactionDetail->cardID])->first();
    			            $otherContent = parent::decryptDataInSecureForm($user->id,$bankAccNumber->accountNumber);
    			        }
    			        
    			        $transactionDetails[$key]->transactionType = $transactionType;
    			        $transactionDetails[$key]->isSender = $isSender;
    			        $transactionDetails[$key]->title = $title;
        			    $transactionDetails[$key]->content = $content;
        			    $transactionDetails[$key]->otherContent = $otherContent;
        			    $transactionDetails[$key]->transactionDateTime = date("d M",strtotime($transactionDetail->created_at))." | ".parent::getUserSavedTimeZone($transactionDetail->created_at);
    			    }
    			    
    				$response = [
    					"status" => parent::statusCode()['success'],
    					"message" => __('messages.dataFound'),
    					"data" => $transactionDetails,
    				];
    			}else{
    				$response = [
    					"status" => parent::statusCode()['success'],
    					"message" => __('messages.dataNotFound'),
    					"data" => $transactionDetails,
    				];
    			}
    		}
    	}catch(\Exception $e){
    		$response = [
    			"status" => parent::statusCode()['error'],
    			"message" => $e->getMessage(),
    		];
    	}
    	return parent::sendResponse($response);
    }
    
    public function checkUsers(Request $request){
        try{
    		$validator = Validator::make($request->all(), [
				'contactsList' => 'required',
			]);
    		if($validator->fails()){
    			$response = ["status" => 400,"message" => $this->getValidationError($validator)];
    		}else{
    			$contactsListsJson = json_decode($request->contactsList,true);
    			foreach($contactsListsJson as $key => $contactsList){
                    $checkUsers = Users::where('phoneNumber',$contactsList['phoneNumber'])->first();
                    if(!empty($checkUsers)){
                        $contactsListsJson[$key]['isAppUser'] = "1";
                    }else{
                        $contactsListsJson[$key]['isAppUser'] = "0";
                    }
    			}
    			
    			$response = [
                	"status" => parent::statusCode()['success'],
                	"message" => __('messages.dataFound'),
                	"data" => $contactsListsJson,
                ];
    		}
    	}catch(\Exception $e){
    		$response = [
    			"status" => parent::statusCode()['error'],
    			"message" => $e->getMessage(),
    		];
    	}
    	return parent::sendResponse($response);
    }
    
    public function getNotifications(Request $request){
    	try{
			$user = parent::decryptToken();
			$getNotifications = Notifications::where('receiverID',$user->id)->orderBy('id','DESC')->get();
			if($getNotifications->isNotEmpty()){
			    foreach($getNotifications as $key => $getNotification){
			        $getNotifications[$key]->notificationTime = date("Y-m-d H:i:s",strtotime($getNotification->created_at));
			    }
				$response = [
					"status" => parent::statusCode()['success'],
					"message" => __('messages.dataFound'),
					"data" => $getNotifications,
				];
			}else{
				$response = [
					"status" => parent::statusCode()['success'],
					"message" => __('messages.dataNotFound'),
					"data" => $getNotifications,
				];
			}
    	}catch(\Exception $e){
    		$response = [
    			"status" => parent::statusCode()['error'],
    			"message" => $e->getMessage(),
    		];
    	}
    	return parent::sendResponse($response);
    }
    
    public function deleteAccount(Request $request){
    	try{
			$user = parent::decryptToken();
			$checkUserWalletAmount = WalletAmount::where('userID',$user->id)->first();
			if(!empty($checkUserWalletAmount) && $checkUserWalletAmount->totalAmount != 0){
			    $response = [    
                    "status" => parent::statusCode()['error'],
                    "message" => __('messages.walletBalanceWithdraw'),
                ];
			}else{
			    //Unlink files & Images
    			if(!empty($user->userProfile)){ //Profile Image
    			    parent::unlinkFile('users',$user->userProfile);
    			}
    			
    			if(!empty($user->qrCode)){ //QrCode qrCodes
    			    if (file_exists($user->qrCode)) {
        			   $file_path = public_path().'/qrCodes/'.$user->qrCode;
        			   unlink($file_path);
    			    }
    			}
    			
    			$getBankDocs = externalAccounts::where(['userID'=>$user->id])->get();
    			if($getBankDocs->isNotEmpty()){
    			    foreach($getBankDocs as $getBankDoc){
    			        if( !empty($getBankDoc->frontIdentity) && !empty($getBankDoc->backIdentity) ){ //Bank Docs.
            			    parent::unlinkFile('externalAccounts',$getBankDoc->frontIdentity);
            			    parent::unlinkFile('externalAccounts',$getBankDoc->backIdentity);
            			}
    			    }
    			}
    			
    		    $user->tokens()->delete();
    			$delete = Users::where('id',$user->id)->delete();
    			if($delete){
    			    $response = [
                    	"status" => parent::statusCode()['success'],
                    	"message" => __('messages.accountDelete'),
                    ];
    			}else{
    			    $response = [
                        "status" => parent::statusCode()['error'],
                        "message" => __('messages.wrong')
                    ];
    			} 
			}
    	}catch(\Exception $e){
    		$response = [
    			"status" => parent::statusCode()['error'],
    			"message" => $e->getMessage(),
    		];
    	}
    	return parent::sendResponse($response);
    }	
    
}
?>