<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Mail;
use App\Mail\verifyEmail;
use DB;
use App\Models\Wallet;
use App\Models\Transactions;
use App\Models\Users;
use App\Models\Notifications;
use App\Helpers\Stripe;
use URL;

use SimpleSoftwareIO\QrCode\Facades\QrCode;
 
class Controller extends BaseController
{

    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
    
    protected $folder = 'users';
    protected $documents = 'documents';
    protected $identityFront = 'identityFront';
    protected $identityBack = 'identityBack';
    
    public function statusCode(){
        return [
            "success" => (integer) getenv('SUCCESS_STATUS'),
            "error"   => (integer) getenv('ERROR_STATUS')
        ];
    }
    
    public function sendResponse($result){
        return response()->json($result, $result['status']);
    }

    public function getValidationError ( $validate ) { 
		$return = false;
		$errors = $validate->messages()->all();
		if ( ! empty ( $errors ) ) {
			foreach ( $errors as $error ) { 
				$return	=  $error;
				break;
			}
		}
		return $return;
	}
	
    public function getUserIp(){
        $ip = $_SERVER['REMOTE_ADDR'];
        $ipdat = @json_decode(file_get_contents("http://www.geoplugin.net/json.gp?ip=" . $ip));
        return $ipdat->geoplugin_timezone;
    }
    
    public function getUserCurrentTimeZone(){
        date_default_timezone_set($this->getUserIp());
        return date('H:i A',time());
    }
    
    public function getUserSavedTimeZone($created_at){
        date_default_timezone_set($this->getUserIp());
        return date('H:i A',strtotime($created_at .' UTC'));
    }
    
    //Gmail SMTP
    public function sendEmail($email,$data){   
        try{
            return Mail::to($email)->send(new verifyEmail($data));
        }catch(\Exception $e){
            return $response = [
                "status" => '400',
                "message" => $e->getMessage()
            ];
        }
    }
	
	//Twilio sms otp start
	public function sendPhoneOtp ( $number = '' ) {
        try{
            $return = array ( 'status'	=> 0, 'msg' => 'OTP not send try after sometime.', 'http_status' => 400 );
        	$ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://verify.twilio.com/v2/Services/'.env('TWILIO_VERIFY_SERVICE_SID').'/Verifications');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/x-www-form-urlencoded',
            ]);
            curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
            curl_setopt($ch, CURLOPT_USERPWD, env('TWILIO_ACCOUNT_SID').':'.env('TWILIO_AUTH_TOKEN'));
            curl_setopt($ch, CURLOPT_POSTFIELDS, 'To=%2B'.$number.'&Channel=sms&FriendlyName=Encro&DefaultTemplateSid=HJ4d9c5db569029bedab5b28ab79f4cc8d&From=+12685555555');
            $response = curl_exec($ch);
            curl_close($ch);
        	if ( ! empty ( $response ) ) {
        		$result = json_decode ( $response );
        		$otpSendDate = date("Y-m-d",strtotime($result->date_created));
        		$otpSendCountInDay = count($result->send_code_attempts);
        		$data = ['otpSendDate'=>$otpSendDate,'otpSendCountInDay'=>$otpSendCountInDay];
        		if ( isset ( $result->status ) && ( $result->status == 'pending' ) ) {
        			$return = array ( 'status'	=> 1, 'msg' => 'OTP sent successfully.', 'http_status' => 200, 'data' => $data );
        		}
        	}
        	return $return;
        }catch(\Exception $e){
            return $response = ["status" => '400',"message" => $e->getMessage()];
        }
    }
    
    public function verifyPhoneOtp ( $number = '', $code = '' ) {
        try{
        	$return = array ( 'status'	=> 0, 'msg' => 'Invalid/expired otp.', 'http_status' => 400 );
        	$ch = curl_init();
        	curl_setopt($ch, CURLOPT_URL, 'https://verify.twilio.com/v2/Services/'.env('TWILIO_VERIFY_SERVICE_SID').'/VerificationCheck');
        	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        	curl_setopt($ch, CURLOPT_HTTPHEADER, [
        		'Content-Type: application/x-www-form-urlencoded',
        	]);
        	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        	curl_setopt($ch, CURLOPT_USERPWD, env('TWILIO_ACCOUNT_SID').':'.env('TWILIO_AUTH_TOKEN'));
        	curl_setopt($ch, CURLOPT_POSTFIELDS, 'To=%2B'.$number.'&Code='.$code);
        	$response = curl_exec($ch);
        	curl_close($ch);
        	if ( ! empty ( $response ) ) {
        		$result = json_decode ( $response );
        		if ( isset ( $result->status ) && ( $result->status == 'approved' ) ) {
        			$return = array ( 'status'	=> 1, 'msg' => 'OTP verified successfully.', 'http_status' => 200 );
        		}
        	}
        	return $return;
        }catch(\Exception $e){
            return $response = ["status" => '400',"message" => $e->getMessage()];
        }
    }
    //Twilio sms otp end
    
    protected function encryptToken($user){
        return $user->createToken(getenv('TOKEN_KEY'))->plainTextToken;
    }
    
    protected function decryptToken(){
        return Auth::user();    
    }
    
    protected function generateQrCode($refCode){
        // Generate QR code with the User unique referral code
        QrCode::size(1000)->format('png') ->merge('/public/admin/assets/images/encro_logo.png')->errorCorrection('M')
                ->generate($refCode,public_path('/qrCodes/').$refCode.'.png');
        return $refCode.'.png';
    }
    
    function generateCode(){
        $code = '';
        $limit = 20;
        for($i = 0; $i < $limit; $i++) { 
            $code .= mt_rand(0, 9); 
        }
        return $code;
    }
    
    protected function uploadSingleFile($folder,$request,$image){
        try{
            $file = $request->file($image);
            $filename = time().uniqid().$file->getClientOriginalName();
            $basename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            /*$filename = time().'_'.$request->$image->hashName();
            $basename = pathinfo($request->$image->getClientOriginalName(), PATHINFO_FILENAME);*/
            $filepath = $request->file($image)->storeAs("uploads/$folder",$filename,'public');
            if($filepath){
                return ["success" => 1,"filename" => $filename,"basename" => $basename];
            }else {
                return ["success" => 0, "message" => "Something wrong in upload file"];
            }
        }catch(\Exception $e){
            return $response = [
                "status" => parent::statusCode()['error'],
                "message" => $e->getMessage(),
            ];
        }
    }
    
    protected function unlinkFile($folder,$file){
        if(Storage::exists('public/uploads/'.$folder.'/'.$file)){
            Storage::delete('public/uploads/'.$folder.'/'.$file);
            $response = [
                'status' => 200,
                'message' => __('messages.fileDeleted'),
            ];
        }else{
            $response = [
                'status' => 400,
                'message' => __('messages.fileNotExist'),
            ];
        }  
        return $response;
    }
    
    protected function encryptDataInSecureForm($userID,$value){
        $source = getenv('APP_KEY');
        $key = $source;
        $iv = substr($source,0,16);
        $encrypted_userID = openssl_encrypt($userID, 'aes-256-cbc', $key, OPENSSL_RAW_DATA, $iv);
        $EID =  base64_encode($encrypted_userID);
        $ivID = substr($EID,0,16);
        $exectSourceID = $iv.$ivID;
        $encrypted_data = openssl_encrypt($value, 'aes-256-cbc', $exectSourceID, OPENSSL_RAW_DATA, $iv);
        return base64_encode($encrypted_data);
    }
    
    protected function decryptDataInSecureForm($userID,$code){
        $source = getenv('APP_KEY');
        $key = $source;
        $iv = substr($source,0,16);
        $encrypted_userID = openssl_encrypt($userID, 'aes-256-cbc', $key, OPENSSL_RAW_DATA, $iv);
        $EID =  base64_encode($encrypted_userID);
        $value = base64_decode($code);
        $ivID = substr($EID,0,16);
        $exectSourceID = $iv.$ivID;
        $data = openssl_decrypt($value, 'aes-256-cbc', $exectSourceID, OPENSSL_RAW_DATA, $iv);
        return $data;
    }
    
    public static function stripeCredenatils(){
        \Stripe\Stripe::setApiKey(env('STRIPE_SK'));
	}
	
	public function sendNotification($data, $title, $body, $type){
	    date_default_timezone_set('UTC');
        /***
            0=Payment request sent,1=Payment request decline,2=Successful payment,3=Automatic request decline on no action, 
            4=Amount added to wallet, 5=Transfer To Bank
        ***/
        
        $user = DB::table('tbl_users')->where( ['id' => $data['receiverID']] )->first();
        $notificationData = array(
            'receiverID'    => $data['receiverID'], 
            'senderID'      => $data['senderID'],
            'requestID'     => $data['requestID'],
            'amount'        => $data['amount'],
            'type'          => $type,
            'title'         => $title,
            'message'       => $body,
        );
        Notifications::create( $notificationData );
        
        /*$url = 'https://fcm.googleapis.com/fcm/send';
		$fields = array (
			'to'	=> $user->deviceToken,
			'notification' => array (
				"title" => $title,
				"body" => ((isset($body))?$body:''),
				"type"		=> $type,
				"sound"		=> 'default'
			),
			'data' => array (
				"title" => $title,
				"body" => ((isset($body))?$body:''),
				"type"		=> $type
			),
			"content_available"	=> false
		);
		$headers = array (
            'Authorization: key='.getenv('FCM_SERVER_KEY'),
            'Content-Type: application/json'
        );
		$ch = curl_init ();
		curl_setopt ( $ch, CURLOPT_URL, $url );
		curl_setopt ( $ch, CURLOPT_POST, true );
		curl_setopt ( $ch, CURLOPT_HTTPHEADER, $headers );
		curl_setopt ( $ch, CURLOPT_RETURNTRANSFER, true );
		curl_setopt ( $ch, CURLOPT_POSTFIELDS, json_encode ( $fields ) );
		$result = curl_exec ( $ch );
		$resultsArray = json_decode($result);
        $success = $resultsArray->success;
		curl_close ( $ch );
		return $result;*/ 
    }
    
    // Bank api's start 
    public function createConnectedAccount($payload){
        try{
            $stripe = $this->stripeCredenatils();
            $payload['country'] = env('STRIPE_country');
            $payload['currency'] = env('STRIPE_currency');
            $createAccount = Stripe::createAccount($payload); 
            if($createAccount['success'] == 1){
                $createAccount['accountID'];
                $accountID = $createAccount['accountID'];
                $response = ["success" => 1,"accountID" => $accountID,"message" => "Account successfully created"];
            }else{
                $response = ["success" => 0,"message" => $createAccount['message']];
            }
        }catch(Exception $e){
            $response = [
                'success' => 0,
                'message' => $e->getMessage(),
            ];
        }
        return $response;
    }   
    
    public function updateConnectedAccount($payload,$accountID){
        try{
            $stripe = $this->stripeCredenatils();
            $payload['country'] = env('STRIPE_country');
            $payload['currency'] = env('STRIPE_currency');
            $createAccount = Stripe::updateConnectAccount($payload,$accountID);
            if($createAccount['success'] == 1){
                //$accountID = $createAccount['accountID'];
                $response = ["success" => 1,"accountID" => $accountID,"message" => "Account successfully created"];
            }else{
                $response = ["success" => 0,"message" => $createAccount['message']];
            }
        }catch(Exception $e){
            $response = [
                'success' => 0,
                'message' => $e->getMessage(),
            ];
        }
        return $response;
    } 
    
    public function userIdentityCheck($accountID,$request){
        $stripe = $this->stripeCredenatils();
        $data = Stripe::retrieveAccountDetailFromStripe($accountID);
        $verify = $data['individual']['verification']['status'];
        if($verify == 'verified'){
            $response = ["success" => 0,"message" => "Your documents has verified so you can not change it now"];       
        }else{
            $uploadedFileFront = $this->uploadSingleFile("externalAccounts",$request,"frontIdentity");
            if($uploadedFileFront['success'] == 1){
                $uploadedFileBack = $this->uploadSingleFile("externalAccounts",$request,"backIdentity");
                if($uploadedFileBack['success'] == 1){
                    $fileVerify  = Stripe::createFileVerificationFront($accountID,$uploadedFileFront['filename'],$uploadedFileBack['filename']);
                    if($fileVerify['success'] == 1){
                        $accountPayload = 
                        [
                            "frontIdentity" => $uploadedFileFront['filename'],
                            "backIdentity" => $uploadedFileBack['filename'],
                        ];
                        $response = [
                            "data" => $accountPayload,
                            "success" => 1,
                            "message" => "Your document has been uploaded successfully."];
                    }else{
                        $response = ["success" => 0,"message" => $fileVerify['message']];
                    } 
                }else{
                    $response = ["success" => 0,"message" => "Back upload image error"];
                }
            }else{
                $response = ["success" => 0,"message" => "Front upload image error"];
            }
        }   
        return $response; 
    }
    
    public function createBankOfConnectedAccount($payload,$accountID){
        try{
            $stripe = $this->stripeCredenatils();
            $payload['country'] = env('STRIPE_country');
            $payload['currency'] = env('STRIPE_currency');
            $bankAccount = Stripe::createBankOfConnectedAccountUser($payload);
            if($bankAccount['success'] == 1){
                $TokenID = $bankAccount['tokenID'];
                $externalAccount = Stripe::createExternalAccountOfUser($TokenID,$accountID);
                if($externalAccount['success'] == 1){
                   $response = ["success" => 1,"message" => "Bank account added successfully"];
                }else{
                    $response = ["success" => 0,"message" => $externalAccount['message']];
                }
            }else {
                $response = ["success" => 0,"message" => $bankAccount['message']];
            }
        }catch(\Exception $e){
            $response = [
                'success' => 0,
                'message' => $e->getMessage(),
            ];
        }
        return $response;
    }
    
    public function deleteBankOfConnectedAccount($accountID){
        try{
            $stripe = $this->stripeCredenatils();
            $deleteAccount = Stripe::deleteBank($accountID);
            if($deleteAccount['success'] == 1){
                $response = ["success" => 1,"message" => $deleteAccount['message']];
            }else {
                $response = ["success" => 0,"message" => $deleteAccount['message']];
            }
        }catch(\Exception $e){
            $response = [
                'success' => 0,
                'message' => $e->getMessage(),
            ];
        }
        return $response;
	}

    //Add new bank flow start
    public function userDocsCheck($accountID,$request){
        $stripe = $this->stripeCredenatils();
        $data = Stripe::retrieveAccountDetailFromStripe($accountID);
        $verify = $data['individual']['verification']['status'];
        if($verify == 'verified'){
            $response = ["success" => 0,"message" => "Your documents has verified so you can not change it now"];       
        }else{
            $fileVerify  = Stripe::createFileVerificationFront($accountID,$request['frontIdentity'],$request['backIdentity']);
            if($fileVerify['success'] == 1){
                $accountPayload = 
                [
                    "frontIdentity" => $request['frontIdentity'],
                    "backIdentity"  => $request['backIdentity'],
                ];
                $response = [
                    "data" => $accountPayload,
                    "success" => 1,
                    "message" => "Your document has been uploaded successfully."
                ];
            }else{
                $response = ["success" => 0,"message" => $fileVerify['message']];
            } 
        }  
        return $response; 
    }
    //Add new bank flow end
     // Bank api's end 
    
}
	