<?php 
namespace App\Http\Traits;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Validator;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Auth;
use Str;
use Twilio\Rest\Client;
use App\Models\Users;
use App\Models\WalletAmount;

trait AuthTrait
{
    
    protected function validator(array $data){
        return Validator::make($data, 
            [
                'email' => ['email','required','unique:tbl_users'],
                'password' => ['required'],
            ],
            [
                'email.email' => 'Please enter valid email address'
            ]
        );
    }
    
    protected function register(Request $request){
        try{
            $controller = new Controller();
            $payload = $request->all();
            $validate = $this->validator($payload);
            if($validate->fails()){
                $message = $validate->messages()->first('email') ? $validate->messages()->first('email') : $validate->messages()->first('password');
                $response = [
                    "status" => $controller::statusCode()['error'],
                    "message" => $message
                ];    
            }else{
                $payload['password'] = bcrypt($payload['password']);
                $payload['isTrack'] =1 ;
                $refCode = Str::Random(10);
                $qrCode = $controller->generateQrCode($refCode);
                $payload['referralCode'] = $refCode;
                $payload['qrCode'] = $qrCode;
                $payload['otp'] = '1234';
                $payload['chat_token'] = substr(md5(microtime()), 0, 10);
                
                $user = Users::create($payload);
                $token = $controller->encryptToken($user);
                if($user){
                    $response = [
                        "data" => $user,
                        "token" => $token,
                        "status" => $controller::statusCode()['success'],
                        "message" => __('messages.registerSuccess')
                    ] ;
                }else{
                    $response = [
                        "status" => $controller::statusCode()['error'],
                        "message" => __('messages.wrong')
                    ];
                }
            }
        }catch(\Exception $e){
            $response = [
                "status" => $controller::statusCode()['error'],
                "message" => $e->getMessage()
            ];
        }
        return $controller::sendResponse($response);
    } 
    
    protected function login(Request $request){
        try{
            $controller = new Controller();
            $validator = Validator::make($request->all(), [
                'email' => ['email','required'],
                'password' => ['required'],
            ]);
            if($validator->fails()){
                $message = $validator->messages()->first('email') ? $validator->messages()->first('email') : $validator->messages()->first('password');
                $response = [
                    "status" => $controller::statusCode()['error'],
                    "message" => $message
                ];
            }else{
                $payload = $request->except(['email','password']);
                $isAuth = Auth::guard('appusers')->attempt(['email' => $request->email,'password' => $request->password]);
                if($isAuth){
                    $user = Auth::guard('appusers')->user();
                    if($user->isSuspend == "0"){
                        $payload['chat_token'] = substr(md5(microtime()), 0, 10);
                        Users::where(['id' => $user->id])->update($payload);
                        $userData = Users::where('id',$user->id)->first();
                        $getWalletAmount = WalletAmount::where('userID',$user->id)->first();
                        if(!empty($getWalletAmount->totalAmount)){
                            $userData['walletAmount'] = $getWalletAmount->totalAmount;
                        }else{
                            $userData['walletAmount'] = "0";
                        }
                        $token = $controller->encryptToken($userData);
                        $response = 
                        [
                            'data' => $userData,
                            'token' => $token,
                            "status" => $controller::statusCode()['success'],
                            "message" => __('messages.loginSuccess')
                        ];
                    }else{
                        $response = [
                            "status" => $controller::statusCode()['error'],
                            "message" => __('messages.loginDeactivate')
                        ];
                    } 
                }else{
                    $response = [
                        "status" => $controller::statusCode()['error'],
                        "message" => __('messages.loginFailed')
                    ];
                }   
            }
        }catch(\Exception $e){
            $response = [
                "status" => $controller::statusCode()['error'],
                "message" => $e->getMessage()
            ];
        }
        return $controller::sendResponse($response);
    }
     
    protected function resendOTP(Request $request){
        try{
            $controller = new Controller();
            $user = $controller->decryptToken();
            if($user){
                $payload['otp'] = '1234';
                Users::where(['id' => $user->id])->update($payload);
                $response = [
                    "status" => $controller::statusCode()['success'],
                    "message" => __('messages.otpresend')
                ];
            }else{
                $response = [
                    "status" => $controller::statusCode()['error'],
                    "message" => __('messages.dataNotFound')
                ];
            }
            /*if($user->otpSendDate == date("Y-m-d") && $user->otpSendCountInDay > 3){
                $response = [
                    "status" => $controller::statusCode()['error'],
                    "message" => __('messages.otpResendLimitReached')
                ];
            }else{
                $phoneNumber = "+".$user->countryCode." ".$user->phoneNumber;
                $sendPhoneOtp = $this->sendPhoneOtp($phoneNumber);
                if($sendPhoneOtp['status'] == 1){
                    $payload['isOtpSent'] = 1;
                    $payload['otpSendDate'] = $sendPhoneOtp['data']['otpSendDate'];
                    $payload['otpSendCountInDay'] = $sendPhoneOtp['data']['otpSendCountInDay'];
                    Users::where(['id' => $user->id])->update($payload);
                    $response = [
                        "status" => $controller::statusCode()['success'],
                        "message" => __('messages.otpresend')
                    ];
                }else{
                    $response = [
                        "status" => $controller::statusCode()['error'],
                        "message" => __('messages.dataNotFound')
                    ];
                }
            }*/
        }catch(\Exception $e){
            $response = [
                "status" => $controller::statusCode()['error'],
                "message" => $e->getMessage()
            ];
        }
        return $controller::sendResponse($response);
    }
    
    protected function verifyPhoneNumber(Request $request){
        try{
            $controller = new Controller();
            $user = $controller->decryptToken();
            $verify = Users::where(['id' => $user->id,"otp" => $request->otp])->first();
            if(!empty($verify)){
                Users::where('id',$user->id)->update(['isVerify' => 1,'isTrack' => 4,'otp'=>""]);
                $userData = Users::where('id',$user->id)->first();
                $response = [
                    "data" => $userData, 
                    "token" => $controller->encryptToken($userData),
                    "status" => $controller->statusCode()['success'],
                    "message" => __('messages.verifyDone')
                ];
            }else{
                $response = [
                    "status" => $controller->statusCode()['error'],
                    "message" => __('messages.otpIncorrect')
                ];
            }
            
            /*$phoneNumber = "+".$user->countryCode." ".$user->phoneNumber;
            $verifyPhoneOtp = $this->verifyPhoneOtp($phoneNumber,$request->otp);
            if($verifyPhoneOtp['status'] == 1){
                Users::where('id',$user->id)->update(['isVerify' => 1,'isTrack' => 4,'otp'=>""]);
                $userData = Users::where('id',$user->id)->first();
                $response = [
                    "data" => $userData, 
                    "token" => $controller->encryptToken($userData),
                    "status" => $controller->statusCode()['success'],
                    "message" => __('messages.verifyDone')
                ];
            }else{
                $response = [
                    "status" => $controller->statusCode()['error'],
                    "message" => __('messages.otpIncorrect')
                ];
            }*/
        }catch(\Exception $e){
            $response = [
                "status" => $controller::statusCode()['error'],
                "message" => $e->getMessage()
            ];
        }
        return $controller->sendResponse($response);
    }
    
    protected function logout(Request $request){
        try{
            $controller = new Controller();
            $user = $controller->decryptToken();
            $logout = Users::where(['id' => $user->id])->update(["deviceToken" => NULL, "deviceType" => NULL]);
            if($logout){
                $response = 
                [
                    "status" => $controller::statusCode()['success'],
                    "message" => __('messages.logout')
                ]; 
            }else{
                $response = [
                    "status" => $controller::statusCode()['error'],
                    "message" => __('messages.wrong')
                ];
            }
        }catch(\Exception $e){
            $response = [
                "status" => $controller::statusCode()['error'],
                "message" => $e->getMessage()
            ];
        }
        return $controller::sendResponse($response);
    }
    
    protected function forgotPassword(Request $request){
        try{
            $controller = new Controller();
            $checkEmail = Users::where(["email" =>$request->email])->first();
            if(!empty($checkEmail)){
                $otp = substr(str_shuffle("0123456789"), 0, 4);
                $db['otp'] = $otp;
                Users::where('email',$request->email)->update($db);
                $data['title'] = 'Hi';
                $data['regards'] = getenv('ADMIN_EMAIL');
                $data['subject'] = 'Forgot Password';
                $data['type'] = 1;
                $data['otp'] = $otp;
                $data['message'] = 'Please use the below otp to reset your account password.';
                $sendEmail = parent::sendEmail($request->email,$data);
                $response = [
                    "status" => parent::statusCode()['success'],
                    "message" => __('messages.sendOtp'),
                ]; 
            }else{
                $response = [
                    "status" => $controller->statusCode()['error'],
                    "message" => __('messages.notAssociate')
                ];
            }
        }catch(\Exception $e){
            $response = [
                "status" => $controller::statusCode()['error'],
                "message" => $e->getMessage()
            ];
        }
        return $controller->sendResponse($response);
    }
    
    protected function sendOtpAgain(Request $request){
        try{
            $controller = new Controller();
            $checkEmail = Users::where(["email"=>$request->email])->first();
            if(!empty($checkEmail)){
                $otp = substr(str_shuffle("0123456789"), 0, 4);
                $db['otp'] = $otp;
                Users::where('email',$request->email)->update($db);
                $data['title'] = 'Hi';
                $data['regards'] = getenv('ADMIN_EMAIL');
                $data['subject'] = 'Forgot Password';
                $data['type'] = 1;
                $data['otp'] = $otp;
                $data['message'] = 'Please use the below otp to reset your account password.';
                $sendEmail = $this->sendEmail($request->email,$data);
                $response = [
                    "status" => parent::statusCode()['success'],
                    "message" => __('messages.otpresend'),
                ]; 
            }else{
                $response = [
                    "status" => $controller->statusCode()['error'],
                    "message" => __('messages.notAssociate')
                ];
            }
        }catch(\Exception $e){
            $response = [
                "status" => $controller::statusCode()['error'],
                "message" => $e->getMessage()
            ];
        }
        return $controller->sendResponse($response);
    }
    
    protected function otpVerification(Request $request){
        try{
            $controller = new Controller();
            $checkEmailOtp = Users::where(["otp" =>$request->otp,"email"=>$request->email])->first();
            if(!empty($checkEmailOtp)){
                $data = ['otp'=>''];
                Users::where('email',$request->email)->update($data);
                $response = [
                    "status" => parent::statusCode()['success'],
                    "message" => __('messages.otpVerified'),
                ]; 
            }else{
                $response = [
                    "status" => $controller->statusCode()['error'],
                    "message" => __('messages.incorrectOTP')
                ];
            }
        }catch(\Exception $e){
            $response = [
                "status" => $controller::statusCode()['error'],
                "message" => $e->getMessage()
            ];
        }
        return $controller->sendResponse($response);
    }
    
    protected function createNewPassword(Request $request){
        try{
            $controller = new Controller();
            $checkEmail = Users::where(["email"=>$request->email])->first();
            if(!empty($checkEmail)){
                $db['password'] = bcrypt($request->new_password);
                if($request->new_password == $request->confirm_password){ 
                    Users::where('email',$request->email)->update($db);
                    $response = [
                        "status" => parent::statusCode()['success'],
                        "message" => __('messages.passwordReset'),
                    ];
                }else{
                    $response = [
                        "status" => $controller->statusCode()['error'],
                        "message" => __('messages.newPassword')
                    ];
                } 
            }else{
                $response = [
                    "status" => $controller->statusCode()['error'],
                    "message" => __('messages.notAssociate')
                ];
            }
        }catch(\Exception $e){
            $response = [
                "status" => $controller::statusCode()['error'],
                "message" => $e->getMessage()
            ];
        }
        return $controller->sendResponse($response);
    }
    
}

?>