<?php 
namespace App\Http\Traits;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Validator;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Auth;

use App\Models\Users;
use App\Models\externalAccounts;

trait ExternalAccountTrait
{

    public function createExternalAccount(Request $request){
        try{
            $controller = new Controller();
            $user = $controller->decryptToken();
            $userID = $user->id;
            $payload = $request->all();
            $isCheck = externalAccounts::where('userID',$userID)->first();
            if($isCheck){
                $data = $controller->updateConnectedAccount($payload,$isCheck['accountID']);
                if($data['success'] == 1){
                    $payload['updated_at'] = date('Y-m-d H:i:s');
                    $updatedArr['email'] = $payload['email'];
                    $updatedArr['firstName'] = $payload['firstName'];
                    $updatedArr['lastName'] = $payload['lastName'];
                    $updatedArr['dob'] = $payload['dob'];
                    $updatedArr['phoneNumber'] = $payload['phoneNumber'];
                    $updatedArr['street'] = $payload['street'];
                    $updatedArr['city'] = $payload['city'];
                    $updatedArr['postalCode'] = $payload['postalCode'];
                    $updatedArr['updated_at'] = date('Y-m-d H:i:s');
                    $insert = externalAccounts::where('userID',$userID)->update($updatedArr);
                    if($insert){
                        $response = [
                            'data' => $data['accountID'],
                            "status" => $controller::statusCode()['success'],
                            "message" => __('messages.accountSuccess')
                        ];  
                    }else{
                        $response = [
                            "status" => $controller::statusCode()['error'],
                            "message" => __('messages.wrong')
                        ];   
                    } 
                }else{
                    $response = [
                        "status" => $controller::statusCode()['error'],
                        'message' => $data['message'],
                    ];
                }
            }else{
                $payload['userID'] = $userID;
                $payload['country'] = env('STRIPE_country');
                $payload['countryCode'] = "+44";
                $payload['status'] = 1;
                $payload['identityNumber'] = $payload['id_number'];
                $payload['created_at'] = date('Y-m-d H:i:s');
                $payload['updated_at'] = date('Y-m-d H:i:s');
                $data = $controller->createConnectedAccount($payload);
                if($data['success'] == 1){
                    $payload['accountID'] = $data['accountID'];
                    $insert = externalAccounts::create($payload);
                    if($insert){
                        $userData['isTrack'] = 6;
                        Users::where('id',$userID)->update($userData);
                        $response = [
                            'data' => $data['accountID'],
                            "status" => $controller::statusCode()['success'],
                            "message" => __('messages.accountSuccess')
                        ]; 
                    }else{
                        $response = [
                            "status" => $controller::statusCode()['error'],
                            "message" => __('messages.wrong')
                        ];   
                    } 
                }else{
                    $response = [
                        "status" => $controller::statusCode()['error'],
                        'message' => $data['message'],
                    ];
                } 
            }
        }catch(\Exception $e){
            $response = [
                'status' => 400,
                'message' => $e->getMessage(),
            ];
        }
        return $controller->sendResponse($response);
    }
       
    public function uploadDocumentOfExternalAccount(Request $request){
        try{
            $controller = new Controller();
            $user = $controller->decryptToken();
            $userID = $user->id;
            $payload = $request->all();
            $accID  = externalAccounts::where('userID',$userID)->first();
            $data = $controller->userIdentityCheck($accID->accountID,$request);
            if($data['success'] == 1){
                $payload['updated_at'] = date('Y-m-d H:i:s');
                $payload['frontIdentity'] = $data['data']['frontIdentity'];
                $payload['backIdentity'] = $data['data']['backIdentity'];
                $insert = externalAccounts::where('userID',$userID)->update($payload);
                if($insert){
                    $userData['isTrack'] = 7;
                    Users::where('id',$userID)->update($userData);
                    $response = [
                        'data' => $request->accountID,
                        "status" => $controller::statusCode()['success'],
                        'message' => $data['message'],
                    ];
                }else{
                    $response = [
                        "status" => $controller::statusCode()['error'],
                        "message" => __('messages.wrong')
                    ];    
                } 
            }else{
                $response = [
                    "status" => $controller::statusCode()['error'],
                    'message' => $data['message'],
                ];
            }
        }catch(\Exception $e){
            $response = [
                "status" => $controller::statusCode()['error'],
                'message' => $e->getMessage(),
            ];
        }
        return $controller->sendResponse($response);
    }
    
    public function addBankOfExternalAccount(Request $request){
        try{
            $user = $this->decryptToken();
            $userID = $user->id;
            $payload = $request->all();
            $accID  = externalAccounts::where('userID',$userID)->first();
            $data = parent:: createBankOfConnectedAccount($payload,$accID->accountID);
            if($data['success'] == 1){
                $payload['updated_at'] = date('Y-m-d H:i:s');
                $payload['routingNumber'] = parent::encryptDataInSecureForm($userID,$request->routingNumber);
                $payload['accountNumber'] = parent::encryptDataInSecureForm($userID,$request->accountNumber);
                $insert = externalAccounts::where('userID',$userID)->update($payload);
                if($insert){
                    $userData['isTrack'] = 8;
                    Users::where('id',$userID)->update($userData);
                    $response = [
                        'status' => 200,
                        'message' => $data['message'],
                    ];
                }else{
                    $response = [
                        'status' => 400,
                        'message' => "Something went wrong",
                    ];   
                } 
            }else{
                $response = [
                    'status' => 400,
                    'message' => $data['message'],
                ];
            }
        }catch(\Exception $e){
            $response = [
                'status' => 400,
                'message' => $e->getMessage(),
            ];
        }
        return $this->sendResponse($response);
    }
    
    public function deleteBank(Request $request){
        try{
            $controller = new Controller();
            $user = $this->decryptToken();
            $getAccountData = externalAccounts::where(['id'=>$request->id,'userID'=>$user->id])->first();
            $data = parent::deleteBankOfConnectedAccount($getAccountData->accountID);
            if($data['success'] == 1){
                $arr = ['isDelete'=>'1'];
                externalAccounts::where('id',$request->id)->update($arr);
                $response = [
                    "status" => $controller::statusCode()['success'],
                    'message' => $data['message'],
                ];
            }else{
                $response = [
                    "status" => $controller::statusCode()['error'],
                    'message' => $data['message'],
                ];
            }
        }catch(\Exception $e){
            $response = [
                "status" => parent::statusCode()['error'],
                "message" => $e->getMessage(),
            ];
        }
        return parent::sendResponse($response);
    }
    
    // Add new bank flow start
    public function addNewBank(Request $request){
        try{
            $controller = new Controller();
            $user = $this->decryptToken();
            $userID = $user->id;
            $payload = $request->all();
            $payload['routingNumber'] = parent::encryptDataInSecureForm($userID,$request->routingNumber);
            $payload['accountNumber'] = parent::encryptDataInSecureForm($userID,$request->accountNumber);
            $getBanks = externalAccounts::where(['userID'=>$userID,'routingNumber'=>$payload['routingNumber'],'accountNumber'=>$payload['accountNumber'],'isDelete'=>'0'])->first();
            if( !empty($getBanks) && $getBanks->routingNumber == $payload['routingNumber'] && $getBanks->accountNumber == $payload['accountNumber'] ){
                $response = [
                    "status" => parent::statusCode()['error'],
                    "message" => __('messages.bankError')
                ]; 
            }else{
                $getAccountData = externalAccounts::where('userID',$userID)->first();
                if(!empty($getAccountData)){
                    $payload['userID'] = $getAccountData->userID ;
                    $payload['country'] = env('STRIPE_country');
                    $payload['countryCode'] = "+44";
                    $payload['status'] = 1;
                    $payload['id_number'] = $getAccountData->identityNumber;
                    $payload['identityNumber'] = $getAccountData->identityNumber;
                    $payload['dob'] = $getAccountData->dob;
                    $payload['email'] = $getAccountData->email;
                    $payload['businessURL'] = $getAccountData->businessURL;
                    $payload['firstName'] = $getAccountData->firstName;
                    $payload['lastName'] = $getAccountData->lastName;
                    $payload['phoneNumber'] = $getAccountData->phoneNumber;
                    $payload['city'] = $getAccountData->city;
                    $payload['street'] = $getAccountData->street;
                    $payload['postalCode'] = $getAccountData->postalCode;
                    $createConnectedAccount = $controller->createConnectedAccount($payload); //Step 1
                    if($createConnectedAccount['success'] == 1){
                        $payload['accountID'] = $createConnectedAccount['accountID'];
                            //Step 2
                            $docs['frontIdentity'] = $getAccountData->frontIdentity;
                            $docs['backIdentity'] = $getAccountData->backIdentity;
                            $userDocsCheck = $controller->userDocsCheck($createConnectedAccount['accountID'],$docs);
                            if($userDocsCheck['success'] == 1){
                                $payload['frontIdentity'] = $userDocsCheck['data']['frontIdentity'];
                                $payload['backIdentity'] = $userDocsCheck['data']['backIdentity'];
                                    //Step 3
                                    $createBankOfConnectedAccount = parent:: createBankOfConnectedAccount($request,$payload['accountID']);
                                    if($createBankOfConnectedAccount['success'] == 1){
                                        $payload['routingNumber'] = parent::encryptDataInSecureForm($userID,$request->routingNumber);
                                        $payload['accountNumber'] = parent::encryptDataInSecureForm($userID,$request->accountNumber);
                                        $bankData = array(
                                            'accountHolderName' => $request->accountHolderName,    
                                            'routingNumber'     => $payload['routingNumber'],    
                                            'accountNumber'     => $payload['accountNumber']  
                                        );
                                        
                                        $addNewBank = externalAccounts::create($payload);
                                        if($addNewBank){
                                            $response = [
                                                'status' => 200,
                                                'message' => $createBankOfConnectedAccount['message'],
                                            ];
                                        }else{
                                            $response = [
                                                'status' => 400,
                                                'message' => "Something went wrong",
                                            ];   
                                        } 
                                    }else{
                                        $response = [
                                            'status' => 400,
                                            'message' => $createBankOfConnectedAccount['message'],
                                        ];
                                    }
                            }else{
                                $response = [
                                    "status" => $controller::statusCode()['error'],
                                    'message' => $userDocsCheck['message'],
                                ];
                            }
                    }else{
                        $response = [
                            "status" => $controller::statusCode()['error'],
                            "message" => __('messages.wrong')
                        ];   
                    } 
                }else{
                    $response = [
                        "status" => parent::statusCode()['success'],
                        "message" => __('messages.dataNotFound'),
                    ];
                }
            }
        }catch(\Exception $e){
            $response = [
                'status' => 400,
                'message' => $e->getMessage(),
            ];
        }
        return $this->sendResponse($response);
    }
    //Add new bank flow end
    
}
    

?>
