<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use DB;

class Transactions extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $table = 'tbl_transactions';

    protected $fillable = ['senderID','receiverID','requestID','walletID','transactionID','cardID','amount','paymentStatus','type','paymentType','isRequest'];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];
    
    public static function getTransactionHistory($userID,$type,$limit_per_page,$offset){
        $columns = ['id','requestID','senderID','receiverID','cardID','amount','type','created_at'];
        if($type == "0"){
		    return Transactions::select($columns)->where(['senderID'=>$userID])->orWhere(['receiverID'=>$userID])->limit($limit_per_page)->offset($offset)->get();
		}elseif($type == "1"){
		    return Transactions::select($columns)->where(['senderID'=>$userID,'type'=>'2'])->limit($limit_per_page)->offset($offset)->get();
		}elseif($type == "2"){
		    return Transactions::select($columns)->where(['receiverID'=>$userID,'type'=>'2'])->limit($limit_per_page)->offset($offset)->get();
		}elseif($type == "3"){
		    return Transactions::select($columns)->where(['receiverID'=>$userID,'type'=>'1'])->limit($limit_per_page)->offset($offset)->get();
		}elseif($type == "4"){
		    return Transactions::select($columns)->where(['receiverID'=>$userID,'type'=>'4'])->limit($limit_per_page)->offset($offset)->get();
		}elseif($type == "5"){
		    return Transactions::select($columns)->where(['receiverID'=>$userID,'type'=>'2'])->where('requestID', '!=',  "")->limit($limit_per_page)->offset($offset)->get();
		}elseif($type == "6"){
		    return Transactions::select($columns)->where(['senderID'=>$userID,'type'=>'2'])->where('requestID', '!=',  "")->limit($limit_per_page)->offset($offset)->get();
		}
    }
    
    public static function transactionDetails($otherUserID,$loginUserID,$type){
        if($type == "2"){
            $sql = "SELECT * FROM tbl_transactions WHERE type='2' and (senderID=$loginUserID or receiverID=$otherUserID and senderID=$otherUserID or receiverID=$loginUserID) and type='2' ORDER BY id DESC";
        }elseif($type == "1"){
            $sql = "SELECT * FROM tbl_transactions WHERE receiverID=$loginUserID and type='1' ORDER BY id DESC";
        }elseif($type == "4"){
            $sql = "SELECT * FROM tbl_transactions WHERE receiverID=$loginUserID and type='4' ORDER BY id DESC";
        }
        return DB::select( $sql );
    }
    
    public static function userContacts($loginUserID,$limit_per_page,$offset){
        $sql = "select (CASE tbl_transactions.senderID = {$loginUserID} WHEN true THEN tbl_transactions.receiverID WHEN false THEN tbl_transactions.senderID END) as userID from tbl_transactions where (tbl_transactions.senderID={$loginUserID} OR tbl_transactions.receiverID={$loginUserID}) GROUP BY userID limit $limit_per_page offset $offset";
        return DB::select( $sql );
    }
    
    //Admin panel
    public static function newTransactionsAdmin(){
        $sql = "select count(*) as count_today from tbl_transactions where yearweek(created_at) = yearweek(curdate())";
        return DB::select( $sql );
    }
    
}