<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Support\Facades\DB;

class Users extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $table = 'tbl_users';

    protected $fillable = ['firstName','lastName','email','password','otp','isOtpSent','otpSendDate','otpSendCountInDay','phoneNumber','country','countryCode',
                            'ssn','identityFront','identityBack','deviceID','deviceToken','deviceType',
                            'isVerify','isSuspend','isTrack','status','qrCode','referralCode','chat_token'];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];
    
    public static function homeSearchUser($search){
        return Users::select('id',DB::raw("CONCAT(firstName, ' ', lastName) as name"),'phoneNumber','userProfile')->
                    where('phoneNumber','like', '%' . $search . '%')
                    ->orWhere(DB::raw("concat(firstName, ' ', lastName)"), 'LIKE', "%".$search."%")->get();
    }
    
    //Admin
    public static function newUsersAdmin(){
        $sql = "select count(*) as count_today from tbl_users where yearweek(created_at) = yearweek(curdate())";
        return $result = DB::select( $sql );
    }
    
}