const express = require('express');
const fs = require('fs');
const https = require('https');
const socketIo = require('socket.io');
const mysql = require('mysql');
const app = express();
const multer = require('multer');
const path = require('path');

// Read SSL certificate files
const privateKey = fs.readFileSync('/home/phpparastechnolo/ssl/keys/a31fd_4ad29_73af81ec207d49b1ffb3a88577640297.key');
const certificate = fs.readFileSync('/home/phpparastechnolo/ssl/certs/php_parastechnologies_in_a31fd_4ad29_1730247451_84b920c5df7ebb51d9cfc8ac630819a0.crt');
const ca = fs.readFileSync('/home/phpparastechnolo/ssl/certs/php_parastechnologies_in_a31fd_4ad29_1730247451_84b920c5df7ebb51d9cfc8ac630819a0.crt');

const credentials = { key: privateKey, cert: certificate, ca: ca };

// Create an HTTPS server
const httpsServer = https.createServer(credentials);

// Initialize Socket.IO with the HTTPS server
const io = socketIo(httpsServer);

/*const io = socketIo(server, {
  cors: {
    origin: "*",  // Adjust this as needed for your security requirements
    methods: ["GET", "POST"]
  }
});*/

//Server running port
const PORT = process.env.PORT || 3000;
httpsServer.listen(PORT, () => {
    console.log('Server is running on port: ' + PORT);
});

// MySQL connection setup
const db = mysql.createConnection({
  host: 'localhost',        
  user: 'phpparastechnolo_encroUser',        
  password: 'R5tRFMxmg-Y0',
  database: 'phpparastechnolo_encroDatabase'
});

db.connect((err) => {
  if (err) {
    console.error('Database connection failed: ' + err.stack);
    return;
  }
  console.log('Connected to database.');
});

// Configure multer for file uploads
const upload = multer({
  dest: 'uploads/', // Directory for storing uploaded files
  limits: { fileSize: 5 * 1024 * 1024 } // Limit file size to 5MB
});

// Serve static files (e.g., HTML, CSS, JS)
app.use(express.static('public'));

// Handle image upload
app.post('/upload', upload.single('image'), (req, res) => {
  if (!req.file) {
    return res.status(400).send('No file uploaded.');
  }
  res.send({ filePath: `/uploads/${req.file.filename}` });
});

// Handle socket connection events
io.on('connection', (socket) => {
    console.log('Socket connected');
    
    // Join a room for a chat session
    /*socket.on('joinRoom', (roomId) => {
        socket.join(roomId);
        console.log('User joined room: ${roomId}');
    });*/
    
    //Connect user
    socket.on('ConnectUser', (data) => { 
		try {
		    console.log("User id: " + data.userID + " connected.");
		    socket.emit("ConnectUserListner", data);
		} catch (err) {
		  console.error('Something went wrong:', err);
		}
    });
    
  //Send Message
  socket.on('SendMessage', (data) => {
    try {
        const senderId = data.senderId;
        const receiverID = data.receiverID;
        const message = data.message;
        const type = data.type;
        const datetime = data.datetime;
	    const query = 'INSERT INTO tbl_chatMessages (senderId,receiverID,message,type,created_at,updated_at) VALUES (?,?,?,?,?,?)';
        db.query(query, [senderId, receiverID, message, type, datetime, datetime], (err, results) => {
            if (err) {
                console.error('Something went wrong:', err);
                return;
            }
            io.emit('SendMessageListener', data);
            /*Emit message to specific room
            io.to(data.roomId).emit('SendMessageListener', data);*/
            console.log('Message sent successfully');
        });
	} catch (err) {
	   console.error('Something went wrong:', err);
	}
  });
  
    // Handle receiving images from clients
    socket.on('sendImage', (data) => {
        try {
            const senderId = data.senderId;
            const receiverID = data.receiverID;
            const image = data.image;
            const type = data.type;
            const datetime = data.datetime;
            const query = 'INSERT INTO tbl_chatMessages (senderId,receiverID,message,type,created_at,updated_at) VALUES (?,?,?,?,?,?)';
            db.query(query, [senderId, receiverID, image, type, datetime, datetime], (err, results) => {
                if (err) {
                    console.error('Something went wrong:', err);
                    return;
                }
                io.emit('sendImageListener', data);
                console.log('Image sent successfully');
            });
        } catch (err) {
           console.error('Something went wrong:', err);
        }
    });
  
  //Disconnect socket
  socket.on('disconnect', () => {
    console.log('User disconnected');
  });
  
});
