<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_users', function (Blueprint $table) {
            $table->id();
            $table->string('firstName')->nullable();
            $table->string('lastName')->nullable();
            $table->string('email')->unique();
            $table->string('password');
            $table->string('userProfile')->nullable();
            $table->string('qrCode')->nullable();
            $table->string('referralCode')->nullable();
            $table->string('otp')->nullable();
            $table->string('otpSendDate')->nullable();
            $table->string('otpSendCountInDay')->nullable();
            $table->string('phoneNumber')->nullable()->unique();
            $table->string('country')->nullable();
            $table->string('countryCode')->nullable();
            $table->string('ssn')->nullable();
            $table->string('identityFront')->nullable();
            $table->string('identityBack')->nullable();
            $table->string('deviceID')->nullable();
            $table->string('deviceToken')->nullable();
            $table->string('deviceType')->nullable();
            $table->string('chat_token')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->boolean('isVerify')->default(0);
            $table->boolean('isOtpSent')->default(0)->comment('1 = yes,0=no');
            $table->boolean('isSuspend')->default(0)->comment('1 = suspend,0=active');
            $table->boolean('isTrack')->default(0)->comment('1 = register,2 = create profile,3 = upload document,4 = otp verify,5 = payment,6= personal info,7=upload,8=bank');
            $table->boolean('status')->default(0)->comment('1 = approve,2=reject');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_users');
    }
}
