<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UserCards extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_userCards', function (Blueprint $table) {
            $table->id();
            $table->foreignId('userID')->nullable()->constrained('tbl_users')->onUpdate('cascade')->onDelete('cascade');
            $table->string('cardHolderName')->nullable();
            $table->string('cardNumber')->nullable();
            $table->string('expiryDate')->nullable();
            $table->boolean('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_userCards');
    }
}
