<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ExternalAccounts extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {
        Schema::create('tbl_externalAccounts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('userID')->nullable()->constrained('tbl_users')->onUpdate('cascade')->onDelete('cascade');
            $table->string('accountID')->nullable();
            $table->string('firstName')->nullable();
            $table->string('lastName')->nullable();
            $table->string('email')->nullable();
            $table->date('dob')->nullable();
            $table->string('phoneNumber')->nullable();
            $table->string('country')->nullable();
            $table->string('businessURL')->nullable();
            $table->string('street')->nullable();
            $table->string('secondAddress')->nullable();
            $table->string('city')->nullable();
            $table->string('postalCode')->nullable();
            $table->string('state')->nullable();
            $table->string('identityNumber')->nullable();
            $table->string('frontIdentity')->nullable();
            $table->string('backIdentity')->nullable();
            $table->string('accountHolderName')->nullable();
            $table->string('routingNumber')->nullable();
            $table->string('accountNumber')->nullable();
            $table->boolean('status')->default(0);
            $table->enum('isDelete',[0,1])->default(0)->comment('0->no, 1->yes');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_userAccounts');
    }
}
