<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class Requests extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_requests', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('senderID')->nullable()->constrained('tbl_users')->onUpdate('cascade')->onDelete('cascade');
            $table->bigInteger('receiverID')->nullable()->constrained('tbl_users')->onUpdate('cascade')->onDelete('cascade');
            $table->bigInteger('requestID')->nullable();
            $table->double('amount',[10,2])->nullable();
            $table->text('description')->nullable();
            $table->date('requestDate')->nullable();
            $table->boolean('type')->default(0)->comment('1 = Request, 2 = Amount send, 3= Decline request');
            $table->boolean('status')->default(0)->comment('0 = pending, 1 = accept, 2 = reject');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_userRequests');
    }
}
