<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class Transactions extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
     
    public function up()
    {
        Schema::create('tbl_transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('senderID')->nullable()->constrained('tbl_users')->onUpdate('cascade')->onDelete('cascade');
            $table->foreignId('receiverID')->nullable()->constrained('tbl_users')->onUpdate('cascade')->onDelete('cascade');
            $table->foreignId('requestID')->nullable()->comment('request ID/payment ID')->constrained('tbl_requests')->onUpdate('cascade')->onDelete('cascade');
            $table->foreignId('walletID')->nullable()->constrained('tbl_wallet')->onUpdate('cascade')->onDelete('cascade');
            $table->string('transactionID')->comment('transaction id of the payment')->nullable();
            $table->bigInteger('cardID')->nullable();
            $table->string('amount',[10,2])->nullable()->comment('amount pay by user');
            $table->string('paymentStatus')->nullable();
            $table->integer('type')->comment("0 = no activity,1 = add amount in wallet(added) ,2 = pay to other user(paid/received),4 = withdraw (received)");
            $table->enum('paymentType',[0,1,2])->default(0)->comment('1=Scanner, 2=Phone Number');
            $table->boolean('isRequest')->default(0)->comment('0=No,1=Yes');
            $table->boolean('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
         Schema::dropIfExists('tbl_transactions');
    }
}
