<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class Notifications extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_notifications', function (Blueprint $table) {
            $table->id();
            $table->foreignId('senderID')->nullable()->constrained('tbl_users')->onUpdate('cascade')->onDelete('cascade');
            $table->foreignId('receiverID')->nullable()->constrained('tbl_users')->onUpdate('cascade')->onDelete('cascade');
            $table->foreignId('requestID')->nullable()->comment('request ID/payment ID')->constrained('tbl_requests')->onUpdate('cascade')->onDelete('cascade');
            $table->foreignId('walletID')->nullable()->constrained('tbl_wallet')->onUpdate('cascade')->onDelete('cascade');
            $table->string('title')->nullable();
            $table->text('message')->nullable();
            $table->double('amount',[10,2])->nullable()->comment('amount pay by user');
            $table->integer('type')->comment("0=Payment request sent,1=Payment request decline,2=Successful payment,3=Automatic request decline on no action, 4=Amount added to wallet, 5=Trnasfer To Bank");
            $table->boolean('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
         Schema::dropIfExists('tbl_notifications');
    }
}
