<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblChatMesagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_chatMessages', function (Blueprint $table) {
            $table->id();
            $table->string('senderId')->nullable();
            $table->string('receiverID')->nullable();
            $table->string('message')->nullable();
            $table->string('type')->nullable();
            $table->boolean('isRead')->default(0)->comment('1=read,0=unread');
            $table->boolean('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_chatMessages');
    }
}
