<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
        <meta name="description" content="" />
        <meta name="author" content="" />
        <title>Encro Login</title>
        <!-- Favicon-->
		<link rel="icon" type="image/x-icon" href="{{ asset('public/admin/assets/images/Encro_logo.svg') }}" />
        <!-- Core theme CSS (includes Bootstrap)-->
        <link href="{{ asset('public/admin/assets/css/bootstrap.min.css') }}" rel="stylesheet">
        <link rel="stylesheet" href="{{ asset('public/admin/assets/css/style.css') }}">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" integrity="sha512-5A8nwdMOWrSz20fDsjczgUidUBR8liPYU+WymTZP1lmY9G6Oc7HlZv156XqnsgNUzTyMefFTcsFH/tnJE/+xBg=="
      crossorigin="anonymous" />
      <style>
          label.error{
              color:red;
          }
      </style>
    </head>
    <body>
        @yield('content')
        <!-- Bootstrap core JS-->
        <script src="{{ asset('public/admin/assets/js/bootstrap.bundle.min.js') }}"></script>
        <!-- Core theme JS-->
        <script src="{{ asset('public/admin/assets/js/main.js') }}"></script>
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.1/jquery.validate.min.js"></script>
        <script src="https://www.gstatic.com/firebasejs/8.3.2/firebase.js"></script>
        <script>
            jQuery(".toggle-hide-show").click(function() {
                jQuery(this).toggleClass("fa-eye fa-eye-slash");
                input = jQuery(this).parent().find("input");
                if (input.attr("type") == "password") {
                    input.attr("type", "text");
                } else {
                    input.attr("type", "password");
                }
            });
        </script>
        
        <script>
          $(document).ready(function () {
            $('#loginform').validate({
              rules: {
                email: {
                  required: true,
                  email: true
                },
                password: {
                  required: true,
                }
              },
              messages: {
                email: {
                  required: 'The email field is reqiuired',
                  email: 'Please enter a valid Email Address',
                },
                password: {
                  required: 'The password field is reqiuired',
                },
              },
              submitHandler: function (form) {
                form.submit();
              }
            });
          });
        </script>
		
		<script>
             var firebaseConfig = {
                apiKey: '{{ getenv("API_KEY") }}',
                authDomain: '{{ getenv("AUTH_DOMAIN") }}',
                databaseURL: '{{ getenv("DB_URL") }}',
                projectId: '{{ getenv("PROJECT_ID") }}',
                storageBucket: '{{ getenv("STORAGE_BUCKET") }}',
                messagingSenderId: '{{ getenv("SENDER_ID") }}',
                appId: '{{ getenv("APP_ID") }}',
                measurementId: '{{ getenv("MEASUREMENT_ID") }}',
            };
            firebase.initializeApp(firebaseConfig);
            const messaging = firebase.messaging();
            messaging.requestPermission()
            .then(function() {
                console.log('Notification permission granted.');
                return messaging.getToken();
            })
            .then(function(token) {
                console.log('FCM Token:', token);
                $('.deviceToken').val(token);  // Assuming you're using jQuery to set a value
            })
            .catch(function(error) {
                console.error('Error obtaining FCM token:', error);
                alert('Unable to get permission to notify.');
            });
            
            // Handle incoming messages
            messaging.onMessage(function(payload) {
                console.log('Message received:', payload);
            
                const notificationTitle = payload.notification.title;
                const notificationOptions = {
                    body: payload.notification.body,
                    icon: payload.notification.icon
                };
            
                // Show the notification
                self.registration.showNotification(notificationTitle, notificationOptions);
            });
        </script>
    </body>
</html>