<!DOCTYPE html>
<html lang="en">
	<head>
		<meta charset="utf-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
		<meta name="description" content="" />
		<meta name="author" content="" />
		<title>Encro</title>
		<!-- Favicon-->
		<link rel="icon" type="image/x-icon" href="{{ asset('public/admin/assets/images/Encro_logo.svg') }}" />
		<!-- Core theme CSS (includes Bootstrap)-->
		<link href="{{ asset('public/admin/assets/css/bootstrap.min.css') }}" rel="stylesheet" />
		<!-- custom css-->
		<link rel="stylesheet" href="{{ asset('public/admin/assets/css/style.css') }}" />
		<!-- datatable css-->
		<link rel="stylesheet" href="{{ asset('public/admin/assets/css/jquery.dataTables.min.css') }}" />
		<link rel="stylesheet" href="{{ asset('public/admin/assets/css/dataTables.responsive.css') }}">
		<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" integrity="sha512-5A8nwdMOWrSz20fDsjczgUidUBR8liPYU+WymTZP1lmY9G6Oc7HlZv156XqnsgNUzTyMefFTcsFH/tnJE/+xBg=="
                crossorigin="anonymous" />
		<style>
		    .error{
		        color:red;
		    }
		</style>
	</head>
	<body>
	    <div class="d-flex" id="wrapper">
	         <div class="overlay"></div>
	         <!-- Sidebar-->
                @include('admin/layout.sidebar')
            <!-- Page content wrapper-->
                <div id="page-content-wrapper">
                    <!-- Top navigation-->
                        @include('admin/layout.header')
                    <!-- Page content-->
                        <div class="container-fluid">
                            <div class="content-wrapper" id="dashboard">
                                @yield('content')
                            </div>
                        </div>
                </div>
	    <!-- Bootstrap core JS-->
	    <script src="https://cdn.ckeditor.com/ckeditor5/17.0.0/classic/ckeditor.js"></script>
        <script src="{{ asset('public/admin/assets/js/bootstrap.bundle.min.js') }}"></script>
        <script src="{{ asset('public/admin/assets/js/jquery-3.6.1.min.js') }}"></script>
        <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.1/jquery.validate.min.js"></script>
        <script src="{{ asset('public/admin/assets/js/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('public/admin/assets/js/dataTables.responsive.js') }}"></script>
        <!-- Core theme JS-->
        <script src="{{ asset('public/admin/assets/js/main.js') }}"></script>
        <script src="https://stackpath.bootstrapcdn.com/bootstrap/5.0.0-alpha1/js/bootstrap.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.0/dist/umd/popper.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.3/Chart.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
        <script src="{{ asset('public/admin/assets/js/texteditor.js') }}"></script>
        <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
        
        <script>
            jQuery(".toggle-hide-show").click(function() {
                jQuery(this).toggleClass("fa-eye fa-eye-slash");
                input = jQuery(this).parent().find("input");
                if (input.attr("type") == "password") {
                    input.attr("type", "text");
                } else {
                    input.attr("type", "password");
                }
            });
        </script>
        
        <script>
        	$(document).ready(function () {
        	  $('#upcomingReservation').dataTable({
        	    Response: true,
        	    language: {
        	      paginate: {
        	        /*next: '<img src="{{ asset("public/admin/assets/images/next.svg") }}">',
        	        previous: '<img src="{{ asset("public/admin/assets/images/prev.svg") }}">'*/
        	        next: 'Next',
                    previous: 'Previous'
        	      }
        	    },
        	    "ordering": false
        	  });
        	});
        </script>
        
        <script>
        	function toggleButton(clickedButton) {
        	  // Disable all buttons
        	  var buttons = document.querySelectorAll('.button-group button');
        	  buttons.forEach(function (button) {
        	    button.disabled = false;
        	    button.classList.remove('active');
        	  });
        	  // Enable the clicked button
        	  clickedButton.disabled = true;
        	  clickedButton.classList.add('active');
        	}
        </script>
        
        <script>
            $('.approveRejectProfile').click(function() {
                var user_id = $(this).attr("user-id"); 
                var type = $(this).attr("type"); 
                $.ajax({  
                    url : "approve_reject_profile", 
                    type:"GET",  
                    data:{user_id:user_id,type:type},
                    success:function(response){
                        if(true){ 
                            if(type == 0){
                                swal("Success!", "User rejected.", "success");
                            }if(type == 1){
                                swal("Success!", "User approved.", "success");
                            }
                            setTimeout(function(){
                               window.location.reload();
                            }, 2000);
                        }else{
                            swal("Oops!", "Something went wrong, please try again!", "danger");
                        } 
                    }
                }); 
            });
        </script>
        
        <script>
            $('.suspendActivateUser').click(function() {
                var user_id = $(this).attr("user-id"); 
                var type = $(this).attr("type"); 
                $.ajax({  
                    url : "suspend_activate_user", 
                    type:"GET",  
                    data:{user_id:user_id,type:type},
                    success:function(response){
                        if(true){ 
                            if(type == 0){
                                swal("Success!", "User activated.", "success");
                            }if(type == 1){
                                swal("Success!", "User suspended.", "success");
                            }
                            setTimeout(function(){
                               window.location.reload();
                            }, 2000);
                        }else{
                            swal("Oops!", "Something went wrong, please try again!", "danger");
                        } 
                    }
                }); 
            });
        </script>
        
        <script>
            $(function() {
                $('.replyToUser').click(function(){
                  var report_id = $(this).attr('report_id');
                  var user_email = $(this).attr('user_email');
                  $('#report_id').val(report_id);
                  $('#user_email').val(user_email);
              });
            });
            
            $('#reportForm').on('submit', function(e) {
               e.preventDefault(); 
               var report_id = $('#report_id').val();
               var user_email = $('#user_email').val();
               $.ajax({
                    url:"{{ url('/admin/reply-to-user') }}",
                    method:"post",
                    contentType: false,
                    cache: false,
                    processData:false,
                    data:new FormData(this),
                    success:function(data){
                        if(true){
                            swal("Success!", "Message posted.", "success");
                        }else{
                            swal("Oops!", "Something went wrong, please try again!", "danger");
                        }
                        setTimeout(function(){
                           window.location.reload();
                        }, 2000);
                    }
                });
            });
            
            $('#aboutUsForm').on('submit', function(e) {
                e.preventDefault(); 
                var editor = $('#editor').val();
                $.ajax({
                    url:"{{ url('/admin/upload-content') }}",
                    method:"post",
                    contentType: false,
                    cache: false,
                    processData:false,
                    data:new FormData(this),
                    success:function(data){
                        if(true){
                            swal("Success!", "Content uploaded.", "success");
                        }else{
                            swal("Oops!", "Something went wrong, please try again!", "danger");
                        }
                        setTimeout(function(){
                           window.location.reload();
                        }, 2000);
                    }
                });
            });

            $(document).ready(function () {
                $('#changePassword').validate({
                    rules: {
                        password: {
                            minlength: 8,
                        },
                        confirm_password: {
                            minlength: 8,
                            equalTo: "#password"
                        }
                    },
                    messages:{
                        password:{
                            minlength : "Password must be of at least 8 characters"
                        },
                        confirm_password:{
                            minlength : "Password must be of at least 8 characters",
                            equalTo : "Confirm password must match with new password"
                        }
                    },
                    submitHandler: function(form) {
                        $.ajax({
                            url: form.action,
                            type: form.method,
                            data: $(form).serialize(),
                            success: function(response) {
                                if(response.success == true){
                                    $("#successPass").text(response.message);
                                    setTimeout(function(){
                                       window.location.reload();
                                    }, 2000);
                                }else{
                                    $("#errorPass").text(response.message);
                                }
                            }            
                        });
                    }
                });
            });
            
            $('#uploadImg').on('submit', function(e) {
                e.preventDefault(); 
                $.ajax({
                    url:"{{ url('/admin/upload-img') }}",
                    method:"post",
                    contentType: false,
                    cache: false,
                    processData:false,
                    data:new FormData(this),
                    success:function(data){
                        if(data.success == true){
                            $("#success").text(data.message);
                            setTimeout(function(){
                               window.location.reload();
                            }, 2000);
                        }else{
                            $("#error").text(data.message);
                        }
                    }
                });
            });
        </script>
        
        <script>
            const inputFile = document.querySelector("#picture__input");
            const pictureImage = document.querySelector(".picture__image");
            const pictureImageTxt = "Choose an image";
            pictureImage.innerHTML = pictureImageTxt;
            inputFile.addEventListener("change", function (e) {
                const inputTarget = e.target;
                const file = inputTarget.files[0];
                if (file) {
                    $("#error").text("");
                    const reader = new FileReader();
                    reader.addEventListener("load", function (e) {
                      const readerTarget = e.target;
                      const img = document.createElement("img");
                      img.src = readerTarget.result;
                      img.classList.add("picture__img");
                      pictureImage.innerHTML = "";
                      pictureImage.appendChild(img);
                    });
                    reader.readAsDataURL(file);
                }else{
                    pictureImage.innerHTML = pictureImageTxt;
                }
            });
        </script>
	</body>
</html>