@extends('admin/layout.main') 
@section('content')
<div class="row">
	<div class="col-12">
		<div class="header">
			<div class="d-block d-sm-flex align-items-center justify-content-between">
				<p class="fs-18 mb-0 d-flex align-items-center bg-transparent titlebrown">
					<span>
						<span>
							<a href="{{  url('/admin/payment-management') }}">
								<svg xmlns="http://www.w3.org/2000/svg" width="17" height="15" viewBox="0 0 17 15" fill="none">
									<path d="M0.999998 7.0246L16 7.0246" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
									<path d="M7.04993 13.049L0.999927 7.025L7.04993 1" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
								</svg>
							</a>
						</span>
					</span>
					<span class="mt-1 ms-2">Payment details</span>
				</p>
			</div>
		</div>
	</div>
</div>
<div class="row pt-4 justify-content-left my-3">
	<div class="col-xxl-7 col-md-8 col-12 pro_dta pmt_crd">
		<div class="row justify-content-center align-items-center">
			<div class="row border py-2 rounded-3">
				<div class="col-md-12">
					<ul class="list-group my-1 fw-600">
						<li class="list-group-item d-flex justify-content-between align-items-center py-3 border-0 border-bottom fs-14 px-2 flex-lg-row flex-column">
						    Transaction ID<span class="fw-normal text-capitalize">{{ $transaction_details->transactionID }}</span>
						</li>
						<li class="list-group-item d-flex justify-content-between align-items-center py-3 border-0 border-bottom fs-14 px-2 flex-lg-row flex-column">
						    Date<span class="fw-normal text-capitalize">
						        <?php
                        	        echo date('d F Y',strtotime($transaction_details->created_at));
                        	    ?>
						    </span>
						</li>
						<li class="list-group-item d-flex justify-content-between align-items-center py-3 border-0 border-bottom fs-14 px-2 flex-lg-row flex-column">
						    Time<span class="fw-normal text-capitalize">
						        <?php
                        	        //echo date('h:i A',strtotime($transaction_details->created_at));
                        	        $ip = $_SERVER['REMOTE_ADDR'];
                                    $ipdat = @json_decode(file_get_contents("http://www.geoplugin.net/json.gp?ip=" . $ip));
                                    date_default_timezone_set($ipdat->geoplugin_timezone);
                                    echo date( 'H:i A',strtotime($transaction_details->created_at .' UTC') );
                        	    ?>
						    </span>
						</li>
						<li class="list-group-item d-flex justify-content-between align-items-center py-3 border-0 border-bottom fs-14 px-2 flex-lg-row flex-column">
						    Sender<span class="fw-normal text-capitalize">
						        <?php
                    	            if($transaction_details->type == "2"){
                        	            $userData = App\Models\Users::where('id',$transaction_details->senderID)->first();
                        	            if(!empty($userData->firstName) && !empty($userData->lastName)){
                        	                echo $userData->firstName." ".$userData->lastName;
                        	            }
                    	            }else{
                    	                echo "Self";
                    	            }
                    	       ?>
						    </span>
						</li>
						<li class="list-group-item d-flex justify-content-between align-items-center py-3 border-0 border-bottom fs-14 px-2 flex-lg-row flex-column">
						    Reciever<span class="fw-normal text-capitalize">
						        <?php
                    	            $userData = App\Models\Users::where('id',$transaction_details->receiverID)->first();
                    	            if(!empty($userData->firstName) && !empty($userData->lastName)){
                    	                echo $userData->firstName." ".$userData->lastName;
                    	            }
                    	       ?>
						    </span>
						</li>
						<li class="list-group-item d-flex justify-content-between align-items-center py-3 border-0 border-bottom fs-14 px-2 flex-lg-row flex-column">
						    Type<span class="fw-normal text-capitalize">
						        <?php
                    	            if($transaction_details->type == "2"){
                    	                echo "Deposit";
                    	            }else{
                    	                echo "Withdrawal";
                    	            }
                    	        ?>
						    </span>
						</li>
						<li class="list-group-item d-flex justify-content-between align-items-center py-3 border-0 fs-14 px-2 flex-lg-row flex-column border-bottom">
						    Amount
						    <?php
                	            if($transaction_details->type == "2"){
                	        ?>
						        <span class="fw-normal text-capitalize text-success"> + ${{ $transaction_details->amount }}</span>
						    <?php }else{ ?>
						        <span class="fw-normal text-capitalize text-danger"> - ${{ $transaction_details->amount }}</span>
						    <?php } ?>
						</li>
						<li class="list-group-item d-flex justify-content-between align-items-center py-3 border-0  fs-14 px-2 flex-lg-row flex-column border-bottom">
						    Status
						    <?php
                	            if($transaction_details->paymentStatus == "paid"){
                	        ?>
						        <span class="text-capitalize text-success lbl_spc " style="">Successful</span>
						    <?php }else{ ?>
							    <span class="text-capitalize text-danger lbl_spc" style="display: none;">Failed</span>
							<?php } ?>
						</li>
						<?php
            	            if($transaction_details->type == "2"){
            	        ?>
    						<!--li class="list-group-item d-flex justify-content-left align-items-start py-3 border-0 fs-14 px-2 flex-column text-start">
    						        Description
    						        <span class="text-capitalize mt-2 fw-normal dec_bsk">
    						            Lorem ipsum dolor sit amet consectetur. Sollicitudin enim malesuada semper velit in in netus.
    						        </span>
    						</li-->
    					<?php } ?>
					</ul>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection