@extends('admin/layout.main') 
@section('content')
<div class="row">
	<div class="col-12">
		<div class="header">
			<div class="d-block d-sm-flex align-items-center justify-content-between">
				<p class="fs-18 mb-0 d-flex align-items-center bg-transparent titlebrown">
					<span>
						<svg xmlns="http://www.w3.org/2000/svg" width="20" height="22" viewBox="0 0 19 22" fill="none">
							<path d="M17 11.5V5.8C17 4.11984 17 3.27976 16.673 2.63803C16.3854 2.07354 15.9265 1.6146 15.362 1.32698C14.7202 1 13.8802 1 12.2 1H5.8C4.11984 1 3.27976 1 2.63803 1.32698C2.07354 1.6146 1.6146 2.07354 1.32698 2.63803C1 3.27976 1 4.11984 1 5.8V16.2C1 17.8802 1 18.7202 1.32698 19.362C1.6146 19.9265 2.07354 20.3854 2.63803 20.673C3.27976 21 4.11984 21 5.8 21H9M11 10H5M7 14H5M13 6H5M11.5 18L13.5 20L18 15.5" stroke="#222222" stroke-width="1" stroke-linecap="round" stroke-linejoin="round"></path>
						</svg>
					</span>
					<span class="mt-1 ms-2">Report Management</span>
				</p>
			</div>
		</div>
	</div>
</div>

<div class="row pt-4 tbl_blk">
	<div class="col-lg-12">
		<div class="border-0">
			<div class="card global-shadow p-4 w-100 tbl_scrl">
				<table class="isplay w-100" id="upcomingReservation">
					<thead>
						<tr>
							<th scope="col">Name</th>
							<th scope="col">Messages</th>
							<th scope="col">Time</th>
							<th scope="col"></th>
						</tr>
					</thead>
					<tbody>
					    @foreach ($reports as $report)
    						<tr>
    							<td>
    								<div class="d-flex align-items-center">
    									<div class="avtar_45 me-2 rounded-circle overflow-hidden">
    									    <?php 
            							        if(!empty($report->userProfile) && isset($report->userProfile)){
                        				            $img = url('/storage/app/public/uploads/users/'.$report->userProfile);
            							        }else{
            							            $img = 'public/admin/assets/images/user2.png';
            							        }
                        				    ?>
    										<img src="{{ asset($img) }}" alt="" class="fit-img">
    									</div>
    									<p class="mb-0">{{ $report->firstName." ".$report->lastName }}</p>
    								</div>
    							</td>
    							<td>{{ $report->message }}</td>
    							<td>
    							    <?php 
                                        date_default_timezone_set($userIp);
                                        echo date( 'H:i A',strtotime($report->created_at .' UTC') );
    							    ?>
    							</td>
    							<td>
    							    <a href="javascript:void(0);" report_id="{{ $report->id }}" user_email="{{ $report->email }}" class="vw_btn replyToUser" data-bs-toggle="modal" data-bs-target="#exampleModal">
    							        Reply Now
    							    </a>
    							</td>
    						</tr>
					    @endforeach	
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>

<!-- Modal -->
<div class="modal fade rply" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel"
	aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
		    <form id="reportForm">
			@csrf
    			<div class="row">
    				<div class="col-md-12 p-4 card">
    					<button type="button" class="btn-close ms-auto border rounded-circle p-2 fs-10 border-dark"
    						data-bs-dismiss="modal" aria-label="Close"></button>
    					<label for="" class="fs-4 mb-2">Enter Your Message</label>
    					<textarea class="w-100 mb-3 rounded" name="reply_msg" id="reply_msg" placeholder="Reply Now" required></textarea>
    					<input type="hidden" name="report_id" id="report_id">
    					<input type="hidden" name="user_email" id="user_email">
    					<input type="submit" class="vw_btn btn ">
    				</div>
    			</div>
    		</form>
		</div>
	</div>
</div>
</div>
@endsection