@extends('admin/layout.main') 
@section('content')
<div class="row">
	<div class="col-12">
		<div class="header">
			<div class="row">
				<div class="col-xl-6 col-12 col-md-6">
					<p class="fs-18 mb-0 d-flex align-items-center bg-transparent titlebrown">
						<span>
							<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
								<path d="M10.5 11.375C12.9162 11.375 14.875 9.41625 14.875 7C14.875 4.58375 12.9162 2.625 10.5 2.625C8.08375 2.625 6.125 4.58375 6.125 7C6.125 9.41625 8.08375 11.375 10.5 11.375Z" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
								<path d="M17.5 18.375C17.5 16.5185 16.7625 14.738 15.4497 13.4253C14.137 12.1125 12.3565 11.375 10.5 11.375C8.64348 11.375 6.86301 12.1125 5.55025 13.4253C4.2375 14.738 3.5 16.5185 3.5 18.375" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
							</svg>
						</span>
						<span class="mt-1 ms-2">User Management</span>
					</p>
				</div>
				<div class="col-xl-6 col-12 col-md-6 d-flex justify-content-end flex-wrap">
				</div>
			</div>
		</div>
	</div>
</div>
<div class="row pt-4 tbl_blk">
	<div class="col-lg-12">
		<div class="border-0">
			<div class="card global-shadow p-4 w-100 tbl_scrl">
				<table class="isplay w-100" id="upcomingReservation">
					<thead>
						<tr>
							<th scope="col">Name</th>
							<th scope="col">Email address</th>
							<th scope="col">Phone number</th>
							<th scope="col">Action Status</th>
							<th scope="col"></th>
							<th scope="col"></th>
						</tr>
					</thead>
					<tbody>
					    @foreach ($users as $user)
    						<tr>
    							<td>
    								<div class="d-flex align-items-center">
    									<div class="avtar_45 me-2 rounded-circle overflow-hidden">
    									    <?php 
            							        if(!empty($user->userProfile) && isset($user->userProfile)){
                        				            $img = url('/storage/app/public/uploads/users/'.$user->userProfile);
            							        }else{
            							            $img = 'public/admin/assets/images/user2.png';
            							        }
                        				    ?>
    										<img src="{{ asset($img) }}" alt="" class="fit-img">
    									</div>
    									<p class="mb-0">{{ $user->firstName." ".$user->lastName }}</p>
    								</div>
    							</td>
    							<td>{{ $user->email }}</td>
    							<td>{{ $user->phoneNumber }}</td>
    							<td>
    								<div class="button-group btn_grp_spc">
    								    <?php
    								        if($user->status == "0"){
    								    ?>
        									<button onclick="toggleButton(this)" class="active approveRejectProfile" type="1"  user-id="{{ $user->id }}">
        									    Accept
        									</button>
        									<button onclick="toggleButton(this)" class="approveRejectProfile" type="0"  user-id="{{ $user->id }}">
        									    Reject
        									</button>
        								<?php
    								        }elseif($user->status == "1"){
        								?>
            								<button class="active">
        									    Accepted
        									</button>
        								<?php
    								        }else{
        								?>
        								    <button class="active" style="background-color:red;">
        									    Rejected
        									</button>
        								<?php } ?>
    								</div>
    							</td>
    							<td>
    								<a href="{{ url('/admin/user-view-details/'.$user->id) }}" class="vw_btn">
    									View Detail 
    									<span>
    										<svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 22 22" fill="none">
    											<path d="M13.2275 16.5642L18.7916 11L13.2275 5.43584" stroke="#000" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
    											<path d="M3.20836 11L18.6359 11" stroke="#000" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
    										</svg>
    									</span>
    								</a>
    							</td>
    							<td>
    								<div class="dropdown ">
    									<a class="dropdown-toggle user-profile d-flex align-items-center" id="navbarDropdown" href="#" role="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
    									</a>
    									<?php
    								        if($user->isSuspend == "0"){
        								?>
        									<div class="dropdown-menu dropdown-menu-end custom-dropdown p-3" aria-labelledby="navbarDropdown">
        										<a href="javascript:void(0);" class="btn btn-danger rounded-pill py-2 mt-2 suspendActivateUser" type="1" user-id="{{ $user->id }}">
        											Suspend Now
        											<span class="ms-2">
        												<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 140 121" fill="none">
        													<path d="M116.296 26.7707C103.585 24.2855 91.2526 32.584 88.7674 45.2943C86.2821 58.0046 94.5806 70.3372 107.291 72.8224C120.001 75.3077 132.334 67.0092 134.819 54.2989C137.304 41.5886 129.006 29.256 116.296 26.7707ZM93.3725 46.1947C95.3625 36.0173 105.218 29.3859 115.395 31.3759C119.655 32.2088 123.286 34.4249 125.917 37.4734L95.0578 58.2383C93.2248 54.6526 92.5396 50.4545 93.3725 46.1947ZM108.191 68.2173C103.932 67.3843 100.301 65.1683 97.6696 62.1198L128.529 41.3549C130.362 44.9406 131.047 49.1386 130.214 53.3984C128.224 63.5759 118.369 70.2073 108.191 68.2173Z" fill="white"/>
        													<path d="M68.7373 30.5313C68.7373 31.6599 68.6605 32.7884 68.5197 33.9041C68.5837 33.4553 68.6477 32.9936 68.6989 32.5448C68.3917 34.7762 67.8029 36.9435 66.9453 39.0211C67.1117 38.6107 67.2909 38.2003 67.4573 37.7899C66.5997 39.8162 65.4988 41.7142 64.1548 43.4583L64.9612 42.4195C63.63 44.138 62.0811 45.6897 60.3658 47.0235L61.4027 46.2155C59.6618 47.5493 57.7674 48.665 55.7449 49.5242C56.1545 49.3575 56.5641 49.1779 56.9737 49.0112C54.9001 49.8705 52.7368 50.4604 50.5095 50.7682C50.9575 50.704 51.4183 50.6399 51.8664 50.5886C49.6263 50.8836 47.3734 50.8836 45.1333 50.5886C45.5813 50.6527 46.0422 50.7169 46.4902 50.7682C44.2629 50.4604 42.0996 49.8705 40.026 49.0112C40.4356 49.1779 40.8452 49.3575 41.2548 49.5242C39.2323 48.665 37.3379 47.5621 35.597 46.2155L36.6338 47.0235C34.9186 45.6897 33.3697 44.138 32.0385 42.4195L32.8449 43.4583C31.5137 41.7142 30.4 39.8162 29.5424 37.7899C29.7088 38.2003 29.888 38.6107 30.0544 39.0211C29.1968 36.9435 28.608 34.7762 28.3008 32.5448C28.3648 32.9936 28.4288 33.4553 28.48 33.9041C28.1856 31.6599 28.1856 29.4028 28.48 27.1585C28.416 27.6074 28.352 28.0691 28.3008 28.5179C28.608 26.2865 29.1968 24.1192 30.0544 22.0416C29.888 22.452 29.7088 22.8624 29.5424 23.2728C30.4 21.2465 31.5009 19.3485 32.8449 17.6044L32.0385 18.6432C33.3697 16.9247 34.9186 15.373 36.6338 14.0392L35.597 14.8472C37.3379 13.5134 39.2323 12.3977 41.2548 11.5385C40.8452 11.7052 40.4356 11.8847 40.026 12.0515C42.0996 11.1922 44.2629 10.6023 46.4902 10.2945C46.0422 10.3586 45.5813 10.4228 45.1333 10.4741C47.3734 10.1791 49.6263 10.1791 51.8664 10.4741C51.4183 10.4099 50.9575 10.3458 50.5095 10.2945C52.7368 10.6023 54.9001 11.1922 56.9737 12.0515C56.5641 11.8847 56.1545 11.7052 55.7449 11.5385C57.7674 12.3977 59.6618 13.5006 61.4027 14.8472L60.3658 14.0392C62.0811 15.373 63.63 16.9247 64.9612 18.6432L64.1548 17.6044C65.486 19.3485 66.5997 21.2465 67.4573 23.2728C67.2909 22.8624 67.1117 22.452 66.9453 22.0416C67.8029 24.1192 68.3917 26.2865 68.6989 28.5179C68.6349 28.0691 68.5709 27.6074 68.5197 27.1585C68.6605 28.2743 68.7245 29.4028 68.7373 30.5313C68.7501 33.2116 71.0798 35.7893 73.8575 35.6611C76.6224 35.5328 78.9905 33.404 78.9777 30.5313C78.9521 24.3885 77.1088 18.1045 73.4991 13.1031C72.5263 11.7565 71.4894 10.4356 70.3374 9.24292C69.1725 8.03743 67.8925 6.99866 66.5612 5.98554C64.142 4.13883 61.4411 2.77945 58.5738 1.72785C47.015 -2.51701 33.0753 1.26618 25.2543 10.8075C24.179 12.1156 23.155 13.475 22.2846 14.9369C21.4141 16.3861 20.7357 17.925 20.1085 19.4896C18.9308 22.3879 18.3292 25.4657 18.086 28.582C17.6124 34.6864 19.1997 41.0601 22.3742 46.2925C25.4335 51.3453 30.0544 55.6799 35.4562 58.1293C37.0435 58.8475 38.6691 59.5144 40.3588 59.9889C42.0356 60.4505 43.7381 60.707 45.4661 60.9122C48.615 61.2841 51.828 61.0276 54.9385 60.3992C66.7533 57.9883 76.648 47.7929 78.4785 35.8278C78.7473 34.0837 78.9521 32.3396 78.9521 30.5698C78.9649 27.8895 76.584 25.3118 73.8319 25.4401C71.067 25.5298 68.7373 27.6587 68.7373 30.5313ZM85.7235 110.722H20.0445C17.1388 110.722 14.2331 110.748 11.3274 110.722C11.0074 110.722 10.6874 110.696 10.3802 110.658C10.8282 110.722 11.289 110.786 11.737 110.837C11.225 110.76 10.7386 110.619 10.2649 110.427C10.6746 110.594 11.0842 110.773 11.4938 110.94C10.9818 110.722 10.5082 110.44 10.0601 110.094L11.097 110.902C10.713 110.581 10.3546 110.235 10.0473 109.85L10.8538 110.889C10.5082 110.44 10.2393 109.965 10.0089 109.452C10.1753 109.863 10.3545 110.273 10.521 110.684C10.3289 110.209 10.2009 109.709 10.1113 109.209C10.1753 109.658 10.2393 110.119 10.2905 110.568C10.0857 109.016 10.2265 107.375 10.2265 105.81V100.321C10.2265 98.9492 10.3033 97.5899 10.4826 96.2305C10.4186 96.6793 10.3546 97.141 10.3033 97.5899C10.6618 94.9609 11.353 92.3832 12.3898 89.9337C12.2234 90.3441 12.0442 90.7545 11.8778 91.1649C12.8762 88.8308 14.1563 86.6379 15.7051 84.6244L14.8987 85.6632C16.4476 83.6754 18.2268 81.88 20.2237 80.3283L19.1868 81.1362C21.1965 79.5845 23.3854 78.302 25.7151 77.3017C25.3055 77.4685 24.8958 77.648 24.4862 77.8147C26.9311 76.7888 29.4912 76.0834 32.1281 75.7243C31.6801 75.7885 31.2193 75.8526 30.7712 75.9039C32.6657 75.6602 34.5474 75.6474 36.4546 75.6474H59.8794C61.9915 75.6474 64.0908 75.6346 66.2028 75.9039C65.7548 75.8398 65.294 75.7756 64.846 75.7243C67.4701 76.0834 70.043 76.7759 72.4879 77.8147C72.0782 77.648 71.6686 77.4685 71.259 77.3017C73.5887 78.302 75.7776 79.5845 77.7872 81.1362L76.7504 80.3283C78.7345 81.88 80.5265 83.6626 82.0754 85.6632L81.269 84.6244C82.8178 86.6379 84.0979 88.8308 85.0963 91.1649C84.9299 90.7545 84.7507 90.3441 84.5843 89.9337C85.6083 92.3832 86.3123 94.948 86.6707 97.5899C86.6067 97.141 86.5427 96.6793 86.4915 96.2305C86.7347 98.167 86.7475 100.091 86.7475 102.04V108.388C86.7475 109.119 86.7731 109.85 86.6835 110.568C86.7475 110.119 86.8115 109.658 86.8627 109.209C86.7859 109.722 86.6451 110.209 86.4531 110.684C86.6195 110.273 86.7987 109.863 86.9651 109.452C86.7475 109.965 86.4659 110.44 86.1203 110.889L86.9267 109.85C86.6067 110.235 86.2611 110.594 85.8771 110.902L86.9139 110.094C86.4659 110.44 85.9923 110.709 85.4803 110.94C85.8899 110.773 86.2995 110.594 86.7091 110.427C86.2355 110.619 85.7363 110.748 85.2371 110.837C85.6851 110.773 86.1459 110.709 86.5939 110.658C86.3123 110.696 86.0179 110.709 85.7235 110.722C84.4051 110.735 83.0482 111.286 82.101 112.222C81.2177 113.107 80.5393 114.569 80.6033 115.852C80.7313 118.596 82.8562 121.02 85.7235 120.981C90.7029 120.905 95.0806 117.647 96.5399 112.864C97.1159 110.966 96.9879 108.927 96.9879 106.977C96.9879 102.514 97.1287 98.09 96.3607 93.6656C95.2342 87.1893 91.9829 81.0978 87.5284 76.3143C83.0738 71.5308 77.0832 68.0169 70.747 66.4523C67.1117 65.5546 63.4508 65.4136 59.7386 65.4136H37.0307C33.2289 65.4136 29.4528 65.5931 25.7535 66.5806C19.4685 68.2478 13.5547 71.8001 9.18971 76.622C4.78636 81.4825 1.59905 87.5869 0.562218 94.1016C-0.129006 98.4747 0.0117987 102.861 0.0117987 107.272C0.0117987 109.298 -0.103405 111.415 0.62622 113.351C1.57345 115.839 3.0839 117.801 5.29838 119.276C7.02644 120.417 9.21531 120.969 11.2634 120.994C12.2618 121.007 13.2602 120.994 14.2587 120.994H85.7363C88.4116 120.994 90.9845 118.635 90.8565 115.865C90.7285 113.069 88.6036 110.722 85.7235 110.722Z" fill="white"/>
        												</svg>
        											</span>
        										</a>
        									</div>
        								<?php }else{ ?>
            								<div class="dropdown-menu dropdown-menu-end custom-dropdown p-3" aria-labelledby="navbarDropdown">
        										<a style="background-color:#4fe738;" href="javascript:void(0);" class="btn btn-danger suspendActivateUser rounded-pill py-2 mt-2" type="0" user-id="{{ $user->id }}">
        											Activate Now
        											<span class="ms-2">
        												<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 140 121" fill="none">
        													<path d="M116.296 26.7707C103.585 24.2855 91.2526 32.584 88.7674 45.2943C86.2821 58.0046 94.5806 70.3372 107.291 72.8224C120.001 75.3077 132.334 67.0092 134.819 54.2989C137.304 41.5886 129.006 29.256 116.296 26.7707ZM93.3725 46.1947C95.3625 36.0173 105.218 29.3859 115.395 31.3759C119.655 32.2088 123.286 34.4249 125.917 37.4734L95.0578 58.2383C93.2248 54.6526 92.5396 50.4545 93.3725 46.1947ZM108.191 68.2173C103.932 67.3843 100.301 65.1683 97.6696 62.1198L128.529 41.3549C130.362 44.9406 131.047 49.1386 130.214 53.3984C128.224 63.5759 118.369 70.2073 108.191 68.2173Z" fill="white"/>
        													<path d="M68.7373 30.5313C68.7373 31.6599 68.6605 32.7884 68.5197 33.9041C68.5837 33.4553 68.6477 32.9936 68.6989 32.5448C68.3917 34.7762 67.8029 36.9435 66.9453 39.0211C67.1117 38.6107 67.2909 38.2003 67.4573 37.7899C66.5997 39.8162 65.4988 41.7142 64.1548 43.4583L64.9612 42.4195C63.63 44.138 62.0811 45.6897 60.3658 47.0235L61.4027 46.2155C59.6618 47.5493 57.7674 48.665 55.7449 49.5242C56.1545 49.3575 56.5641 49.1779 56.9737 49.0112C54.9001 49.8705 52.7368 50.4604 50.5095 50.7682C50.9575 50.704 51.4183 50.6399 51.8664 50.5886C49.6263 50.8836 47.3734 50.8836 45.1333 50.5886C45.5813 50.6527 46.0422 50.7169 46.4902 50.7682C44.2629 50.4604 42.0996 49.8705 40.026 49.0112C40.4356 49.1779 40.8452 49.3575 41.2548 49.5242C39.2323 48.665 37.3379 47.5621 35.597 46.2155L36.6338 47.0235C34.9186 45.6897 33.3697 44.138 32.0385 42.4195L32.8449 43.4583C31.5137 41.7142 30.4 39.8162 29.5424 37.7899C29.7088 38.2003 29.888 38.6107 30.0544 39.0211C29.1968 36.9435 28.608 34.7762 28.3008 32.5448C28.3648 32.9936 28.4288 33.4553 28.48 33.9041C28.1856 31.6599 28.1856 29.4028 28.48 27.1585C28.416 27.6074 28.352 28.0691 28.3008 28.5179C28.608 26.2865 29.1968 24.1192 30.0544 22.0416C29.888 22.452 29.7088 22.8624 29.5424 23.2728C30.4 21.2465 31.5009 19.3485 32.8449 17.6044L32.0385 18.6432C33.3697 16.9247 34.9186 15.373 36.6338 14.0392L35.597 14.8472C37.3379 13.5134 39.2323 12.3977 41.2548 11.5385C40.8452 11.7052 40.4356 11.8847 40.026 12.0515C42.0996 11.1922 44.2629 10.6023 46.4902 10.2945C46.0422 10.3586 45.5813 10.4228 45.1333 10.4741C47.3734 10.1791 49.6263 10.1791 51.8664 10.4741C51.4183 10.4099 50.9575 10.3458 50.5095 10.2945C52.7368 10.6023 54.9001 11.1922 56.9737 12.0515C56.5641 11.8847 56.1545 11.7052 55.7449 11.5385C57.7674 12.3977 59.6618 13.5006 61.4027 14.8472L60.3658 14.0392C62.0811 15.373 63.63 16.9247 64.9612 18.6432L64.1548 17.6044C65.486 19.3485 66.5997 21.2465 67.4573 23.2728C67.2909 22.8624 67.1117 22.452 66.9453 22.0416C67.8029 24.1192 68.3917 26.2865 68.6989 28.5179C68.6349 28.0691 68.5709 27.6074 68.5197 27.1585C68.6605 28.2743 68.7245 29.4028 68.7373 30.5313C68.7501 33.2116 71.0798 35.7893 73.8575 35.6611C76.6224 35.5328 78.9905 33.404 78.9777 30.5313C78.9521 24.3885 77.1088 18.1045 73.4991 13.1031C72.5263 11.7565 71.4894 10.4356 70.3374 9.24292C69.1725 8.03743 67.8925 6.99866 66.5612 5.98554C64.142 4.13883 61.4411 2.77945 58.5738 1.72785C47.015 -2.51701 33.0753 1.26618 25.2543 10.8075C24.179 12.1156 23.155 13.475 22.2846 14.9369C21.4141 16.3861 20.7357 17.925 20.1085 19.4896C18.9308 22.3879 18.3292 25.4657 18.086 28.582C17.6124 34.6864 19.1997 41.0601 22.3742 46.2925C25.4335 51.3453 30.0544 55.6799 35.4562 58.1293C37.0435 58.8475 38.6691 59.5144 40.3588 59.9889C42.0356 60.4505 43.7381 60.707 45.4661 60.9122C48.615 61.2841 51.828 61.0276 54.9385 60.3992C66.7533 57.9883 76.648 47.7929 78.4785 35.8278C78.7473 34.0837 78.9521 32.3396 78.9521 30.5698C78.9649 27.8895 76.584 25.3118 73.8319 25.4401C71.067 25.5298 68.7373 27.6587 68.7373 30.5313ZM85.7235 110.722H20.0445C17.1388 110.722 14.2331 110.748 11.3274 110.722C11.0074 110.722 10.6874 110.696 10.3802 110.658C10.8282 110.722 11.289 110.786 11.737 110.837C11.225 110.76 10.7386 110.619 10.2649 110.427C10.6746 110.594 11.0842 110.773 11.4938 110.94C10.9818 110.722 10.5082 110.44 10.0601 110.094L11.097 110.902C10.713 110.581 10.3546 110.235 10.0473 109.85L10.8538 110.889C10.5082 110.44 10.2393 109.965 10.0089 109.452C10.1753 109.863 10.3545 110.273 10.521 110.684C10.3289 110.209 10.2009 109.709 10.1113 109.209C10.1753 109.658 10.2393 110.119 10.2905 110.568C10.0857 109.016 10.2265 107.375 10.2265 105.81V100.321C10.2265 98.9492 10.3033 97.5899 10.4826 96.2305C10.4186 96.6793 10.3546 97.141 10.3033 97.5899C10.6618 94.9609 11.353 92.3832 12.3898 89.9337C12.2234 90.3441 12.0442 90.7545 11.8778 91.1649C12.8762 88.8308 14.1563 86.6379 15.7051 84.6244L14.8987 85.6632C16.4476 83.6754 18.2268 81.88 20.2237 80.3283L19.1868 81.1362C21.1965 79.5845 23.3854 78.302 25.7151 77.3017C25.3055 77.4685 24.8958 77.648 24.4862 77.8147C26.9311 76.7888 29.4912 76.0834 32.1281 75.7243C31.6801 75.7885 31.2193 75.8526 30.7712 75.9039C32.6657 75.6602 34.5474 75.6474 36.4546 75.6474H59.8794C61.9915 75.6474 64.0908 75.6346 66.2028 75.9039C65.7548 75.8398 65.294 75.7756 64.846 75.7243C67.4701 76.0834 70.043 76.7759 72.4879 77.8147C72.0782 77.648 71.6686 77.4685 71.259 77.3017C73.5887 78.302 75.7776 79.5845 77.7872 81.1362L76.7504 80.3283C78.7345 81.88 80.5265 83.6626 82.0754 85.6632L81.269 84.6244C82.8178 86.6379 84.0979 88.8308 85.0963 91.1649C84.9299 90.7545 84.7507 90.3441 84.5843 89.9337C85.6083 92.3832 86.3123 94.948 86.6707 97.5899C86.6067 97.141 86.5427 96.6793 86.4915 96.2305C86.7347 98.167 86.7475 100.091 86.7475 102.04V108.388C86.7475 109.119 86.7731 109.85 86.6835 110.568C86.7475 110.119 86.8115 109.658 86.8627 109.209C86.7859 109.722 86.6451 110.209 86.4531 110.684C86.6195 110.273 86.7987 109.863 86.9651 109.452C86.7475 109.965 86.4659 110.44 86.1203 110.889L86.9267 109.85C86.6067 110.235 86.2611 110.594 85.8771 110.902L86.9139 110.094C86.4659 110.44 85.9923 110.709 85.4803 110.94C85.8899 110.773 86.2995 110.594 86.7091 110.427C86.2355 110.619 85.7363 110.748 85.2371 110.837C85.6851 110.773 86.1459 110.709 86.5939 110.658C86.3123 110.696 86.0179 110.709 85.7235 110.722C84.4051 110.735 83.0482 111.286 82.101 112.222C81.2177 113.107 80.5393 114.569 80.6033 115.852C80.7313 118.596 82.8562 121.02 85.7235 120.981C90.7029 120.905 95.0806 117.647 96.5399 112.864C97.1159 110.966 96.9879 108.927 96.9879 106.977C96.9879 102.514 97.1287 98.09 96.3607 93.6656C95.2342 87.1893 91.9829 81.0978 87.5284 76.3143C83.0738 71.5308 77.0832 68.0169 70.747 66.4523C67.1117 65.5546 63.4508 65.4136 59.7386 65.4136H37.0307C33.2289 65.4136 29.4528 65.5931 25.7535 66.5806C19.4685 68.2478 13.5547 71.8001 9.18971 76.622C4.78636 81.4825 1.59905 87.5869 0.562218 94.1016C-0.129006 98.4747 0.0117987 102.861 0.0117987 107.272C0.0117987 109.298 -0.103405 111.415 0.62622 113.351C1.57345 115.839 3.0839 117.801 5.29838 119.276C7.02644 120.417 9.21531 120.969 11.2634 120.994C12.2618 121.007 13.2602 120.994 14.2587 120.994H85.7363C88.4116 120.994 90.9845 118.635 90.8565 115.865C90.7285 113.069 88.6036 110.722 85.7235 110.722Z" fill="white"/>
        												</svg>
        											</span>
        										</a>
            								</div>
        								<?php } ?>
    								</div>
    							</td>
    						</tr>
						@endforeach
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
@endsection