@extends('admin/layout.main') 
@section('content')
<div class="row">
	<div class="col-12">
		<div class="header">
			<div class="d-block d-sm-flex align-items-center justify-content-between">
				<p class="fs-18 mb-0 d-flex align-items-center bg-transparent titlebrown">
					<span>
						<a href="{{ url('/admin/user-management') }}">
							<svg xmlns="http://www.w3.org/2000/svg" width="17" height="15" viewBox="0 0 17 15" fill="none">
								<path d="M0.999998 7.0246L16 7.0246" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
								<path d="M7.04993 13.049L0.999927 7.025L7.04993 1" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
							</svg>
						</a>
					</span>
					<span class="mt-1 ms-2">User Management Details</span>
				</p>
			</div>
		</div>
	</div>
</div>
<div class="row pt-4 justify-content-evenly my-3">
<div class="col-md-7">
	<div class="pro_dta">
		<div class="row justify-content-left align-items-center">
			<div class="col-md-12" style="
				">
				<div class="sub_img mx-auto mt-0">
				    <?php 
				        if(!empty($user_details->userProfile)){
				            $img = url('/storage/app/public/uploads/users/'.$user_details->userProfile);
				        }else{
				            $img = 'public/admin/assets/images/user2.png';
				        }
				    ?>
					<img src="{{ asset($img) }}" alt="" class="img-fluid object-fit-cover">
				</div>
				<ul class="list-group">
					<li class="list-group-item d-flex justify-content-center align-items-center border-0 fs-5 px-2 flex-lg-row flex-column text-capitalize fw-bold ">
					    Personal information
					</li>
				</ul>
			</div>
			<div class="col-md-12">
				<div class="border-0">
					<div class="card global-shadow w-100">
						<ul class="list-group my-3">
							<li class="list-group-item d-flex justify-content-between align-items-center py-3 border-0 border-bottom fs-14 px-2 flex-lg-row flex-column text-capitalize">
							    First name<span class="fw-600 text-capitalize">{{ $user_details->firstName }}</span>
							</li>
							<li class="list-group-item d-flex justify-content-between align-items-center py-3 border-0 border-bottom fs-14 px-2 flex-lg-row flex-column">
							    Last name<span class="fw-600 ">{{ $user_details->lastName }}</span>
							</li>
							<li class="list-group-item d-flex justify-content-between align-items-center py-3 border-0 fs-14 px-2 flex-lg-row flex-column border-bottom">
                			    Email
                			    <span class="fw-600">
                			        <?php
                			            if(!empty($user_bank->email)){
                			                echo $user_bank->email;
                			            }
                			        ?>
                			    </span>
                			</li>
                			<li class="list-group-item d-flex justify-content-between align-items-center py-3 border-0 fs-14 px-2 flex-lg-row flex-column border-bottom">
                			    Phone number
                			    <span class="fw-600">
                			        <?php
                			            if(!empty($user_bank->phoneNumber)){
                			                echo "+".$user_details->countryCode." ".$user_bank->phoneNumber;
                			            }
                			        ?>
                			    </span>
                			</li>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="pro_dta my-4">
		<ul class="list-group">
			<li class="list-group-item d-flex justify-content-center align-items-center border-0 fs-5 px-2 flex-lg-row flex-column text-capitalize fw-bold">
			  Other details
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3 border-0 fs-14 px-2 flex-lg-row flex-column border-bottom">
			    Date of birth<span class="fw-600">
			        <?php 
			            if(!empty($user_bank->dob)){ echo date("d F, Y",strtotime($user_bank->dob)); } 
			        ?>
			    </span>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3 border-0 fs-14 px-2 flex-lg-row flex-column border-bottom">
			    Country<span class="fw-600">
			        <?php
			            if(!empty($user_bank->country)){
			                echo $user_bank->country;
			            }elseif(!empty($user_details->country)){
			                echo $user_details->country;   
			            }elseif(!empty($user_details->country) && !empty($user_bank->country)){
			                echo $user_details->country."(".$user_bank->country.")";
			            }
			        ?>
			    </span>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3 border-0 fs-14 px-2 flex-lg-row flex-column border-bottom">
			    Address<span class="fw-600">
			        <?php
			            if(!empty($user_bank->street)){
			                echo $user_bank->street;
			            }
			        ?>
			    </span>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3 border-0 fs-14 px-2 flex-lg-row flex-column border-bottom">
			    City<span class="fw-600">
			        <?php
			            if(!empty($user_bank->city)){
			                echo $user_bank->city;
			            }
			        ?>
			    </span>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3 border-0 fs-14 px-2 flex-lg-row flex-column border-bottom">
			    Zip code<span class="fw-600">
			        <?php
			            if(!empty($user_bank->postalCode)){
			                echo $user_bank->postalCode;
			            }
			        ?>
			    </span>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3 border-0 fs-14 px-2 flex-lg-row flex-column border-bottom">
			    State<span class="fw-600">
			        <?php
			            if(!empty($user_bank->state)){
			                echo $user_bank->state;
			            }
			        ?>
			    </span>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3 border-0 fs-14 px-2 flex-lg-row flex-column border-bottom">
			    Identity number<span class="fw-600">
			        <?php
			            if(!empty($user_bank->identityNumber)){
			                echo $user_bank->identityNumber;
			            }
			        ?>
			    </span>
			</li>
		</ul>
	</div>
</div>

<div class="col-md-4">
    <div class="pro_dta">
		<ul class="list-group">
			<li class="list-group-item d-flex justify-content-center align-items-center border-0 fs-5 px-2 flex-lg-row flex-column text-capitalize fw-bold ">Bank Documents 
			</li>
		</ul>
		<?php 
	        if(!empty($user_bank->frontIdentity)){
	            $frontDocBank = url('/storage/app/public/uploads/externalAccounts/'.$user_bank->frontIdentity);
	        }else{
	            $frontDocBank = 'public/admin/assets/images/blankdoc.jpg';
	        }
	        
	        if(!empty($user_bank->backIdentity)){
	            $backDocBank = url('/storage/app/public/uploads/externalAccounts/'.$user_bank->backIdentity);
	        }else{
	            $backDocBank = 'public/admin/assets/images/blankdoc.jpg';
	        }
	    ?>
		<h5 class="text-center fw-bold fs-18 my-3">License</h5>
		<div class="col-md-12 my-2">
		    <h3 class="text-left fs-16 my-3">Front side</h3>
			<img src="{{ asset($frontDocBank) }}" alt="" class="img-fluid fit-img thumbnails" data-large="{{ asset($frontDocBank) }}" data-scale="3">
		</div>
		<div class="col-md-12 my-2">
		    <h3 class="text-left fs-16 my-3">Back side</h3>
			<img src="{{ asset($backDocBank) }}" alt="" class="img-fluid fit-img thumbnails" data-large="{{ asset($backDocBank) }}" data-scale="3">
		</div>
		
	</div>
</div>
<div class="pro_dta d-none">
		<div class="row justify-content-left align-items-center">
		    <?php 
		        if(!empty($user_details->identityFront)){
		            $frontDoc = url('/storage/app/public/uploads/documents/'.$user_details->identityFront);
		        }else{
		            $frontDoc = 'public/admin/assets/images/blankdoc.jpg';
		        }
		        
		        if(!empty($user_details->identityBack)){
		            $backDoc = url('/storage/app/public/uploads/documents/'.$user_details->identityBack);
		        }else{
		            $backDoc = 'public/admin/assets/images/blankdoc.jpg';
		        }
		    ?>
			<div class="col-md-12" style="
				">
				<ul class="list-group">
					<li class="list-group-item d-flex justify-content-center align-items-center border-0 fs-5 px-2 flex-lg-row flex-column text-capitalize fw-bold ">
					    Documents
					</li>
				</ul>
				<h5 class="text-left fw-bold fs-18 my-3">License</h5>
			</div>
			<div class="col-md-6">
				<img src="{{ asset($frontDoc) }}" alt="" class="img-fluid fit-img thumbnails" data-large="{{ asset($frontDoc) }}" data-scale="3">
			</div>
			<div class="col-md-6 my-3">
				<img src="{{ asset($backDoc) }}" alt="" class="img-fluid fit-img thumbnails" data-large="{{ asset($backDoc) }}" data-scale="3">
			</div>
		</div>
	</div>
</div>
@endsection