<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Api\v1\UsersController;
use App\Http\Controllers\Api\v1\CronJobController;


/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

//Cronjobs routes
Route::controller(CronJobController::class)->group(function()
{
    route::get('decline-pending-requests','declinePendingRequests');
});

//Routes without token authorization
Route::controller(UsersController::class)->prefix('users')->group(function()
{
    route::post('register','register');
    route::post('login','login');
    route::post('forgot-password','forgotPassword');
    route::post('otp-verification','otpVerification');
    route::post('resend-otp','sendOtpAgain');
    route::post('create-new-password','createNewPassword');
    route::post('home-search-user','homeSearchUser');
    route::post('check-users','checkUsers');
    route::post('scanned-user-details','scannedUserDetails');
});

//Routes with token authorization
Route::middleware(['auth:sanctum'])->controller(UsersController::class)->prefix('users')->group(function()
{
    route::get('profile/detail','profileDetail');
    route::get('profile/qrCode','getQrCode');
    route::post('otp/resend','resendOTP');
    route::post('verify','verifyPhoneNumber');
    route::post('profile/create','createProfile');
    route::post('profile/update','updateProfile');
    route::post('document/upload','uploadDocuments');
    route::post('card/add','addCard');
    route::post('logout','logout');
    route::delete('card/delete/{id}','deleteCard');
    route::get('cards','cards');
    route::post('password/change','changePassword');
    route::post('contactus','contactus');
    route::post('bank/account/add','createExternalAccount');
    route::post('bank/account/documents','uploadDocumentOfExternalAccount');
    route::post('bank/account/add-bank-details','addBankOfExternalAccount');
    route::post('bank/account/add-new-bank','addNewBank');
    route::post('bank/account/delete-bank','deleteBank');
    route::get('bank/account/get-bank-details','bankDetails');
    route::post('request-payment','requestPayment');
    route::post('decline-payment-request','declinePaymentRequest');
    route::post('make-payment','makePayment');
    route::post('send-money-to-phone-number','sendMoneyToPhoneNumber');
    route::post('send-money-to-qrcode','sendMoneyToQrCode');
    route::post('add-money-to-wallet','addMoneyToWallet');
    route::post('send-money-to-bank','sendMoneyToBank');
    route::post('view-transactions','transactions');
    route::post('view-transaction-details','transactionDetails');
    route::post('home-screen-contacts','homeScreenContacts');
    route::post('transaction-history','transactionHistory');
    route::post('delete-account','deleteAccount');
    route::get('notifications','getNotifications');
});

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
