<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\App;

//Admin Panel Controller
use App\Http\Controllers\AdminController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

/******** Admin Panel Routes start ***********/
Route::get('/about-us', [AdminController::class, 'aboutUs']);
Route::get('/term-and-policy', [AdminController::class, 'termAndPolicy']);
//Login
Route::get('/admin/login', [AdminController::class, 'index'])->name('adminLogin');
Route::post('/admin/post-login', [AdminController::class, 'login'])->name('adminLoginPost');
Route::group(['prefix'=>'admin','middleware' =>  'adminauth'], function () {
    Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('adminDashboard');
    Route::get('/user-management', [AdminController::class, 'userManagement']);
    Route::get('/suspend_activate_user', [AdminController::class, 'suspendActivateUser']);
    Route::get('/approve_reject_profile', [AdminController::class, 'approveRejectProfile']);
    Route::get('/user-view-details/{id}', [AdminController::class, 'userDetails']);
    Route::get('/payment-management', [AdminController::class, 'paymentManagement']);
    Route::get('/payment-view-details/{id}', [AdminController::class, 'paymentDetails']);
    Route::get('/report-management', [AdminController::class, 'reportManagement']);
    Route::post('/reply-to-user', [AdminController::class,'replyToUser'])->name('replyToUser');
    Route::get('/about-us-management', [AdminController::class, 'aboutUsManagement']);
    Route::post('/upload-content', [AdminController::class, 'uploadContent']);
    Route::get('/settings', [AdminController::class, 'settings']);
    Route::post('/change-password', [AdminController::class, 'changePassword']);
    Route::post('/upload-img', [AdminController::class, 'uploadImg']);
    Route::get('/notifications', [AdminController::class, 'getNotifications']);
    Route::get('/logout', [AdminController::class, 'logout'])->name('adminLogout');
});
/******** Admin Panel Routes end ***********/