<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Illuminate\Support\Facades\Log;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule): void
    {
        // Log::info("in scheduler");
        // $schedule->command('inspire')->hourly();
        try{
             $schedule->job(new \App\Jobs\DeleteExpiredSelfiesJob)->everyMinute();
        }catch(\Exception $e){
            Log::info("error",$e->message());
        }
          try{
           $schedule->job(new \App\Jobs\CancelRideOnDriverNotReached)->everyMinute();
        }catch(\Exception $e){
            Log::info("error",$e->message());
        }
        
        try{
           $schedule->job(new \App\Jobs\CancelUnacceptedRides)->everyMinute();
        }catch(\Exception $e){
            Log::info("error",$e->message());
        }
        
    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
