<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Carbon\Carbon;
use Session;
use DB;
use URL;
use File;
use App\Models\Admin;


class AdminAuthController extends Controller {

    public function getLogin() {
        return view('admin.login');
    }
    
    public function postLogin(Request $request) {
        
        $this->validate($request, [
            'email'     => 'required|email',
            'password'  => 'required',
        ]);
 
        if (auth()->guard('admin')->attempt(['email' => $request->input('email'),  'password' => $request->input('password')]) ){
            $user = auth()->guard('admin')->user();
            if ( $user->exists ){ 
                return redirect()->route('adminDashboard')->with('success','You are Logged in successfully!');
            }
        } else {
            return back()->with('error','Whoops! invalid email and password.');
            return redirect('/dashboard');
        }
        
    }
     public function showForgetPasswordForm() {
        return view('admin.auth.forgotPassword');
    }
     public function submitForgetPasswordForm(Request $request) {
        $request->validate([
            'email' => 'required|email|exists:admin,email',
            ],
            [
                'email.exists' => 'Entered email not registered with us.',
                ]
            );
            
            $token = str::random(64);
            DB::table('password_reset_tokens')->where('email', $request->email)->delete();
            DB::table('password_reset_tokens')->insert([
                'email' => $request->email,
                'token' => $token,
                'created_at' => carbon::now()
                ]);
                Mail::send('admin.auth.email', ['token' => $token], function($message) use ($request) {
                    $message->to($request->email);
                    $message->subject('Reset Password');
                });
                return redirect()->route('adminLogin')->with('success','We’ve emailed you a password reset link!');
            
    }
    
    
     public function showResetPasswordForm($token) {
        return view('admin.auth.ResetPassword', ['token' => $token]);
    }
    
    public function submitResetPasswordForm(Request $request) {
        $request->validate([
            'password' => 'required|string|min:8',
            'password_confirm' => 'required|same:password',
            ]);
            
            $updatePassword = DB::table('password_reset_tokens')->where(['token' => $request->token])->first();
            if(!$updatePassword){
                return back()->withInput()->with('error', 'Invalid token');
            }
            
            $admin = Admin::where('email', $updatePassword->email)->update(['password' =>Hash::make($request->password)]);
            DB::table('password_reset_tokens')->where(['email' => $updatePassword->email])->delete();
            return redirect()->route('adminLogin')->with('success','Your password has been successfully reset!');
    }
    
    public function termsAndConditions()
    {
        return view('admin.terms-and-conditions');
    }
    
    public function privacyPolicy()
    {
        return view('admin.privacy-policy');
    }
    
}