<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Str;
use Session;
use DB;
use URL;
use App\Models\User;
use App\Models\UserChat;
use App\Models\Booking;
use App\Models\Transaction;
use App\Models\BookingFee;
use App\Models\Faq;
use DateTimeZone;
use DateTime;

class DashboardController extends Controller
{
    public function index(Request $request) {
        $data['riders'] = User::where('user_type', 1)->count();
        $data['drivers'] = User::where('user_type', 2)->count();
        
        //get the earning of platform for only successful transactions
        $data['earnings'] = Transaction::where('status', Transaction::STATUS_SUCCEEDED)->pluck('platform_fee')->count();
        // dd($data['earnings']);
        
        $data['bookings'] = Booking::count();
        $data['recentBookings'] = Booking::with('rider', 'driver')->whereIn('status', [0,1,2,3,4,8])
        ->orderBy('created_at', 'desc')
        ->get();
        
        return view('admin.dashboard', $data);
    }
    
    public function unmatchDriver(Request $request)
        {
            $driverId = $request->input('driver_id');
            $riderId = $request->input('rider_id');
            // Locate and update the match status to '0'
            try {
                DB::table('bookings')
                    ->where('driver_id', $driverId)
                    ->where('rider_id', $riderId)
                    ->update(['driver_id' => null, 'status' => 0]);
                    
        
                return response()->json(['message' => 'Unmatched successfully'], 200);
            } catch (\Exception $e) {
                return response()->json(['error' => 'Failed to unmatch'], 500);
            }
        }

    public function manageCustomers(Request $request) {
        $data['userTimeZone'] = $this->userTimeZone();
        $data['coustomers'] = User::where('user_type', User::TYPE_RIDER)->where('is_otp_verified',1)->orderBy('id', 'DESC')->get();
        return view('admin.customers.index', $data);
    }
     public function deleteCustomer($id) {
        $customer = User::FindOrfail($id);
        $customer->delete();
        return redirect()->route( 'manageCustomers' )->with( 'success', 'Deleted successfully!' );
    }
    
    public function manageDrivers(Request $request) {
        $data['userTimeZone'] = $this->userTimeZone();
        $data['acceptedDrivers'] = User::where('user_type', User::TYPE_DRIVER)->where('status', 1)->orderBy('id', 'DESC')->get();   /* User::TYPE_RIDER = 1 */
        // $data['rejectedDrivers'] = User::where('user_type', User::TYPE_DRIVER)->where('status', 0)->orderBy('id', 'DESC')->get();   /* User::TYPE_DRIVER = 2 */
        return view('admin.drivers.index', $data);
    }
    public function manageDriversDetail($id) {
        $data['driverDetails']=DB::table('users')->leftJoin('documents', 'users.id', '=', 'documents.user_id')->where(['users.id'=>$id,'users.user_type'=>2])->first();
        return view('admin.drivers.details', $data);
    }
     public function deleteDriver($id) {
        $driver = User::FindOrfail($id);
        $driver->delete();
        return redirect()->route( 'manageDrivers' )->with( 'success', 'Deleted successfully!' );
    }
    public function bookingMngt(Request $request) {
        
        //status considers as active booking 
        $activeBookingStatus = [Booking::STATUS_PENDING,Booking::STATUS_ACCEPTED,Booking::STATUS_DELAYED];
        
        $data['activeBookings'] = Booking::with('drop_points')->whereIn('status', $activeBookingStatus)->orderBy('id', 'DESC')->get();
        
        //status considers as booking completed
        $completeBookingStatus = [Booking::STATUS_COMPLETED,Booking::STATUS_CANCELED,Booking::STATUS_REFUNDED];
        
        $data['completedBookings'] = Booking::with('drop_points')->whereIn('status', $completeBookingStatus)->orderBy('id', 'DESC')->get();
        
        
        return view('admin.booking.index', $data);
    }
     public function bookingDetail($id) {
         $data['BookingDetails'] = Booking::with(['drop_points','rider','driver'])->findOrFail($id);
        //   dd($data['BookingDetails']);
         //get admin user
         $admin = User::where('user_type',0)->first();
         $data['admin'] = $admin;
         
         $data['messages'] = UserChat::where('bookingID',$id)->get();
         
        //  dd($data);
         
        return view('admin.booking.details', $data);
    }
    public function transactionMngt(Request $request) {
        
        $data['transactions'] = Transaction::with('booking','rider', 'driver')->orderBy('id', 'desc')->get(); 
        // dd($data);
            
        return view('admin.transactions.index', $data);
    }
    public function faqMngt(Request $request) 
    {
        
         $data['faqs'] = Faq::orderBy('id', 'desc')->get();
         
        return view('admin.faq.index', $data);
    }
     public function addFaq(Request $request) {
         $validator = $this->validate($request, [
             'title' => 'required',
             'description' => 'required'
             ]);
             $faq = Faq::create($validator);
        return response()->json(['success' => true, 'message' => 'Added successfully!']);
    }
    public function editFaq(Request $request)
{
    $request->validate([
        'title' => 'required|max:100',
        'description' => 'required|max:500',
    ]);

    $faq = Faq::findOrFail($request->faq_id);
    $faq->title = $request->title;
    $faq->description = $request->description;
    $faq->save();

    return redirect()->back()->with( 'success', 'Updated successfully!' );
}
    public function deleteFaq($id) {
        $faq = Faq::FindOrfail($id); 
        $faq->delete();
        return redirect()->route('faqMngt')->with( 'success', 'Deleted successfully!' );
    }
    public function queryMngt(Request $request) {
        $data['queries']=DB::table('contact_us')->leftJoin( 'users', 'contact_us.user_id', '=', 'users.id' )->get();
        return view('admin.queries.index', $data);
    }
     public function feesMngt(Request $request) {
         $data['bookingFees'] = BookingFee::get();
        return view('admin.fee.index', $data);
    }
 public function editFee( Request $request )
{
    $request->validate([
        // 'fee_name' => 'required|max:255',
        'fee_price' => 'required',
    ]);

    $fee = BookingFee::findOrFail($request->fee_id);
    // $fee->fee_name = $request->fee_name;
    $fee->fee_price = $request->fee_price;
    $fee->description = $request->description;
    
    $fee->save();

    return redirect()->back()->with( 'success', 'Updated successfully!' );
}
    
    public function adminLogout( Request $request ) {
        auth()->guard('admin')->logout();
        Session::flush();
        Session::put( 'warning', 'You have logged out successfully!' );
        return redirect(route('adminLogin'));
    }
     public function settingPassword() {
        return view('admin.settings.changePassword');
    }
    
      public function updatePassword( Request $request ) { 
          
         $admin = auth()->guard('admin')->user();
        $this->validate($request, [
            'password' => 'required|confirmed|min:8',
            'current_password' => ['required', function ($attr, $current_password, $validation) use ($admin) {
                if (!\Hash::check($current_password, $admin->password)) {
                    return $validation(__('The current password is incorrect.'));
                }
            }]
        ]);
        $admin->update(['password' => Hash::make($request->password)]);
        return redirect()->back()->withSuccess( 'Password updated successfully!' );
    }
    
     public function activateCustomer( $id )
    {
        User::where('id', $id)->update(['status' => 1]);
        return redirect()->route( 'manageCustomers' )->with( 'success', 'Customer activated successfully!' );
    }
     public function deactivateCustomer( $id )
    {
        User::where('id', $id)->update(['status' => 0]);
        return redirect()->route( 'manageCustomers' )->with( 'success', 'Customer deactivated successfully!' );
    }
     public function activateDriver($id)
    {
        User::where('id', $id)->update(['status' => 1]);
        return redirect()->route( 'manageDrivers' )->with( 'success', 'Driver activated successfully!' );
    }
     public function deactivateDriver($id)
    {
        User::where('id', $id)->update(['status' => 0]);
        return redirect()->route( 'manageDrivers' )->with( 'success', 'Driver deactivated successfully!' );
    }
    
    public function sendMailToUsers( Request $request )
    {
        try {
            $this->validate($request, [
                'message' => ['required', function ($attr, $message, $validation) {
                    if (empty($message)) {
                        return $validation(__('required'));
                    }
                }]
            ]);
            $email =  $request->email;
            $data['subject'] = 'Send email';
            $data['blade'] = 'sendEmail';
            $data['title'] = 'Hello,';
            $data['message'] =  $request->message;
            parent::sendEmail($email, $data);
            $message = "Replied successfully.";
            $response = ["status" => 1, "message" => $message];
        } catch (\Exception $e) {
            $response = ["status" => 0, "message" => $e->getMessage()];
        }
        echo json_encode($response);
    }
    
    
   public function storeDelay( Request $request )
    {
        // Validate incoming request data
        $request->validate([
            'delay_fee' => 'required|numeric|min:0',
            'delay_time' => 'required|integer|min:1',
            'bookingID' => 'required|exists:bookings,id', // Validate the booking ID exists
        ]);
    
        // Update the specific booking record by ID
        Booking::where('id', $request->bookingID)->update([
            'rider_delay_time' => $request->delay_time,
            'rider_delay_fee' => $request->delay_fee,
        ]);
    
        return redirect()->back()->with('success', 'Updated successfully!');
    }
    
    
    public function chatView(Request $request)
    {
        dd("chat");
        try {
            $users = Users::leftJoin('room as r','users.id','=',DB::raw("IF(isAdmin = 1,r.receiverID,r.senderID)"))
            ->leftJoin('user_chat as c','c.roomID','=','r.roomID')
            ->select('users.id','users.firstName','users.lastName','users.isOnline','users.userProfile','users.user_type')
            //->limit(15)
            ->where('users.status',1)
            ->groupBy('users.id')
            ->orderBy('c.created_at', 'desc')
            ->get();

            //get admin user
            $admin = User::where('user_type',0)->first();

            $data['admin'] = $admin;
            $data['users'] = $users;
            $userID = auth()->user()->id;
            $receiverID = $users[0]['id'];
            
            
            $chat = "select *,DATE_FORMAT(created_at, '%H:%i:%s') as created_at from user_chat where 
            (receiverID = $receiverID and senderID = $userID) or 
            (receiverID = $userID and senderID = $receiverID) order by id asc";
            
            $messages = DB::select($chat);
            $data['messages'] = $messages;
            $data['firstUser'] = $users[0];
            $data['userPath'] = self::path()['userPath'];
            $data['message'] = "";
        } catch (\Exception $e)
         {
            
            $data['status'] = 0;
            echo $data['message'] = $e->getMessage();
        }

        return view('admin.booking.details', $data);
    }
    
    
   
 
    
}