<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Booking;
use App\Models\Document;
use App\Models\Notification;
use Exception;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Auth;

class UserController extends Controller
{
    
    public function uploadProfilePic(Request $request)
    {
          $validator =  $request->validate([
               'profile_picture' => 'required|mimes:jpg,jpeg,png|max:2048', 
               'step' => 'nullable',
            ]);
            
        try{
            // Handle the front image upload
            if ($request->hasFile('profile_picture')) {
                $profileImage = $request->file('profile_picture');
                $profileImageName = time().$profileImage->getClientOriginalName();
                $profileImagePath = $profileImage->storeAs('users/profiles', $profileImageName, 'public');
            }
           $updateArr = [
                'profile_pic' => $profileImagePath,
            ];
            
            if (!empty($request->step)) {
                $updateArr['step'] = $request->step;
                $updateArr['status'] = 1;
            }
            User::where('id',auth()->user()->id)->update($updateArr);
          
          return $this->jsonResponse(true, 200, 'Profile Picture Uploaded Successfully.');
            
        }catch(Exception $e){
            
            return $this->jsonResponse(false, 500, 'An error occurred.', null, 500, [$e->getMessage()]);
        }
        
    }
    
    public function uploadDrivingLicense(Request $request)
    {
        
         $validator =  $request->validate([
           'front_image' => 'required|mimes:jpg,jpeg,png|max:2048', 
           'back_image'  => 'required|mimes:jpg,jpeg,png|max:2048',
           'step' => 'nullable',
        ]);
          
        try{
            $user = auth()->user();
            
            $connectDetail = $user->connect_account;
            $accountId = $connectDetail->account_id;
            
             // Handle the front image upload
            if ($request->hasFile('front_image')) {
                $frontImage = $request->file('front_image');
                $frontImageName = time().'_front_'.$frontImage->getClientOriginalName();
                $frontImagePath = $frontImage->storeAs('documents', $frontImageName, 'public');
                 
                 //document verification connect account 
                $response =   $this->createFileVerificationId($accountId,$frontImageName,'front');
            }
    
            // Handle the back image upload
            if ($request->hasFile('back_image')) {
                $backImage = $request->file('back_image');
                $backImageName = time().'_back_'.$backImage->getClientOriginalName();
                $backImagePath = $backImage->storeAs('documents', $backImageName, 'public');
                  //document verification connect account
                $response =   $this->createFileVerificationId($accountId,$backImageName,'back');
            }
            
            
            $requirementsResponse =  $this->checkStripeRequirement($accountId);
            
           if(!empty($requirementsResponse['requirements']) && $requirementsResponse['success'] == 1){
               $verificationUrl = $this->createStripeAccountLink($accountId);
               $requirementsResponse['requirements']['verification_url'] = $verificationUrl;
               
                return $this->jsonResponse(true, 200, 'Creating Bank Account Reqirements Pending.',$requirementsResponse['requirements']);
           }
            
            // $frontImageFullPath = Storage::url($frontImagePath);
            // dd($frontImageFullPath);
            
           
            
            // Store file paths in the database
            $document = new Document();
            $document->user_id = $user->id;
            $document->front_image = $frontImagePath;
            $document->back_image = $backImagePath;
            if(!empty($request->step)){
                $user->step = $request->step;
                $user->update();
            }
            $document->save();
            
           return $this->jsonResponse(true, 200, 'Document Uploaded Successfully.');
               
        }catch(Exception $e){
            
            return $this->jsonResponse(false, 500, 'An error occurred.', null, 500, [$e->getMessage()]);
        }
    }
    
    public function uploadSelfieWithLicense(Request $request)
    {
        
        $request->validate([
           'selfie' => 'required|mimes:jpg,jpeg,png', 
        ]);
        
        try{
            
        $user = auth()->user();
        
            if($user->user_type == 2){
                // Handle the selfie image upload
                if($request->hasFile('selfie')) {
                    $selfieImage = $request->file('selfie');
                    $selfieImageName = time().'_selfie_'.$selfieImage->getClientOriginalName();
                    $selfieImagePath = $selfieImage->storeAs('selfies', $selfieImageName, 'public');
                }
                
                $user->update([
                    'selfie_path' => $selfieImagePath
                    ]);
        
                     return $this->jsonResponse(true, 200, 'Selfie Uploaded Successfully.');
            }else{
                return $this->jsonResponse(true, 400, 'User Type Not Matched.');
            }
            
        }catch(Exception $e){
            
            return $this->jsonResponse(false, 500, 'An error occurred.', null, 500, [$e->getMessage()]);
        }
        
    }
    
    public function profieDetail(Request $request)
    {
        $user = auth()->user();
        
        return $this->jsonResponse(true, 200, 'Profile Detail Fetched Successfully.', $user);
        
    }
    public function updateProfieDetail(Request $request)
    {
           $validator =  $request->validate([
            'first_name' => 'required|string|max:255',
            'last_name' => 'nullable|string|max:255',
            'email' => 'required|string|email|max:255',
            'country_code' => 'required',
        ]);
        try{
              $user = auth()->user();
             
             $updateArr = [
                 'first_name' => $request->first_name,
                 'last_name' => $request->last_name,
                 'email' => $request->email,
                 'country_code' => $request->country_code,
                 ];
                 
             //Add More Required values for the user type 
             if($user->user_type == 2){
                 $extraFields = [
                     'unit_number' => $request->unit_number,
                     'address' => $request->address,
                     'postal_code' => $request->postal_code,
                     'country' => $request->country,
                 ];
                 
                  $updateArr = array_merge($updateArr, $extraFields);
             }
             
             $user->update($updateArr);
              
            return $this->jsonResponse(true, 200, 'Profile Updated Successfully.');
            
        }catch(Exception $e){
            
            return $this->jsonResponse(false, 500, 'An error occurred.', null, 500, [$e->getMessage()]);
        }
    }
    
    public function updateSingpassProfieDetail(Request $request)
    {
           $validator = $request->validate([
            'first_name' => 'required|string|max:255',
            'last_name' => 'nullable|string|max:255',
            'email' => 'required|string|email|max:255',
            'country_code' => 'required',
            'phone' => 'required',
            'dob' => 'required',
            'unit_number' => 'required',
            'address' => 'required',
            'postal_code' => 'required',
            'country' => 'required',
            'user_type' => 'required',
            'driving_licence_status' => 'required',
            'device_type' => 'required',
            'device_token' => 'required',
            'address_lat' => 'nullable',
            'address_long' => 'nullable',
            'latitude' => 'nullable',
            'longitude' => 'nullable',
            'step' => 'required',
        ]);
        try{
           $user = auth()->user();

            // Get validated data
            $userData = $request->all();
    
            // Check if first_name contains a space
            if (strpos($userData['first_name'], ' ') !== false) {
                $nameParts = explode(' ', $userData['first_name'], 2);
                $userData['first_name'] = $nameParts[0];
                $userData['last_name'] = $nameParts[1] ?? $userData['last_name'];
            }
    
            // Generate chat token
            $userData['chat_token'] = $this->createChatToken(); 
    
            // Update user profile
            $user->update($userData);
    
            return $this->jsonResponse(true, 200, 'Profile updated successfully.');
            
        }catch(Exception $e){
            
            return $this->jsonResponse(false, 500, 'An error occurred.', null, 500, [$e->getMessage()]);
        }
    }
    
    
    public function fileUpload(Request $request)
    {
        try{
            // dd($request);
          // Validate the file input
            $request->validate([
                'file' => 'required|file|mimes:jpg,jpeg,png,pdf,mp3,webm,wav,ogg',
                'type' => 'required'
            ]);
            
            if($request->has('file')){
                if($request->type == "audio"){
                    $filePath = $this->uploadFile($request->file('file'), 'documents/audio');     
                }else{
                    $filePath = $this->uploadFile($request->file('file'), 'documents');     
                }
               
        
                if ($filePath) {
                    $response = ['path' => $filePath,'file_type' => $request->type];
                    return $this->jsonResponse(true, 200, 'File uploaded successfully!',$response);
                }  
            }
        }catch(Exception $e){
                    
            return $this->jsonResponse(false, 500, 'An error occurred.', null, 500, ["message" => $e->getMessage()]);
        }
       
    }
    
    
    public function deleteUploadedFile(Request $request)
    {
        try{
        // dd($request);
          // Validate the file input
            $request->validate([
                'file_path' => 'required',
            ]);
            
            $filePath = $request->file_path;
            
            $fullPath = storage_path("app/public/$filePath");
    
           // Check if file exists and delete it
           if (file_exists($fullPath)) {
                unlink($fullPath);
                return response()->json(['success' => true, 'message' => 'File deleted successfully!']);
            }else {
                return $this->jsonResponse(false, 404, 'File not found!');
            }
            
        }catch(Exception $e){
                    
            return $this->jsonResponse(false, 500, 'An error occurred.', null, 500, ["message" => $e->getMessage()]);
        }
       
    }
    
    public function updateCurrentLocation(Request $request)
    {
         try{
            $request->validate([
                'latitude' => 'required',
                'longitude' => 'required'
            ]);
            
            $user = auth()->user();
            
            $user->update(['latitude' => $request->latitude,'longitude' => $request->longitude]);
            
            return $this->jsonResponse(true, 200, 'Location Updated Successfully.');
      
         }catch(Exception $e){
                    
            return $this->jsonResponse(false, 500, 'An error occurred.', null, 500, ["message" => $e->getMessage()]);
        }
        
    }
    
    
    public function deleteAccount(Request $request)
    {
        try{
            
            $user = auth()->user();
            //delete all related records
            
            //check pending payment
            //delete bookings
            //delete stripe accounts 
            //delete transactions 
            
            
            $user->delete();
            
        }catch(Exception $e){
                    
            return $this->jsonResponse(false, 500, 'An error occurred.', null, 500, ["message" => $e->getMessage()]);
        }
            return $this->jsonResponse(true, 200, 'Account Deleted Successfully.');
    }
    
    public function getNotifications()
    {
        try{
             
             $user = auth()->user();
             
             $notifications = Notification::where('receiver_id', $user->id)->orderBy('created_at','desc')->get();
             
             if($notifications->isNotEmpty()){
                return $this->jsonResponse(true, 200, 'Notifications fetched successfully.', $notifications); 
             }else{
                 return $this->jsonResponse(true, 200, 'No Notification found.', $notifications);
             }
             
            }catch(Exception $e){             
                return $this->jsonResponse(false, 500, 'An error occurred.', null, 500, ["message" => $e->getMessage()]);
            }
                
    }
    
    public function driverEarnings(Request $request)
    {
        try{
            
            $user = auth()->user();
            
            if($user->user_type == User::TYPE_DRIVER){
                
                //get the earning detail for only these status
                $status = [Booking::DRIVER_STATUS_REACHED , Booking::DRIVER_STATUS_ACCEPTED, Booking::DRIVER_STATUS_START_TRIP,Booking::DRIVER_STATUS_END_TRIP];
                
                $bookings = Booking::with(['drop_points','driver','rider','charges'])->where('driver_id', $user->id)
                            ->whereIn('driver_status',$status)->orderBy('created_at','desc')->get();
                
                 return $this->jsonResponse(true, 200, 'Earnings detail fetched successfully.', $bookings);
                
                
            }else{
                 return $this->jsonResponse(true, 200, 'User type not matched.');
            }
            
            
        }catch(Exception $e){             
                return $this->jsonResponse(false, 500, 'An error occurred.', null, 500, ["message" => $e->getMessage()]);
            }
                
    }
    
    public function driverEarningDetail(Request $request)
    {
        try{
            
        }catch(Exception $e){             
                return $this->jsonResponse(false, 500, 'An error occurred.', null, 500, ["message" => $e->getMessage()]);
            }
                
    }
}
