<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Mail;
use App\Mail\replyEmail;
use URL;
use Illuminate\Support\Str;
use App\Models\Notification;
use Carbon\Carbon;

class Controller extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;
    
    public function jsonResponse($success, $status, $message, $data = null, $httpStatus = 200, $error = null)
    {
        $response = [
            'success' => $success,
        ];
    
        if ($data) {
            $response['data'] = $data;
        }
    
        $response['status'] = $status;
        $response['message'] = $message;
    
        if ($error) {
            $response['error'] = $error; 
        }
    
        return response()->json($response, $httpStatus);
    }
    
    
    function deleteFile($path)
    {
        if (Storage::exists($path)) {
            Storage::delete($path);
            return response()->json(['message' => 'File deleted successfully']);
        } else {
            return response()->json(['message' => 'File does not exist'], 404);
        }
    }
    
    public function createConnectAccount($firstName,$lastName,$phoneNumber,$email,$dob,$accountHolderName,$accountNumber,$routingNumber,$identityNumber,$address,$aliasName){
        
	 $stripe = new \Stripe\StripeClient(config('app.stripe.secret_key'));
	 
		try{
			$TokenInfo = $stripe->tokens->create(array(
				"bank_account" => array(
					"country" => config('app.stripe.country'),
					"currency" => config('app.stripe.currency'),
					"account_holder_name" => $accountHolderName,
					"account_holder_type" => "individual",
					"routing_number" => $routingNumber,
					"account_number" => $accountNumber
				)
			));
		 $TokenId=$TokenInfo->id;
			
			if($TokenId){
				$array =  $this->arrayOfConnectAccount($firstName,$lastName,$phoneNumber,$email,$dob,$identityNumber,$aliasName,$address);
				
				$Account=$stripe->accounts->create($array);
			   
				$accountId=$Account->id;
				
				if($accountId){
					$external_account = $stripe->accounts->createExternalAccount($accountId,['external_account' => $TokenId]);
				//   $accountDetail  = $this->createFileVerificationId($accountId,$filename);
				}
			}
			$response = array("success"=>1,"accountID"=>$accountId);
		}
		catch (\Exception $e) {
            $messages=$e->getError()->message;
            $response = array("success"=>0,"message"=>$messages);
        }
        return $response;
    }
    
    public function arrayOfConnectAccount($firstName,$lastName,$phoneNumber,$email,$dob,$identityNumber,$aliasName= null,$address){
        $dobD = explode("-",$dob);
     
        $array =  [
            'type' => config('app.stripe.connect_account_type'),
            'country' => config('app.stripe.country'),
            'email' => $email,
            'business_type' => 'individual',
            'capabilities' => [
                'card_payments' => ['requested' => true],
                'transfers' => ['requested' => true],
            ],
            "business_profile" => [
                "url"=> env('BUSINESS_URL'),
                "mcc"=> env('MCC')
            ],
            "individual" => [
                "first_name"  => $firstName,
                "last_name" => $lastName,
                "email" => $email,
                "phone" => $phoneNumber,
                "id_number" => $identityNumber??"S0290695C",
                "full_name_aliases" => [null],
                // "ssn_last_4" => '695C',
                "address" => [
                    "city" => $address['city'] ?? "Singapore",          
                    "country" => "SG",      
                    "state" =>  $address['country']?? "Singapore",
                    "line1" => $address['address'] ?? "10 Anson Road",      
                    // "line2" => "International Plaza", 
                    "postal_code" => $address['postal_code'] ?? "079903"       
                ],
                'dob' => [
                    'day' => $dobD[2],
                    'month' => $dobD[1],
                    'year' => $dobD[0],
                ],
            ],
            "tos_acceptance" =>[
                "date"=> time(),
                "ip"=> $_SERVER['REMOTE_ADDR'],
                "user_agent"=> null
            ],
        ];
        return $array;
    }
    
    
//     public function createFileVerificationId1($accountId,$filename){
	    
// 	  $stripe = new \Stripe\StripeClient(config('app.stripe.secret_key'));
//         $file = $stripe->files->create([
//             'purpose' => 'identity_document',
//             'file' => fopen(storage_path('app/public/documents/'.$filename), 'r'),
//             ], [
//             'stripe_account' => $accountId,
//         ]);
        
//           $fileID = $file->id;
          
//         if($fileID){
//             $account = $stripe->accounts->update($accountId,[
// 				"individual" => [
// 					"verification"=> [
// 					"document"=> [
// 					"back"=> null,
// 					//"details"=> null,
// 					//"details_code"=> null,
// 					"front"=> $fileID
// 				],
// 				],
//             ]
// 			]);
//             return $account;
//         }
//     }

    public function createFileVerificationId($accountId, $filename, $fileSide)
    {
        $stripe = new \Stripe\StripeClient(config('app.stripe.secret_key'));
    
        // Upload the file to Stripe
        $file = $stripe->files->create([
            'purpose' => 'identity_document',
            'file' => fopen(storage_path('app/public/documents/' . $filename), 'r'),
        ], [
            'stripe_account' => $accountId,
        ]);
    
        $fileID = $file->id;
    
        if ($fileID) {
            // Prepare the verification document structure
            $verificationData = [
                'individual' => [
                    'verification' => [
                        'document' => [
                            'front' => null,
                            'back' => null,
                        ],
                    ],
                ],
            ];
    
            // Set the correct file ID based on $fileSide
            if ($fileSide === 'front') {
                $verificationData['individual']['verification']['document']['front'] = $fileID;
            } elseif ($fileSide === 'back') {
                $verificationData['individual']['verification']['document']['back'] = $fileID;
            }
    
            // Update the Stripe account with the verification document
            $account = $stripe->accounts->update($accountId, $verificationData);
    
            return $account;
        }
    
        return null;
    }


    
    public function createCustomer($email=null, $name=null, $customer_id=null)
	{
        try
        {
            $stripe = new \Stripe\StripeClient(config('app.stripe.secret_key'));
            
          
            if(!empty($customer_id)) {
                $customer_id = $customer_id;
            } else {
                 
                if(!empty($email) && !empty($name)) {
                    $customer = $stripe->customers->create([
                        'email' => $email, 
                        'name' => $name,
                    ]);
                    $customer_id = $customer->id;
                } else {
                    $customer = $stripe->customers->create();
                    $customer_id = $customer->id;
                }
            }
     
            $PaymentMethod=$stripe->paymentMethods->all([
              'customer' => $customer_id,
              'type' => 'card',
            ]);
            $pid = (!empty($PaymentMethod->data))?$PaymentMethod->data[0]->id:0;
  
           
            
            $data=$stripe->checkout->sessions->create([
                'payment_method_types' => ['card'],
                'mode' => 'setup',
                'customer' => $customer_id,
                'success_url' => URL::to('/').'/success?session_id={CHECKOUT_SESSION_ID}',
                'cancel_url' => URL::to('/').'/cancel',
            ]);
            
            $response = ["success"=>1, "SessionUrl"=>$data->url, 'customer_id'=>$customer_id,];
        }catch (\Exception $ex){
            $response = ["success"=>0, "message"=>[$ex->getMessage()]];
        }
        return $response;
    }
    
    
   public function getCardLists($customer_id)
	{
        try
        {
            $stripe = new \Stripe\StripeClient(config('app.stripe.secret_key'));
            if(!empty($customer_id)) {
                $PaymentMethod=$stripe->paymentMethods->all([
                  'customer' => $customer_id,
                  'type' => 'card',
                ]);
            } 
            $response = ["success"=>1, 'cardData'=>$PaymentMethod,];
        }catch (\Exception $ex){
            $response = ["success"=>0, "message"=>[$ex->getMessage()]];
        }
        return $response;
    }
    
    public function createPaymentIntent($amount,$stripCustomerId, $cardId,$paymentType, $chargeDetail){
       try
        {
        $stripe = new \Stripe\StripeClient(config('app.stripe.secret_key'));
        
        if($paymentType == 'booking_fee'){
            
           $paymentIntent =  $stripe->paymentIntents->create([
              'amount' => $amount*100,
              'currency' => 'SGD',
              'automatic_payment_methods' => ['enabled' => true],
               //'confirm'=> true,
              'customer' => $stripCustomerId,
              'payment_method' => $cardId,
              'metadata' => [
                  'first_name' => $chargeDetail['first_name'],
                  'last_name' => $chargeDetail['last_name'],
                  'email'   => $chargeDetail['email'], 
                  'phone' => $chargeDetail['phone'],
                  'bookingID' => $chargeDetail['bookingID'],
                  'description' => $chargeDetail['description']
                  ]
            ]);
            
        }else{
             $paymentIntent =  $stripe->paymentIntents->create([
              'amount' => $amount*100,
              'currency' => 'SGD',
              'automatic_payment_methods' => ['enabled' => true,'allow_redirects'=> 'never'],
              'confirm'=> true,
              'customer' => $stripCustomerId,
              'payment_method' => $cardId,
              'metadata' => [
                  'first_name' => $chargeDetail['first_name'],
                  'last_name' => $chargeDetail['last_name'],
                  'email'   => $chargeDetail['email'], 
                  'phone' => $chargeDetail['phone'],
                  'bookingID' => $chargeDetail['bookingID'],
                  'description' => $chargeDetail['description']
                  ]
            ]);
        }
        
         $response = ["success"=>1, 'paymentIntent'=>$paymentIntent];
        }catch (\Exception $ex){
                $response = ["success"=>0, "message"=>[$ex->getMessage()]];
            }
            return $response;
        }
        
          
    public function updatePaymentIntent($payload)
    {   
        try {
            $stripe = new \Stripe\StripeClient(config('app.stripe.secret_key'));
            
            $amount =  $payload['updated_amount']*100;
            $updatedPayment =  $stripe->paymentIntents->update($payload['paymentIntentId'], [
                'amount' => $amount,
                'metadata' => ['description' => $payload['update_amount_reason']]
                ]);
          
            $response = ["success"=>1, "updatedPayment"=>$updatedPayment];
        } catch(\Exception $e) {
            $response = ["success"=>0, "message"=>$e->getMessage()];
        }
        return $response;
    }
    
    public function Confirmcharge($payload)
    {   
        try {
            $stripe = new \Stripe\StripeClient(config('app.stripe.secret_key'));
            
    
            $payment = $stripe->paymentIntents->confirm($payload['paymentIntentId'],[
                'payment_method' => $payload['card_id'],
                'return_url' => 'https://www.example.com',
            ]);
            
          
            $response = ["success"=>1, "chargeConfirmID"=>$payment->id];
        } catch(\Exception $e) {
            $response = ["success"=>0, "message"=>$e->getMessage()];
        }
        return $response;
    }
    
    
    public function CancelPaymentIntent($paymentIntentId)
    {   
        try {
            $stripe = new \Stripe\StripeClient(config('app.stripe.secret_key'));
            
            $cancelPayment =  $stripe->paymentIntents->cancel($paymentIntentId, []);
          
            
          
            $response = ["success"=>1, "chargeConfirmID"=>$payment->id];
        } catch(\Exception $e) {
            $response = ["success"=>0, "message"=>$e->getMessage()];
        }
        return $response;
    }
    
    
    public function fundTransfer($payload)
    {   
        try {
            $stripe = new \Stripe\StripeClient(config('app.stripe.secret_key'));
            
            $fundTransfer =  $stripe->transfers->create([
                                  'amount' => $payload['amount'],
                                  'currency' => config('app.stripe.currency'),
                                  'destination' => $payload['connect_account'],
                                //   'transfer_group' => 'ORDER_95',
                                ]);
                                
            $response = ["success"=>1, "fundTransfer"=> $fundTransfer];
        } catch(\Exception $e) {
            $response = ["success"=>0, "message"=>$e->getMessage()];
        }
        return $response;
    }
    
    public function createStripePayout($connectId, $amount)
    {   
        try {
            $stripe = new \Stripe\StripeClient(config('app.stripe.secret_key'));
    
            $payout = $stripe->payouts->create([
                'amount' => $amount, // Amount in cents
                'currency' =>  config('app.stripe.currency'),
            ], [
                'stripe_account' => $connectId, // Customer’s Stripe Account ID
            ]);
    
            $response = ["success" => 1, "payout" => $payout];
    
        } catch (\Exception $e) {
            $response = ["success" => 0, "message" => $e->getMessage()];
        }
    
        return $response;
    }

    

    public function createPaymentMethod($payload)
    {   
        try {
            $stripe = new \Stripe\StripeClient(config('app.stripe.secret_key'));
            
            // $paymentDetail = $stripe->paymentIntents->retrieve($token, []);
          $paymentMethod =   $stripe->paymentMethods->create([
                      'type' => 'card',
                      'card' => [
                        'token' => $payload['token'],
                      ],
                      'billing_details' => ['name' => $payload['name'],'phone' => $payload['phone'], 'email' => $payload['email']],
                      'metadata' => ['bookingID' => $payload['booking_id'], 'phone' => $payload['phone']],
                    ]);
                                
            $response = ["success"=>1, "paymentMethodId" => $paymentMethod->id];
            
        } catch(\Exception $e) {
            $response = ["success"=>0, "message"=>$e->getMessage()];
        }
        return $response;
    }
    
     public function retrivePayment($token)
    {   
        try {
            $stripe = new \Stripe\StripeClient(config('app.stripe.secret_key'));
            
            $paymentDetail = $stripe->paymentIntents->retrieve($token, []);
                                
            $response = ["success"=>1, "paymentDetail"=> $paymentDetail];
            
        } catch(\Exception $e) {
            $response = ["success"=>0, "message"=>$e->getMessage()];
        }
        return $response;
    }
    
    



    
    public function createSession($priceId)
    {
        $stripe = new \Stripe\StripeClient(config('app.stripe.secret_key'));

        $stripe->checkout->sessions->create([
          'success_url' => 'https://php.parastechnologies.in/valo/make_payment_success',
          'line_items' => [
            [
              'price' => $priceId,
              'quantity' => 1,
            ],
          ],
          'mode' => 'setup',
        ]);
    }
    
    public function createPrice($amount,$bookingID)
    {
        $stripe = new \Stripe\StripeClient(config('app.stripe.secret_key'));

        $price = $stripe->prices->create([
            'unit_amount' => $amount*100, // Amount in cents (e.g., $20.00)
            'currency' => 'sgd',
            'product' => $bookingID, // Product ID
        ]);
        
        return $price->id; // Outputs the Price ID

    }
    
    public function createProduct($bookingID)
    {
        $stripe = new \Stripe\StripeClient(config('app.stripe.secret_key'));

        $product = $stripe->products->create([
            'name' => 'Booking #' . $bookingID,
            'description' => 'Payment for booking ID ' . $bookingID,
        ]);
        
        return $product->id; 

    }

    
    public function sendEmail($email,$data)
    {
        return Mail::to($email)->send(new replyEmail($data));
    }
    
    public function userTimeZone(){
        $ip = $_SERVER['REMOTE_ADDR'];
        $ipdat = @json_decode(file_get_contents("http://www.geoplugin.net/json.gp?ip=" . $ip)); 
        return $ipdat->geoplugin_timezone;
    }
    
    public function createChatToken()
    {
        $randomString = Str::random(10);
        return $randomString;
    }
    
    public static function uploadFile($file, $folder = 'uploads', $disk = 'public')
    {
        try {
            // Generate a unique file name
            $fileName = uniqid() . '_' . time() . '.' . $file->getClientOriginalExtension();

            // Store the file and return its path
            return $file->storeAs($folder, $fileName, $disk);
        } catch (\Exception $e) {
            // Log the error for debugging
            \Log::error('File upload failed: ' . $e->getMessage());
            return null;
        }
    }
    
    public function sendNotification($type, $data)
    {
        try {
        
        $title =$data['title'] ? $data['title']: "Valo";
        $msg = $data['message'];
        
        // Prepare notification data for the database
        // if ($type == "order") {
        // $notifyData = [
        // 'message' => $msg,
        // 'receiver_id' => $data['receiver_id'],
        // 'type' => $data['type']
        // ];
        // }
        $admin = User::where('user_type',0)->first();
        // Get user data
        $userData = User::find($data['receiverID']);
        if (!$userData) {
        throw new \Exception("User not found.");
        }
        // Save notification in the database
        $result = Notification::create($notifyData);
        
        // Prepare FCM notification payload
        $payload = [
        'title' => $title,
        'message' => $msg,
        'sender_id' => (string) $admin->id,
        'receiver_id' => (string) $data['receiver_id'],
        'type' => (string) $data['type'],
        ];
        
        $deviceType = $userData->deviceType ?? "web";
        $deviceToken = $userData->deviceToken;
        
        if (empty($deviceToken)) {
        throw new \Exception("Device token is missing for the user.");
        }
        // Build the FCM message payload
        if ($deviceType === "web") {
            $message = [
            'token' => $deviceToken,
            'notification' => [
                                'title' => $title,
                                'body' => $msg
                              ],
            'data' => $payload,
            ];
        } else if($deviceType === "ios"){
             $message = [
                    'token' => $deviceToken,
                    'notification' => [
                        'title' => $title,
                        'body' => $msg,
                    ],
                    'data' => $payload,
                    // 'apns' => [ // Specific configuration for iOS (optional)
                    //     'headers' => [
                    //         'apns-priority' => '10',
                    //     ],
                    //     'payload' => [
                    //         'aps' => [
                    //             'alert' => [
                    //                 'title' => $title,
                    //                 'body' => $msg,
                    //             ],
                    //             'sound' => 'default',
                    //         ],
                    //     ],
                    // ],
                ];
        }else {
            $message = [
            'token' => $deviceToken,
            'notification' => [
                                'title' => $title,
                                'body' => $msg
                              ],
            'data' => $payload,
            ];
        }
        // Generate Firebase JWT
        // $serviceAccountPath = public_path('assets/files/valo-app-firebase.json');
        $serviceAccountPath = storage_path('app/fcm/valo-app-firebase.json');
        $serviceAccount = json_decode(file_get_contents($serviceAccountPath), true);
        $clientEmail = $serviceAccount['client_email'];
        $privateKey = $serviceAccount['private_key'];
        $projectId = $serviceAccount['project_id'];
        $token = [
        'iss' => $clientEmail,
        'sub' => $clientEmail,
        'aud' => 'https://fcm.googleapis.com/',
        'iat' => time(),
        'exp' => time() + 3600,
        ];
        $jwt = \Firebase\JWT\JWT::encode($token, $privateKey, 'RS256');
        // FCM endpoint
        $url = "https://fcm.googleapis.com/v1/projects/{$projectId}/messages:send";
        // HTTP Request
        $response = \Illuminate\Support\Facades\Http::withHeaders([
            'Authorization' => 'Bearer ' . $jwt,
            'Content-Type' => 'application/json',
            ])->post($url, [
            'message' => $message
        ]);
        if ($response->successful()) {
            return [
                'status' => 'success',
                'message' => 'Notification sent successfully.',
                'response' => $response->json()
                ];
        }
        throw new \Exception("Failed to send notification: " . $response->body());
        } catch (\Exception $e) {
            return [
            'status' => 'error',
            'message' => $e->getMessage()
            ];
        }
    }
    
    
    
   public function checkStripeRequirement($connectId)
    {   
        try {
            $stripe = new \Stripe\StripeClient(config('app.stripe.secret_key'));
            
            // Retrieve the Stripe Connect account
            $account = $stripe->accounts->retrieve($connectId);
           
            $requirements = $account->requirements ?? [];
    
            $response = ["success" => 1, "requirements" => $requirements];
    
        } catch (\Exception $e) {
            $response = ["success" => 0, "message" => $e->getMessage()];
        }
    
        return $response;
    }

    
    
   public function createStripeAccountLink($connectId)
    {   
        try {
            $stripe = new \Stripe\StripeClient(config('app.stripe.secret_key'));
    
            $accountLink = $stripe->accountLinks->create([
                'account' => $connectId,
                'refresh_url' => 'https://php.parastechnologies.in/valo/',
                'return_url' => 'https://php.parastechnologies.in/valo/api/stripe_verification/success',
                'type' => 'account_onboarding',
            ]);
    
            $response = ["success" => 1, "verification_url" => $accountLink->url];
    
        } catch (\Exception $e) {
            $response = ["success" => 0, "message" => $e->getMessage()];
        }
    
        return $response;
    }


}