<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Storage;
use App\Models\User;

class DeleteExpiredSelfiesJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     */
    /**
     * Execute the job.
     */
    public function handle(): void
    {
        
         // Fetch users where the selfie is older than 24 hours
        $drivers = User::where('user_type',2)->whereNotNull('selfie_path')
        ->where('selfie_verified_at', '>', now()->subDay())->get();
        

        foreach ($drivers as $driver) {
            // Delete the selfie file from storage
            $this->deleteFile($driver->selfie_path);
            // Storage::delete($driver->selfie_path);

            // Set selfie path to null and save user
            $driver->selfie_path = null;
            $driver->selfie_verified_at = null;
            $driver->save();
        }
    }
}
