<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\DropOfPoint;
use App\Models\Transaction;
use App\Models\User;
use App\Models\BookingCharge;
use App\Models\Card;

class Booking extends Model
{
    
    use HasFactory;
    
    
    const STATUS_PENDING            = 0;
    const STATUS_ACCEPTED           = 1;
    const STATUS_DELAYED            = 2;
    const STATUS_COMPLETED          = 3;
    const STATUS_CANCELED           = 4;
    const STATUS_REFUNDED           = 5;
    
    
    const RIDER_STATUS_PENDING         = 0;
    const RIDER_STATUS_REACHED         = 1;
    
    const DRIVER_STATUS_PENDING          = 0;
    const DRIVER_STATUS_ACCEPTED         = 1;
    const DRIVER_STATUS_REACHED          = 2;
    const DRIVER_STATUS_START_TRIP       = 3;
    const DRIVER_STATUS_END_TRIP         = 4;
    
    
    const PAYMENT_PENDING            = 0;
    const PAYMENT_ON_HOLD            = 1;
    const PAYMENT_PAID               = 2;
    
    protected $fillable = [
        'booking_id',
        'rider_id',
        'driver_id',
        'pickup_date',
        'pickup_time',
        'dropof_time',
        'driver_reached',
        'rider_reached',
        'trip_start',
        'trip_ends',
        'pickup_location',
        'pickup_lat',
        'pickup_long',
        'car_plate_no',
        'notes',
        'status',
        'distance',
        'canceled_by',
        'canceled_at',
        'is_delayed',
        'rider_delay_count',
        'rider_delay_time',
        'rider_delay_fee',
        'driver_delay_count',
        'driver_delay_time',
        'driver_delay_fee',
        'base_fare',
        'additional_stop_count',
        'additional_stop_fee',
        'driver_cancelation_fee',
        'rider_cancelation_fee',
        'delay_fee',
        'platform_fee',
        'total_fare',
        'driver_fee',
        'driver_late_count',
        'driver_late_time',
        'driver_late_fee',
        'rider_late_count',
        'rider_late_time',
        'rider_late_fee',
        'driver_status',
        'rider_status',
        'is_paid',
    ];
    
    public function drop_points()
    {
        return $this->hasMany(DropOfPoint::class);
    }
    
    public function driver()
    {
        return $this->belongsTo(User::class, 'driver_id', 'id');
    }
    
    public function rider()
    {
        return $this->belongsTo(User::class, 'rider_id', 'id');
    }
    
    public function transactions()
    {
        return $this->hasMany(Transaction::class);
    }
        
     // Access Cards via Transactions
    public function cards()
    {
        return $this->hasManyThrough(Card::class, Transaction::class, 'booking_id', 'id', 'id', 'card_id');
    }
    
    public function charges()
    {
        return $this->hasMany(BookingCharge::class);
    }
    

}
