<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    use HasFactory;
    
     const STATUS_PENDING   = 0;
     const STATUS_FAILED    = 1;
     const STATUS_ON_HOLD   = 2;
     const STATUS_SUCCEEDED = 3;
     
     protected $guarded = [];
     
      // Relation with Booking
    public function booking()
    {
        return $this->belongsTo(Booking::class);
    }
    
     public function rider()
    {
        return $this->hasOneThrough(
            User::class,  // Final model
            Booking::class, // Intermediate model
            'id',           // Foreign key on Booking table (Booking.id)
            'id',           // Foreign key on Rider table (Rider.id)
            'booking_id',   // Local key on Transaction table
            'rider_id'      // Local key on Booking table
        );
    }

    public function driver()
    {
        return $this->hasOneThrough(
            User::class,  // Final model
            Booking::class, // Intermediate model
            'id',           // Foreign key on Booking table (Booking.id)
            'id',           // Foreign key on Driver table (Driver.id)
            'booking_id',   // Local key on Transaction table
            'driver_id'     // Local key on Booking table
        );
    }

    // Relation with Card
    public function card()
    {
        return $this->belongsTo(Card::class, 'card_id');
    }
}
