<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use PHPOpenSourceSaver\JWTAuth\Contracts\JWTSubject;
use App\Models\Booking;
use App\Models\ConnectAccount;

class User extends Authenticatable implements JWTSubject, MustVerifyEmail
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
     
     const STATUS_ACTIVE = 1;
     const STATUS_DEACTIVE = 0;
     
     const TYPE_RIDER = 1;
     const TYPE_DRIVER = 2;
     
    protected $fillable = [
        'first_name',
        'last_name',
        'email',
        'phone',
        'otp',
        'country_code',
        'address',
        'country',
        'unit_number',
        'postal_code',
        'address_lat',
        'address_long',
        'status',
        'device_type',
        'device_token',
        'user_type',
        'profile_pic',
        'latitude',
        'longitude',
        'selfie_path',
        'selfie_verified_at',
        'user_last_active',
        'step',
        'chat_token',
        'is_online',
        'dob',
        'uinfin',
        'callback_code',
        'timezone'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];
    
    public function setDeviceTypeAttribute($value)
    {
        $this->attributes['device_type'] = strtolower($value);
    }
    
      public function getJWTIdentifier()
    {
      return $this->getKey();
    }

    public function getJWTCustomClaims()
    {
      return [
        'email'=>$this->email,
        'name'=>$this->name
      ];
    }
    
    public function bookings()
    {
        return $this->hasMany(Booking::class,'driver_id');
    }
    
    public function connect_account()
    {
        return $this->hasOne(ConnectAccount::class);
    }
}
