<?php

namespace App\Traits;
use App\Models\BookingFee;
use App\Models\BookingCharge;
use App\Models\User;
use Exception;

trait BookingFare{
    
    public function fareCalculation($data)
    {
       
        try{
            //initiate total amount
            $totalFee = 0.0;
            $additionalStopFeeCut = 0.0;
            
            $additionalStopFee = 0.0;
            
            //get dynamic fare values on sorted by their names 
            $fare = $this->fares();
            
            $bookingFeeCut = $fare['booking_fee_cut'];
            
            
            $bookingFee = $fare['booking_fee'];
            
            $totalFee += $bookingFee;
            
            //count additional stops 
            $stops = count($data['drop_points'])-1;
            if($stops > 0){
                $additionalStopFee = $fare['additional_stop_fee'];
                
                 $totalFee += $stops * $additionalStopFee;
                 
                 
                 $additionalStopFeeCut +=  $stops * $fare['additional_stop_fee_cut'];
            
            }
          
            $platformFee = $bookingFeeCut + $additionalStopFeeCut;
            $driverFee = $totalFee - $platformFee;
            //  $total_fee = $base_fare + $platform_fee  + $additional_stop_fee;
            
            
            return [$bookingFee, $platformFee , $driverFee, $totalFee, $stops,$additionalStopFee ];  
            
        }catch(Exception $e){
            // dd($e->getMessage());
             return $this->jsonResponse(false, 500, 'An error occurred.', null, 500, ["message" => $e->getMessage()]);
        }
    }
    
    public function riderCancelFare($bookingDetail){
        dd($bookingDetail);
    }
    
    
    public function riderDelayFare($bookingDetails, $delayCountIncrement) {
        // Get the current total fare, platform fee, and driver fee
        $totalFee = $bookingDetails->total_fare;
        // $platformFee = $bookingDetails->platform_fee;
        $driverFee = $bookingDetails->driver_delay_fee;
    
        // Get dynamic fare values (assumed to be fetched from your fare settings)
        $fare = $this->fares();
        $riderDelayFee = $fare['rider_delay_fee']; 
        $riderDelayFeeCut = $fare['rider_delay_fee_cut_for_admin']; 
        $delayFeeToDriver = $fare['delay_fee_to_driver']; 
    
        // Calculate the delay fare only for the current delay increment
        $currentDelayFare = $delayCountIncrement * $riderDelayFee;
    
        // Calculate the platform's cut and the driver's share
        $currentPlatformFee = $delayCountIncrement * $riderDelayFeeCut;
        $currentDriverFee = $delayCountIncrement * $delayFeeToDriver;
    
        // Update the total fare, platform fee, and driver fee
        $bookingDetails->rider_delay_fee += $currentDelayFare;
        // $bookingDetails->total_fare = $totalFee + $currentDelayFare;
        // $bookingDetails->platform_fee = $platformFee + $currentPlatformFee;
        // $bookingDetails->driver_fee = $driverFee + $currentDriverFee;
        
           //Booking charges for rider on schedule ride
             $chargesDetails = [
                     'booking_id' => $bookingDetails->id,
                     'user_id' =>    auth()->user()->id,
                     'user_type' =>  User::TYPE_RIDER,
                     'amount' =>     $currentDelayFare,
                     'charge_type' => 'debit',
                     'reason'       => 'delay fee',
                     'created_at'   => now(),
                     'updated_at'   => now(),
                 ]; 
             
             BookingCharge::create($chargesDetails);
    
        // Save the updated booking details
        $bookingDetails->save();
    }
    
    
    
    public function driverDelayFare()
    {
        dd("dd");
    }
    
    public function driverCancelFare($bookingDetail)
    {
        dd($bookingDetail);
    }
    
    // get the dynamic fare values to use for calculation
    public function fares()
    {
        // Fetch all fees from the database and organize them by fee_name
        $bookingFees = BookingFee::all()->keyBy('fee_name');
        
        // Initialize an empty array to store the results
        $fares = [];
    
        // Loop through each fee entry and assign to the fares array with fee_name as key
        foreach ($bookingFees as $feeName => $fee) {
            $fares[$feeName] = $fee->fee_price;
        }
        
        return $fares;
    }
}