<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('stripe_customer_id')->nullable();
            $table->string('uinfin')->nullable();
            $table->text('callback_code')->nullable();
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('country_code')->nullable();
            $table->string('phone')->nullable();
            $table->date('dob')->nullable();
            $table->string('password')->nullable();
            $table->integer('otp')->nullable();
            $table->timestamp('otp_verified')->nullable();
            $table->integer('is_otp_verified')->default(0);
            $table->text('address')->nullable();
            $table->string('unit_number')->nullable();
            $table->string('country')->nullable();
            $table->string('postal_code')->nullable();
            $table->string('address_lat')->nullable();
            $table->string('address_long')->nullable();
            $table->string('profile_pic')->nullable();
            $table->string('device_type')->nullable();
            $table->string('device_token')->nullable();
            $table->timestamp('selfie_verified_at')->nullable();
            $table->string('selfie_path')->nullable();
            $table->string('latitude')->nullable();
            $table->string('longitude')->nullable();
            $table->timestamp('user_last_active')->nullable();
            $table->string('chat_token')->nullable();
            $table->tinyInteger('is_online')->default(0)->comment("0= inactive , 1 = active");
            $table->tinyInteger('notificationStatus')->default(0)->comment("0 = off , 1 = on");
            $table->tinyInteger('status')->default(0)->comment("0 = deactive, 1 = active");
            $table->integer('step')->nullable();
            $table->integer('driving_licence_status')->nullable();
            $table->string('timezone')->nullable();
            $table->tinyInteger('user_type')->comment('0 = admin,1 = rider, 2 = driver')->nullable();
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
