<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bookings', function (Blueprint $table) {
            $table->id();
            $table->string('booking_id', 8)->nullable()->unique();
            $table->string('payment_id')->nullable();
            $table->foreignId('rider_id')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignId('driver_id')->nullable()->constrained('users')->onDelete('set null');
            
            $table->date('pickup_date');
            $table->time('pickup_time');
            $table->time('delay_time')->nullable();
            $table->timestamp('dropof_time')->nullable();
            $table->time('driver_reached')->nullable();
            $table->time('rider_reached')->nullable();
            $table->time('trip_start')->nullable();
            $table->time('trip_ends')->nullable();
            
            $table->string('pickup_location');
            $table->string('pickup_lat')->nullable();
            $table->string('pickup_long')->nullable();
            
            $table->string('car_plate_no')->nullable();
            $table->text('notes')->nullable();
            
            $table->double('distance',8,2)->default(0.0);
            
            $table->integer('canceled_by')->nullable()->comment("1 = ride , 2 = driver"); 
            $table->timestamp('canceled_at')->nullable();
            
            $table->integer('is_delayed')->default(0);
            
            $table->integer('rider_delay_count')->default(0);
            $table->integer('rider_delay_time')->default(0); 
            $table->double('rider_delay_fee')->default(0.0);
            
            $table->integer('driver_delay_count')->default(0);
            $table->integer('driver_delay_time')->default(0); 
            $table->double('driver_delay_fee')->default(0.0);
            
            $table->integer('driver_late_count')->default(0);
            $table->integer('driver_late_time')->default(0); 
            $table->double('driver_late_fee')->default(0.0);
            
            $table->integer('rider_late_count')->default(0);
            $table->integer('rider_late_time')->default(0); 
            $table->double('rider_late_fee')->default(0.0);
            
            $table->double('base_fare')->default(0.0);
            $table->integer('additional_stop_count')->default(0);
            $table->double('additional_stop_fee')->default(0.0);
            $table->double('driver_cancelation_fee')->default(0.0);
            $table->double('rider_cancelation_fee')->default(0.0);
            $table->double('delay_fee')->default(0.0);
            $table->double('platform_fee')->default(0.0);
            $table->double('driver_fee')->default(0.0);
        
            $table->double('total_fare')->default(0.0);
            
            $table->tinyInteger('unaccepted_notify')->default(0);
            $table->tinyInteger('is_paid')->default(0);
            $table->integer('driver_status')->nullable()->default(0)
            ->comment("0 = pending, 1 = accepted, 2 = reached, 3 = start_trip, 4 = end_trip");
            $table->integer('rider_status')->nullable()->default(0)
            ->comment("	0 = pending , 1 = reached");
            $table->integer('status')->nullable()->default(0)
            ->comment("	0 = pending , 1 = accepted, 2 = delayed , 3 = completed, 4 = canceled , 5 = refunded");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bookings');
    }
};
