<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('drop_of_points', function (Blueprint $table) {
            $table->id();
            
            $table->foreignId('booking_id')->constrained()->onDelete('cascade'); 
            
            $table->string('drop_location');
            $table->string('drop_lat')->nullable();
            $table->string('drop_long')->nullable();
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('drop_of_points');
    }
};
