<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('booking_settings', function (Blueprint $table) {
           $table->id();
            $table->string('rider_delay_time')->nullabe();
            $table->string('driver_delay_time')->nullabe();
            $table->string('driver_late_grace')->nullable();
            $table->string('driver_late_grace')->nullable();
            $table->string('driver_late_period')->nullable();
            $table->string('driver_late_period')->nullable();
            $table->integer('driver_max_bookings')->nullable();
            $table->string('driver_per_ride_period')->nullable();
            $table->integer('driver_cancelation_period')->nullable();
            $table->integer('rider_cancelation_period')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('booking_settings');
    }
};
