<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cards', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->string('stripe_payment_method_id')->unique();
            $table->string('card_brand')->nullable();
            $table->string('card_holder_name')->nullable();
            $table->string('last4')->nullable(); 
            $table->string('expiry_month')->nullable(); 
            $table->string('expiry_year')->nullable(); 
            $table->boolean('is_default')->default(false); 
            $table->tinyInteger('status')->default(0)->comment("0 = deactive, 1 = activate");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cards');
    }
};
