<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_chat', function (Blueprint $table) {
            $table->id();
            $table->foreignId('bookingID')->nullable()->constrained('bookings')->onDelete('set null');
            $table->string('roomID')->constrained('rooms')->onDelete('set null');
            $table->bigInteger('source_user_id');
            $table->bigInteger('target_user_id');
            $table->mediumText('message');
            $table->tinyInteger('isAdmin')->default(0);
            $table->tinyInteger('status')->default(0)->comment('0 => Unread, 1 => Read');
            $table->string('MessageType', 22);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_chats');
    }
};
