<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\BookingFee;

class BookingFeeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        BookingFee::truncate();
        
        BookingFee::insert([
             [
                'fee_name' => 'booking_fee',
                'fee_price' => 45,
                'status'    => 1,
                'description' => 'Base Booking Fee That Will be Charged to Rider.',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'fee_name' => 'cancelation_fee',
                'fee_price' => 35,
                'description' => 'Cancelation Fee For Rider If He Cancel The Ride.',
                'status'    => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'fee_name' => 'rider_delay_fee',
                'fee_price' => 15,
                'description' => 'Delay Fee for rider on every single delay. Delay will be for 30 min.',
                'status'    => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'fee_name' => 'additional_stop_fee',
                'fee_price' => 10,
                'description' => 'On adding extra stop rider will charged for additional stop fee.',
                'status'    => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
             [
                'fee_name' => 'rider_late_fee',
                'fee_price' => 15,
                'description' => 'Rider will pay the late fee for 30 min late after grace period if he not delayed the ride.',
                'status'    => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'fee_name' => 'booking_fee_cut',
                'fee_price' => 7,
                'description' => 'Platform fee on the booking fee.',
                'status'    => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'fee_name' => 'additional_stop_fee_cut',
                'fee_price' => 1,
                'description' => 'Platform fee for adding extra stop.',
                'status'    => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
             [
                'fee_name' => 'booking_cancelation_fee_cut',
                'fee_price' => 20,
                'description' => 'Platform fee for canceling ride from rider cancelation amount.',
                'status'    => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'fee_name' => 'driver_cancelation_fee',
                'fee_price' => 30,
                'description' => 'Cancelation fee will charged from driver.',
                'status'    => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'fee_name' => 'driver_cancelation_fee_cut',
                'fee_price' => 20,
                'description' => null,
                'status'    => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'fee_name' => 'rider_delay_fee_cut',
                'fee_price' => 5,
                'description' => 'Platfrom fee for every delay by rider.',
                'status'    => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'fee_name' => 'driver_late_fee',
                'fee_price' => 5,
                'description' => 'Late Fee will charged on 15 min late.',
                'status'    => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
             [
                'fee_name' => 'driver_late_fee_cut',
                'fee_price' => 0,
                'description' => null,
                'status'    => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
             [
                'fee_name' => 'rider_late_fee_cut',
                'fee_price' => 5,
                'description' => null,
                'status'    => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }
}
