<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
        <title>{{ config('app.name', 'Valo') }}</title>
        <link href="{{ asset('public/assets/css/bootstrap.min.css') }}" rel="stylesheet">
        <link rel="stylesheet" href="{{ asset('public/assets/css/style.css') }}">
        <link href="https://fonts.googleapis.com/css2?family=Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
    </head>
<body>
    <div class="login_wrapper">
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-6 col-md-6 d-flex align-items-center vh-100 justify-content-center right_form bg-white">
                  <div class="card-shadow w-75">
                    <div class="py-5 px-5 bg-transparent">
                        <div class="text-left pb-4 pt-4">
                            <h1 class="fw-700">Reset Password</h1>
                            <p class="colorGrayDark fs-16">Enter your new password and confirm it.</p>
                        </div>
                        <form action="{{ route('auth.submitresetPassword')}}" method="post">
                            @csrf
                            <input type="hidden" name="token" value="{{ $token }}">
                            <div class="mb-4 position-relative">
                                <label class="form-label fs-14">Password</label>
                                <input id="password" type="password" class="form-control customInput" name="password" placeholder="Enter Your Password">
                                  @if ($errors->has('password'))
                                <span class="error text-danger">
                                    <i>{{ $errors->first('password') }}</i>
                                </span>
                                @endif
                            </div>
                            <div class="mb-4 position-relative">
                                <label class="form-label fs-14">Confirm Password</label>
                                <input type="password" class="form-control customInput" name="password_confirm" placeholder="Enter Your Confirm Password">
                                 @if ($errors->has('password_confirm'))
                                <span class="error text-danger">
                                    <i>{{ $errors->first('password_confirm') }}</i>
                                </span>
                                @endif
                            </div>
                            <div class="submit-btn text-center mt-4 mb-2 pb-4">
                                <button type="submit" class="btn btnRed btn-50 px-5 fw-500 w-100 fs-18 mb-3 border-0">Reset Password</button>
                            </div>
                        </form>
                    </div>
                </div>
          </div>
          <div class="col-xl-6 col-md-6 d-flex align-items-center vh-100 justify-content-center right_side">
            <div class="logo-block">
                <img src="{{asset('public/assets/images/valo-logo.svg')}}" alt=""/>
            </div>
            <div>
                <img src="{{asset('public/assets/images/car-img.png')}}" alt="" width="900px"/>
            </div>
      </div>
            </div>
        </div>
    </div>
    <!-- Bootstrap core JS-->
    <script src="{{asset('public/assets/js/bootstrap.bundle.min.js')}}"></script>
    <!-- Core theme JS-->
    <script src="{{('public/assets/js/main.js')}}"></script>
   
</body>
</html>
