@extends('admin/layouts.app') 
@section('title', 'Booking Management') 
@section('content') 
@if(\Session::get('success'))
<div class="alert alert-success alert-dismissible fade show" role="alert" id="alertSuccess">
    <div class="alert-body">
        {{ \Session::get('success') }}
    </div>
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif
<!-- Page content-->
<div class="container-fluid">
    <div class="content-wrapper" id="dashboard">
        <div class="row">
            <div class="col-12">
                <div class="header">
                    <div class="d-block d-sm-flex align-items-center justify-content-between">
                        <p class="fs-18 mb-0 d-flex align-items-center bg-transparent titlebrown">
                            <span class="menu-icons">
                            <svg id="fi_2460737" enable-background="new 0 0 512 512"  width="23" height="23"  viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m456.832 32.133h-41.232v-17.133c0-8.284-6.716-15-15-15s-15 6.716-15 15v17.133h-66.4v-17.133c0-8.284-6.716-15-15-15s-15 6.716-15 15v17.133h-66.4v-17.133c0-8.284-6.716-15-15-15s-15 6.716-15 15v17.133h-66.4v-17.133c0-8.284-6.716-15-15-15s-15 6.716-15 15v17.133h-41.234c-30.418 0-55.166 24.747-55.166 55.167v369.533c0 30.419 24.748 55.167 55.166 55.167h401.666c30.419 0 55.168-24.748 55.168-55.167v-369.533c0-30.42-24.749-55.167-55.168-55.167zm-401.666 30h41.234v17.134c0 8.284 6.716 15 15 15s15-6.716 15-15v-17.134h66.398v17.134c0 8.284 6.716 15 15 15s15-6.716 15-15v-17.134h66.4v17.134c0 8.284 6.716 15 15 15s15-6.716 15-15v-17.134h66.4v17.134c0 8.284 6.716 15 15 15s15-6.716 15-15v-17.134h41.232c13.879 0 25.17 11.29 25.17 25.167v41.233h-452v-41.233c0-13.877 11.29-25.167 25.166-25.167zm401.666 419.867h-401.666c-13.876 0-25.166-11.29-25.166-25.167v-298.3h452v298.3c0 13.877-11.291 25.167-25.168 25.167z"></path><path d="m151.566 208.867h-64.267c-8.284 0-15 6.716-15 15v64.266c0 8.284 6.716 15 15 15h64.268c8.284 0 15-6.716 15-15v-64.266c-.001-8.284-6.716-15-15.001-15zm-15 64.266h-34.268v-34.266h34.268z"></path><path d="m424.699 208.867h-64.266c-8.284 0-15 6.716-15 15v64.266c0 8.284 6.716 15 15 15h64.266c8.284 0 15-6.716 15-15v-64.266c0-8.284-6.716-15-15-15zm-15 64.266h-34.266v-34.266h34.266z"></path><path d="m151.566 337.4h-64.267c-8.284 0-15 6.716-15 15v64.266c0 8.284 6.716 15 15 15h64.268c8.284 0 15-6.716 15-15v-64.266c-.001-8.284-6.716-15-15.001-15zm-15 64.266h-34.268v-34.266h34.268z"></path><path d="m424.699 337.4h-64.266c-8.284 0-15 6.716-15 15v64.266c0 8.284 6.716 15 15 15h64.266c8.284 0 15-6.716 15-15v-64.266c0-8.284-6.716-15-15-15zm-15 64.266h-34.266v-34.266h34.266z"></path><path d="m288.133 337.4h-64.268c-8.284 0-15 6.716-15 15v64.266c0 8.284 6.716 15 15 15h64.268c8.284 0 15-6.716 15-15v-64.266c0-8.284-6.716-15-15-15zm-15 64.266h-34.268v-34.266h34.268z"></path><path d="m279.475 222.673-34.834 34.836-12.116-12.116c-5.857-5.858-15.355-5.858-21.213 0s-5.858 15.355 0 21.213l22.723 22.723c2.813 2.813 6.628 4.394 10.606 4.394 3.979 0 7.794-1.581 10.607-4.394l45.441-45.443c5.857-5.858 5.857-15.355 0-21.213-5.859-5.858-15.356-5.858-21.214 0z"></path></g></svg>
                        </span>
                            <span class="mt-1 ms-2">Booking Management</span>
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <div class="row pt-4">
            <div class="col-lg-12 position-relative">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    <!--<li class="nav-item" role="presentation">-->
                    <!--    <button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab" aria-controls="home" aria-selected="true">Active </button>-->
                    <!--</li>-->
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="false">Completed</button>
                    </li>
                </ul>
                <div class="tab-content" id="myTabContent">
                    <!--<div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">-->
                    <!--    <div class="border-0">-->
                    <!--        <div class="card global-shadow p-4 w-100 table-responsive">-->
                    <!--            <table class="isplay w-100" id="upcomingReservation">-->
                    <!--                <thead>-->
                    <!--                    <tr>-->
                    <!--                        <th scope="col">Booking Id</th>-->
                    <!--                        <th scope="col">Date</th>-->
                    <!--                        <th scope="col">Time</th>-->
                    <!--                        <th scope="col">Pick Up</th>-->
                    <!--                        <th scope="col">Drop Off</th>-->
                    <!--                        <th scope="col">Action</th>-->
                    <!--                    </tr>-->
                    <!--                </thead>-->
                    <!--                <tbody>-->
                    <!--                    @foreach($activeBookings as $activeBooking)-->
                    <!--                    <tr>-->
                    <!--                        <td>{{ $activeBooking->booking_id }}</td>-->
                    <!--                        <td>{{ \Carbon\Carbon::parse($activeBooking->pickup_date)->format('jS F Y') }}</td>-->
                    <!--                        <td>{{ \Carbon\Carbon::parse($activeBooking->pickup_time)->format('H:i:s') }}</td>-->
                    <!--                        <td>-->
                    <!--                    @if(strlen(strip_tags($activeBooking->pickup_location)) > 30)-->
                    <!--                    {!! substr(strip_tags($activeBooking->pickup_location),0,30) !!}-->
                    <!--                    <span><a href="javascript:;" class="bookingReadMore" data-location="{{ $activeBooking->pickup_location }}">Read More...</a></span>-->
                    <!--                    @else-->
                    <!--                    {!! substr(strip_tags($activeBooking->pickup_location),0,30) !!}-->
                    <!--                    @endif-->
                    <!--                </td>-->
                    <!--                        <td>-->
                    <!--                            @if( $activeBooking->drop_points->isNotEmpty() ) @foreach( $activeBooking->drop_points as $dropPoints ) @if(strlen(strip_tags($dropPoints->drop_location)) > 30)-->
                    <!--                    {!! substr(strip_tags($dropPoints->drop_location),0,30) !!}-->
                    <!--                    <span><a href="javascript:;" class="bookingReadMore1" data-location="{{ $dropPoints->drop_location }}">Read More...</a></span>-->
                    <!--                    @else-->
                    <!--                    {!! substr(strip_tags($dropPoints->drop_location),0,30) !!}-->
                    <!--                    @endif @break; @endforeach @else no location available @endif-->
                    <!--                        </td>-->
                    <!--                        <td>-->
                    <!--                            <div class="d-flex align-items-center gap-2">-->
                                                    <!--<span class="badge btngreen py-2 fs-12 h36" data-bs-toggle="modal" data-bs-target="#delayRideModal" data-id="{{ $activeBooking->id }}">Delay Ride</span>-->
                    <!--                                <a role="button" class="btn btnRed" href="{{ url('/admin/booking/detail/'.$activeBooking->id) }}">View Details</a>-->
                    <!--                            </div>-->
                    <!--                        </td>-->
                    <!--                    </tr>-->
                    <!--                    @endforeach-->
                    <!--                </tbody>-->
                    <!--            </table>-->
                    <!--        </div>-->
                    <!--    </div>-->
                    <!--</div>-->
                    <div class="tab-pane fade show active" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                        <div class="border-0">
                            <div class="card global-shadow p-4 w-100 table-responsive">
                                <table class="isplay w-100" id="upcomingReservation2">
                                    <thead>
                                        <tr>
                                            <th scope="col">Booking Id</th>
                                            <th scope="col">Date</th>
                                            <th scope="col">Time</th>
                                            <th scope="col">Delay Minutes</th>
                                            <th scope="col">Pick Up</th>
                                            <th scope="col">Drop Off</th>
                                            <th scope="col">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($completedBookings as $completedBooking)
                                        <tr>
                                            <td>{{ $completedBooking->booking_id }}</td>
                                            <td>{{ \Carbon\Carbon::parse($completedBooking->pickup_date)->format('jS F Y') }}</td>
                                            <td>{{ \Carbon\Carbon::parse($completedBooking->pickup_time)->format('H:i:s') }}</td>
                                            <td>{{ $completedBooking->rider_delay_time ?  $completedBooking->rider_delay_time : 'Not Delayed' }}</td>
                                             <td>
                                        @if(strlen(strip_tags($completedBooking->pickup_location)) > 30)
                                        {!! substr(strip_tags($completedBooking->pickup_location),0,30) !!}
                                        <span><a href="javascript:;" class="bookingReadMore" data-location="{{ $completedBooking->pickup_location }}">Read More...</a></span>
                                        @else
                                        {!! substr(strip_tags($completedBooking->pickup_location),0,30) !!}
                                        @endif
                                    </td>
                                            <td>
                                                @if( $completedBooking->drop_points->isNotEmpty() ) @foreach( $completedBooking->drop_points as $dropPoints ) @if(strlen(strip_tags($dropPoints->drop_location)) > 30)
                                        {!! substr(strip_tags($dropPoints->drop_location),0,30) !!}
                                        <span><a href="javascript:;" class="bookingReadMore1" data-location="{{ $dropPoints->drop_location }}">Read More...</a></span>
                                        @else
                                        {!! substr(strip_tags($dropPoints->drop_location),0,30) !!}
                                        @endif @break; @endforeach @else no location available @endif
                                            </td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <!--<span class="badge btngreen py-2 fs-12 h36" data-bs-toggle="modal" data-bs-target="#delayRideModal" data-id="{{ $completedBooking->id }}">Delay Ride</span>-->
                                                        <a role="button" class="btn btnRed" href="{{ url('/admin/booking/detail/'.$completedBooking->id) }}">View Details</a>
                                                    </div>
                                                </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Pickup Readmore Modal -->
<div class="modal fade" id="bookingView" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">pick up</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body" id="location">
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<!-- Dropoff Readmore Modal -->
<div class="modal fade" id="bookingView1" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Drop off</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body" id="dropLocation">
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<!-- Delay ride modal -->
<div class="modal fade" id="delayRideModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Delay Ride</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{ route('delay.ride.store') }}" method="POST">
                    @csrf
                    <input type="hidden" id="bookingID" name="bookingID" value="">
                    <div class="mb-3">
                        <label for="exampleFormControlInput1" class="form-label">Add Delay Time </label>
                        <input type="number" class="form-control" id="delayTime" name="delay_time" placeholder="Enter delay time" required>
                    </div>
                    <div class="mb-3">
                        <label for="exampleFormControlTextarea1" class="form-label">Add delay fee</label>
                        <input type="number" class="form-control" id="delayFee" name="delay_fee" placeholder="Calculated delay fee" readonly>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btnRed" id="submitDelayForm">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection