@extends('admin/layouts.app')

@section('title', 'Dashboard')

@section('content')
@if(\Session::get('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert" id="alertSuccess">
        <div class="alert-body">
            {{ \Session::get('success') }}
        </div>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif
 <!-- Page content-->
        <div class="container-fluid">
          <div class="content-wrapper" id="dashboard">
            <div class="row">
              <div class="col-12">
                <div class="header">
                  <div class="d-block d-sm-flex align-items-center justify-content-between">
                    <p class="fs-18 mb-0 d-flex align-items-center bg-transparent titlebrown">
                      <span>
                        <svg width="16" height="17" viewBox="0 0 16 17" fill="none" xmlns="http://www.w3.org/2000/svg">
                          <path d="M0.879412 8.90409H6.15588C6.63956 8.90409 7.03529 8.50341 7.03529 8.01368V0.890409C7.03529 0.400684 6.63956 0 6.15588 0H0.879412C0.395735 0 0 0.400684 0 0.890409V8.01368C0 8.50341 0.395735 8.90409 0.879412 8.90409ZM0.879412 16.0274H6.15588C6.63956 16.0274 7.03529 15.6267 7.03529 15.137V11.5753C7.03529 11.0856 6.63956 10.6849 6.15588 10.6849H0.879412C0.395735 10.6849 0 11.0856 0 11.5753V15.137C0 15.6267 0.395735 16.0274 0.879412 16.0274ZM9.67353 16.0274H14.95C15.4337 16.0274 15.8294 15.6267 15.8294 15.137V8.01368C15.8294 7.52396 15.4337 7.12327 14.95 7.12327H9.67353C9.18985 7.12327 8.79412 7.52396 8.79412 8.01368V15.137C8.79412 15.6267 9.18985 16.0274 9.67353 16.0274ZM8.79412 0.890409V4.45205C8.79412 4.94177 9.18985 5.34245 9.67353 5.34245H14.95C15.4337 5.34245 15.8294 4.94177 15.8294 4.45205V0.890409C15.8294 0.400684 15.4337 0 14.95 0H9.67353C9.18985 0 8.79412 0.400684 8.79412 0.890409Z" fill="#222222"></path>
                        </svg>
                      </span>
                      <span class="mt-1 ms-2">Dashboard</span>
                    </p>
                    <!-- <p class="mb-0 colorGray"><span>Date: March 31, 2022 </span> | <span>08:45 AM</span>
                                    </p> -->
                  </div>
                </div>
              </div>
            </div>

              <div class="row mt-4">
                  <div class="col-md-3 col-lg-3">
                    <div class="card global-shadow p-4 rounded">
                      <div class="d-flex justify-content-between align-items-center">
                        <div>
                          <h6>Total Riders</h6>
                          <h2 class="mb-0 pb-0 fw-600">{{ $riders }}</h2>
                        </div>
                        <div class="shape-block">
                          <svg id="fi_9131549" enable-background="new 0 0 512 512" height="35" viewBox="0 0 512 512" width="35" xmlns="http://www.w3.org/2000/svg"><g id="Layer_2_00000088855313069222395470000001121463647142642833_"><g id="Social_Icon"><g id="Avatar"><path d="m256 292.1c33 0 63.5-9.3 87.9-25.1 18.9-12.1 43.5-10.1 60.1 5 46.1 41.8 72.3 101.1 72.2 163.4v26.7c0 27.6-22.4 49.9-50 49.9h-340.4c-27.6 0-50-22.3-50-49.9v-26.7c-.2-62.2 26-121.6 72.1-163.3 16.6-15.1 41.3-17.1 60.1-5 24.5 15.7 54.9 25 88 25z"></path><circle cx="256" cy="123.8" r="123.8"></circle></g></g></g></svg>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="col-md-3 col-lg-3">
                    <div class="card global-shadow p-4 rounded">
                      <div class="d-flex justify-content-between align-items-center">
                        <div>
                          <h6>Total Drivers</h6>
                          <h2 class="mb-0 pb-0 fw-600">{{ $drivers }}</h2>
                        </div>
                        <div class="shape-block">
                          <svg id="fi_6478574" enable-background="new 0 0 60 60" height="40" viewBox="0 0 60 60" width="40" xmlns="http://www.w3.org/2000/svg"><path d="m17.75 14.14c-.32.43-.49.89-.49 1.38 0 2.74 6 6.21 12.73 6.21s12.73-3.47 12.73-6.21c0-.49-.17-.95-.49-1.38 2.29-.9 3.75-2.11 3.75-3.65.01-3.6-8.04-5.49-15.98-5.49-7.95 0-16 1.89-16 5.49 0 1.53 1.47 2.75 3.75 3.65z"></path><path d="m30 23.73c-4.36 0-8.58-1.33-11.38-3.26.76 5.1 3.27 14.48 11.38 14.48 8.1 0 10.61-9.38 11.37-14.48-2.8 1.93-7.01 3.26-11.37 3.26z"></path><path d="m34.57 39.53.28 2.55 3.41-6.7c-.42-.28-.8-.64-1.17-1.04-1.41 1.21-3.02 2-4.79 2.37 1.2.31 2.12 1.4 2.27 2.82z"></path><path d="m22.84 34.29c-.39.44-.82.86-1.32 1.19l3.57 7.02.33-2.97c.16-1.42 1.07-2.51 2.27-2.82-1.79-.38-3.42-1.19-4.85-2.42z"></path><path d="m44.06 37.53-3.98-1.31-9.09 17.84.48.94h20.87c.55 0 1-.45 1-1v-3.64c0-5.84-3.73-11-9.28-12.83zm2.65 8.68c-.18.14-.4.21-.62.21-.29 0-.59-.13-.78-.38-.85-1.07-1.99-1.87-3.3-2.3-.52-.17-.81-.74-.64-1.26.18-.53.74-.81 1.27-.64 1.68.55 3.14 1.58 4.24 2.96.34.44.26 1.06-.17 1.41z"></path><path d="m32.59 39.75c-.07-.65-.49-1.14-.99-1.14h-3.2c-.5 0-.92.48-.99 1.14l-.66 6 3.12 6.12 3.33-6.53z"></path><path d="m28.75 54.06-9.06-17.76-3.75 1.23c-5.56 1.83-9.28 6.99-9.28 12.83v3.64c0 .55.44 1 1 1h20.61zm-10.77-10.32c-1.31.43-2.45 1.23-3.29 2.3-.2.25-.49.38-.79.38-.22 0-.44-.07-.62-.21-.43-.35-.51-.97-.16-1.41 1.09-1.38 2.55-2.41 4.24-2.96.52-.17 1.09.11 1.26.64.17.52-.11 1.09-.64 1.26z"></path></svg>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="col-md-3 col-lg-3">
                    <div class="card global-shadow p-4 rounded">
                      <div class="d-flex justify-content-between align-items-center">
                        <div>
                          <h6>Total Recent Bookings</h6>
                          <h2 class="mb-0 pb-0 fw-600">{{ $bookings }}</h2>
                        </div>
                        <div class="shape-block">
                          <svg height="40" viewBox="0 0 24 24" width="40" xmlns="http://www.w3.org/2000/svg" id="fi_2740596"><g id="Layer_93" data-name="Layer 93"><path d="m19 5h-1v-2a1 1 0 0 0 -2 0v2h-8v-2a1 1 0 0 0 -2 0v2h-1a3 3 0 0 0 -3 3v1h20v-1a3 3 0 0 0 -3-3z"></path><path d="m2 19a3 3 0 0 0 3 3h14a3 3 0 0 0 3-3v-8h-20z"></path></g></svg>
                        </div>
                      </div>
                    </div>
                  </div>


                  <div class="col-md-3 col-lg-3">
                    <div class="card global-shadow p-4 rounded">
                      <div class="d-flex justify-content-between align-items-center">
                        <div>
                          <h6>Total Earnings</h6>
                          <h2 class="mb-0 pb-0 fw-600">${{ $earnings ?? 1 }}</h2>
                        </div>
                        <div class="shape-block">
                          <svg id="fi_8750304" height="40" viewBox="0 0 32 32" width="40" xmlns="http://www.w3.org/2000/svg"><path d="m11.34 7h9.1l1.67-2.97c.41-.72.34-1.61-.18-2.26-.51-.65-1.36-.92-2.16-.69l-5 1.42-2.32-.95c-.81-.33-1.72-.12-2.3.54s-.68 1.58-.25 2.35l1.44 2.57z"></path><path d="m26.69 23.96-3.26-9.85c-.48-1.46-1.5-2.63-2.77-3.34l-.57-1.77h-8.42l-.58 1.79s0 .09-.02.14c-1.15.72-2.06 1.82-2.51 3.18l-3.26 9.85c-.55 1.65-.28 3.41.74 4.82s2.6 2.22 4.34 2.22h11.21c1.74 0 3.32-.81 4.34-2.22s1.29-3.17.74-4.82zm-9.27-3.96c.48 0 .93.21 1.23.56.27.32.4.73.36 1.14v2.03c.03.36-.1.7-.36.95-.29.28-.66.35-.97.35-.13 0-.25-.01-.35-.03h-.32c0 .55-.45 1-1 1s-1-.45-1-1h-1c-.55 0-1-.45-1-1s.45-1 1-1h3v-1h-2.41c-.78 0-1.3-.68-1.53-1.31-.04-.11-.06-.22-.06-.34v-1.71c0-.91.74-1.65 1.65-1.65h.35c0-.55.45-1 1-1s1 .45 1 1h1c.55 0 1 .45 1 1s-.45 1-1 1h-3v1h2.41z"></path></svg>
                        </div>
                      </div>
                    </div>
                  </div>
              </div>

            <div class="row pt-4">
              <div class="col-lg-12">
              <ul class="nav nav-tabs" id="myTab" role="tablist">
                <li class="nav-item" role="presentation">
                  <button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab" 
                  aria-controls="home" aria-selected="true">Live Bookings</button>
                </li>
                <!--<li class="nav-item" role="presentation">-->
                <!--  <button class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab"-->
                <!--   aria-controls="profile" aria-selected="false">Live Selfie Requests</button>-->
                <!--</li>-->
              </ul>
              <div class="tab-content" id="myTabContent">
                <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                  <div class="border-0">
                    <div class="card global-shadow p-4 w-100 table-responsive">
                        <table class="isplay w-100" id="upcomingReservation">
                            <thead>
                                <tr>
                                    <th scope="col">Booking ID</th>
                                    <th scope="col">Rider Name</th>
                                    <th scope="col">Driver Name</th>
                                    <th scope="col">Booking Date </th>
                                    <th scope="col">Delay Minutes </th>
                                    <th scope="col">Amount</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                 @foreach ($recentBookings as $recentBooking)
                                 
                                <tr data-driver-id="{{ $recentBooking->driver_id }}" data-rider-id="{{ $recentBooking->rider_id }}">
                                    <td>{{ $recentBooking->booking_id }}</td>
                                    <td>{{ (!empty($recentBooking->rider->first_name) || !empty($recentBooking->rider->last_name)) ? $recentBooking->rider->first_name. ' ' .$recentBooking->rider->last_name : "" }}</td>
                                    <td>{{ (!empty($recentBooking->driver->first_name) || !empty($recentBooking->driver->last_name)) ? $recentBooking->driver->first_name. ' ' .$recentBooking->driver->last_name : "" }}</td>
                                    <td>{{ \Carbon\Carbon::parse($recentBooking->pickup_date)->format('jS F Y') }}</td>
                                    <td>{{ $recentBooking->rider_delay_time ?  $recentBooking->rider_delay_time : 'Not Delayed' }}</td>
                                    <td>{{ $recentBooking->total_fare ? '$' . $recentBooking->total_fare : '' }}</td>
                                    <td>
                                        <button class="badge btngreen p-2 fs-12 border-0 unmatch-btn " data-bs-toggle="modal" data-bs-target="#exampleModal" data-driver-id="{{ $recentBooking->driver_id }}" data-rider-id="{{ $recentBooking->rider_id }}">Unmatch</button>
                                         @if(!empty($recentBooking->driver->id))
                                         <a role="button" class="btn btnRed" href="{{ url('/admin/booking/detail/'.$recentBooking->id) }}">Chat</a>
                                        @endif
                                    </td>
                                    
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                  </div>
                </div>
                <!--<div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">-->
                <!--  <div class="border-0">-->
                <!--    <div class="card global-shadow p-4 w-100">-->
                <!--        <table class="isplay w-100" id="upcomingReservation2">-->
                <!--            <thead>-->
                <!--                <tr>-->
                <!--                    <th scope="col">Driver Name</th>-->
                <!--                    <th scope="col">Selfie </th>-->
                <!--                    <th scope="col">Action</th>-->
                <!--                </tr>-->
                <!--            </thead>-->
                <!--            <tbody>-->
                <!--                <tr>-->
                <!--                  <td>Khalid</td>-->
                <!--                    <td>-->
                <!--                      <div class="avtar_01 me-2" data-bs-toggle="modal" data-bs-target="#exampleModal2">-->
                <!--                        <img src="public/assets/images/user-07.png" alt="" class="fir-img">-->
                <!--                      </div>-->
                <!--                    </td>-->
                <!--                    <td>-->
                <!--                      <div>-->
                <!--                        <button type="button" class="btn btn-success px-3">Accept</button>-->
                <!--                        <button type="button" class="btn btndark px-3">Reject</button>-->
                <!--                      </div>-->
                <!--                    </td>-->
                <!--                </tr>-->
                <!--            </tbody>-->
                <!--        </table>-->
                <!--    </div>-->
                <!--  </div>-->
                <!--</div>-->
              </div>
            </div>
              </div>
        </div>
      </div>

<!-- Modal unmatch-->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <p class="text-center pt-3">
                    <img src="public/assets/images/calendar.svg" width="95px" alt=""/>
                </p>
                <h4 class="text-center fw-600">
                    Are you sure you want to unmatch the driver with this booking?
                </h4>
            </div>
            <div class="d-flex justify-content-center gap-3 pb-4">
                <button type="button" class="btn btnRed py-2 px-4 confirm-unmatch">Yes</button>
                <button type="button" class="btn btn-secondary py-2 px-4" data-bs-dismiss="modal">No</button>
            </div>
        </div>
    </div>
</div>

      
<!-- Modal -->
<div class="modal fade" id="exampleModal2" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Selfie Photo</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <img src="public/assets/images/photo-large.jpg" alt="" class="img-fluid"/>
      </div>
    
    </div>
  </div>
</div>

@endsection