@extends('admin/layouts.app')

@section('title', 'Drivers Details')

@section('content')

    <!-- Page content-->
        <div class="container-fluid">
          <div class="content-wrapper" id="dashboard">
            <div class="row">
                <div class="col-12">
                  <div class="header">
                    <div class="d-block d-sm-flex align-items-center justify-content-between">
                      <p class="fs-18 mb-0 d-flex align-items-center bg-transparent titlebrown">
                        <span>
                          <svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                <ellipse cx="16" cy="7.20103" rx="2.5" ry="2.44792" fill="#CCCCCC"/>
                <path fill-rule="evenodd" clip-rule="evenodd" d="M14 7.20105C14 9.96247 11.7614 12.201 9 12.201C6.23858 12.201 4 9.96247 4 7.20105C4 4.43963 6.23858 2.20105 9 2.20105C11.7614 2.20105 14 4.43963 14 7.20105ZM12 7.20105C12 8.8579 10.6569 10.201 9 10.201C7.34315 10.201 6 8.8579 6 7.20105C6 5.5442 7.34315 4.20105 9 4.20105C10.6569 4.20105 12 5.5442 12 7.20105Z" fill="black"/>
                <path d="M15 4.20105C15 3.64877 15.4477 3.20105 16 3.20105C18.2091 3.20105 20 4.99191 20 7.20105C20 9.41019 18.2091 11.201 16 11.201C15.4477 11.201 15 10.7533 15 10.201C15 9.64877 15.4477 9.20105 16 9.20105C17.1046 9.20105 18 8.30562 18 7.20105C18 6.09648 17.1046 5.20105 16 5.20105C15.4477 5.20105 15 4.75333 15 4.20105Z" fill="black"/>
                <path d="M5 13.201C3.34315 13.201 2 14.5441 2 16.201V21.201C2 21.7533 2.44772 22.201 3 22.201C3.55228 22.201 4 21.7533 4 21.201V16.201C4 15.6487 4.44772 15.201 5 15.201H13C13.5523 15.201 14 15.6487 14 16.201V21.201C14 21.7533 14.4477 22.201 15 22.201C15.5523 22.201 16 21.7533 16 21.201V16.201C16 14.5441 14.6569 13.201 13 13.201H5Z" fill="black"/>
                <path d="M17 13.201C16.4477 13.201 16 13.6487 16 14.201C16 14.7533 16.4477 15.201 17 15.201H19C19.5523 15.201 20 15.6487 20 16.201V21.201C20 21.7533 20.4477 22.201 21 22.201C21.5523 22.201 22 21.7533 22 21.201V16.201C22 14.5441 20.6569 13.201 19 13.201H17Z" fill="black"/>
                <ellipse cx="9" cy="7.20105" rx="3" ry="2.9375" fill="#CCCCCC"/>
                </svg>
                        </span>
                        <span class="mt-1 ms-2">Driver Details</span>
                      </p>
                    </div>
                  </div>
                </div>
              </div>

              <div class="row pt-4 my-3">
                <div class="col-lg-4">
                  <div class="border-0">
                    <div class="card global-shadow p-4">
                      <div class="user-img">
                           @if(!empty($driverDetails) && !empty($driverDetails->profile_pic))
                            <img src="{{ asset('public/storage/' . $driverDetails->profile_pic) }}" alt="Driver Profile" class="img-fluid object-fit-cover">
                            @else
                            <img src="{{ asset('public/assets/images/users/photo-large.jpg') }}" alt="" class="img-fluid object-fit-cover">
                            @endif
                      </div>
                        <h5 class="text-center mb-0 pb-0">{{ (!empty($driverDetails->first_name) || !empty($driverDetails->last_name)) ? $driverDetails->first_name. ' ' .$driverDetails->last_name : "" }}</h5>
                    </div>
                   
                    </div>

                  </div>

                <div class="col-md-8 col-xxl-8 pro_dta">
                <div class="card global-shadow p-4 w-100">
                      <div class="d-flex justify-content-between">
                        <span class="fs-5 px-2 flex-lg-row flex-column text-capitalize fw-bold">
                          Personal information 
                        </span>

                        <span>
                          <button type="button" class="btn btn-success">Accept</button>
                          <button type="button" class="btn btndark">Reject</button>
                        </span>

                      </div>
                <div class="col-md-12">
                    <div class="border-0">
                      <div class="card global-shadow w-100">
                        <ul class="list-group my-3">
      <li class="list-group-item d-flex justify-content-between align-items-center py-3 border-0 border-bottom fs-14 px-2 flex-lg-row flex-column text-capitalize">Email Id<span class="fw-600 text-capitalize">{{ $driverDetails->email }}</span>
      </li>
      <li class="list-group-item d-flex justify-content-between align-items-center py-3 border-0 border-bottom fs-14 px-2 flex-lg-row flex-column text-capitalize">Street Address<span class="fw-600 text-capitalize">{{ $driverDetails->address }}	</span>
      </li>
      <li class="list-group-item d-flex justify-content-between align-items-center py-3 border-0 border-bottom fs-14 px-2 flex-lg-row flex-column text-capitalize">Unit Number<span class="fw-600 text-capitalize">{{ $driverDetails->unit_number }}</span>
      </li>
        <li class="list-group-item d-flex justify-content-between align-items-center py-3 border-0 border-bottom fs-14 px-2 flex-lg-row flex-column text-capitalize">country<span class="fw-600 text-capitalize">{{ $driverDetails->country }}</span>
        </li>
        <li class="list-group-item d-flex justify-content-between align-items-center py-3 border-0 border-bottom fs-14 px-2 flex-lg-row flex-column text-capitalize">Postal Code<span class="fw-600 text-capitalize">{{ $driverDetails->postal_code }}</span>
        </li>
     
      </ul>
   </div>
                    </div>
                  </div>
                </div>
                  </div>
  
  
                  <div class="col-lg-12 pro_dta mt-5 mb-5 mx-auto">
                <div class="card global-shadow p-4 ">
                  <div class="col-md-12">
                <p class="list-group-item d-flex border-0 fs-5 flex-lg-row text-capitalize fw-bold px-0">Document &amp; License</p>
                  </div>
                        <div class="d-flex gap-5 align-items-center">
                  <div class="">
                      <div class="car-img">
                           @if(!empty($driverDetails) && !empty($driverDetails->front_image))
                            <img src="{{ asset('public/storage/' . $driverDetails->front_image) }}" alt="Driver Profile" class="img-fluid object-fit-cover">
                            @else
                            <img src="{{ asset('public/assets/images/front-img.png') }}" alt="" class="img-fluid">
                            @endif
                      </div>
                      <h6 class="text-center pt-2">Front Image</h6>
                  </div>
                  <div class="">
                    <div class="car-img">
                         @if(!empty($driverDetails) && !empty($driverDetails->back_image))
                            <img src="{{ asset('public/storage/' . $driverDetails->back_image) }}" alt="Driver Profile" class="img-fluid object-fit-cover">
                            @else
                            <img src="{{ asset('public/assets/images/back-img.png') }}" alt="" class="img-fluid">
                            @endif
                    
                    </div>
                    <h6 class="text-center pt-2">Back Image</h6>
                  </div>
                </div>
              </div>
            </div>
           </div>
        </div>
      </div>

@endsection