@extends('admin/layouts.app')

@section('title', 'Manage Drivers')

@section('content')
@if(\Session::get('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert" id="alertSuccess">
        <div class="alert-body">
            {{ \Session::get('success') }}
        </div>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif
 <!-- Page content-->
  <div class="container-fluid">
          <div class="content-wrapper" id="dashboard">
            <div class="row">
                <div class="col-12">
                  <div class="header">
                    <div class="d-block d-sm-flex align-items-center justify-content-between">
                      <p class="fs-18 mb-0 d-flex align-items-center bg-transparent titlebrown">
                        <span>
                         <svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                <ellipse cx="16" cy="7.20103" rx="2.5" ry="2.44792" fill="#CCCCCC"></ellipse>
                <path fill-rule="evenodd" clip-rule="evenodd" d="M14 7.20105C14 9.96247 11.7614 12.201 9 12.201C6.23858 12.201 4 9.96247 4 7.20105C4 4.43963 6.23858 2.20105 9 2.20105C11.7614 2.20105 14 4.43963 14 7.20105ZM12 7.20105C12 8.8579 10.6569 10.201 9 10.201C7.34315 10.201 6 8.8579 6 7.20105C6 5.5442 7.34315 4.20105 9 4.20105C10.6569 4.20105 12 5.5442 12 7.20105Z" fill="black"></path>
                <path d="M15 4.20105C15 3.64877 15.4477 3.20105 16 3.20105C18.2091 3.20105 20 4.99191 20 7.20105C20 9.41019 18.2091 11.201 16 11.201C15.4477 11.201 15 10.7533 15 10.201C15 9.64877 15.4477 9.20105 16 9.20105C17.1046 9.20105 18 8.30562 18 7.20105C18 6.09648 17.1046 5.20105 16 5.20105C15.4477 5.20105 15 4.75333 15 4.20105Z" fill="black"></path>
                <path d="M5 13.201C3.34315 13.201 2 14.5441 2 16.201V21.201C2 21.7533 2.44772 22.201 3 22.201C3.55228 22.201 4 21.7533 4 21.201V16.201C4 15.6487 4.44772 15.201 5 15.201H13C13.5523 15.201 14 15.6487 14 16.201V21.201C14 21.7533 14.4477 22.201 15 22.201C15.5523 22.201 16 21.7533 16 21.201V16.201C16 14.5441 14.6569 13.201 13 13.201H5Z" fill="black"></path>
                <path d="M17 13.201C16.4477 13.201 16 13.6487 16 14.201C16 14.7533 16.4477 15.201 17 15.201H19C19.5523 15.201 20 15.6487 20 16.201V21.201C20 21.7533 20.4477 22.201 21 22.201C21.5523 22.201 22 21.7533 22 21.201V16.201C22 14.5441 20.6569 13.201 19 13.201H17Z" fill="black"></path>
                <ellipse cx="9" cy="7.20105" rx="3" ry="2.9375" fill="#CCCCCC"></ellipse>
                </svg>
                        </span>
                        <span class="mt-1 ms-2">Manage Drivers</span>
                      </p>
                    </div>
                  </div>
                </div>
              </div>

            <div class="row pt-4">
              <div class="col-lg-12 position-relative">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                  <!--<li class="nav-item" role="presentation">-->
                  <!--  <button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab" -->
                  <!--  aria-controls="home" aria-selected="true">New Driver's Requests</button>-->
                  <!--</li>-->
                  <li class="nav-item" role="presentation">
                    <button class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab"
                     aria-controls="profile" aria-selected="false">Accepted Drivers</button>
                  </li>
                </ul>
                <div class="tab-content" id="myTabContent">
              {{--    <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                    <div class="border-0">
                      <div class="card global-shadow p-4 w-100 table-responsive">
                          <table class="isplay w-100" id="upcomingReservation">
                              <thead>
                                  <tr>
                                      <th scope="col">Name</th>
                                      <th scope="col">Email Id</th>
                                      <th scope="col">Phone Number</th>
                                      <th scope="col">Street Address</th>
                                      <th scope="col">Unit Number</th>
                                      <th scope="col">Recent Active Time</th>
                                      <th scope="col">Action</th>
                                  </tr>
                              </thead>
                              <tbody>
                                   @foreach($rejectedDrivers as $rejectedDriver)
                                  <tr>
                                    <td>
                                      <div class="d-flex align-items-center me-3">
                                        <div class="avtar_01 me-2">
                                          @if(!empty($rejectedDriver) && !empty($rejectedDriver->profile_pic))
                                        <img src="{{ asset('public/storage/' . $rejectedDriver->profile_pic) }}" alt="" class="fir-img">
                                        @else
                                        <img src="{{ asset('public/assets/images/users/user-02.png') }}" alt="" class="fir-img">
                                        @endif
                                        </div>
                                        <div class="">
                                          <p class="mb-0 colorBlack fw-600 lHeight pargh-block-inner">{{ $rejectedDriver->first_name. ' ' .$rejectedDriver->last_name }}</p>
                                        </div>
                                      </div>
                                    </td>
                                    <td>{{ $rejectedDriver->email }}</td>
                                      <td>{{ $rejectedDriver->country_code. ' ' .$rejectedDriver->phone }}</td>
                                      <td><p class="pargh-block-inner">{{ $rejectedDriver->address. ' ' .$rejectedDriver->country. ' ' .$rejectedDriver->postal_code }}</p></td>
                                      <td>{{ $rejectedDriver->unit_number }}</td>
                                      <td>
                                         @php
                                        if (!empty($rejectedDriver->user_last_active)) {
                                            date_default_timezone_set($userTimeZone);
                                            echo date( 'jS F Y H:i:s',strtotime($rejectedDriver->user_last_active .' UTC') );
                                            }
                                            else{
                                            echo 'N/A';
                                            }
                                        @endphp
                                      </td>
                                       <td>
                                            <div class="d-flex align-items-center gap-2">
                                               <a role="button" class="btn btnRed" href="{{ url('/admin/drivers/detail/'.$rejectedDriver->id) }}">View Details</a>  
                                               <button type="button" class="btn btn-success">Accept</button>
                                               <button type="button" class="btn btndark">Reject</button>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                              </tbody>
                          </table>
                      </div>
                    </div>
                  </div> --}}
                  <div class="tab-pane fade show active" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                    <div class="border-0">
                      <div class="card global-shadow p-4 w-100 table-responsive">
                          <table class="isplay w-100" id="upcomingReservation2">
                              <thead>
                                  <tr>
                                      <th scope="col">Name</th>
                                      <th scope="col">Email Id</th>
                                      <th scope="col">Phone Number</th>
                                      <th scope="col">Street Address</th>
                                      <th scope="col">Unit Number</th>
                                      <th scope="col">Recent Active Time</th>
                                      <th scope="col">Action</th>
                                  </tr>
                              </thead>
                              <tbody>
                                   @foreach($acceptedDrivers as $acceptedDriver)
                                  <tr>
                                    <td>
                                      <div class="d-flex align-items-center me-3">
                                        <div class="avtar_01 me-2">
                                          @if(!empty($acceptedDriver) && !empty($acceptedDriver->profile_pic))
                                        <img src="{{ asset('public/storage/' . $acceptedDriver->profile_pic) }}" alt="" class="fir-img">
                                        @else
                                        <img src="{{ asset('public/assets/images/users/user-02.png') }}" alt="" class="fir-img">
                                        @endif
                                        </div>
                                        <div class="">
                                          <p class="mb-0 colorBlack fw-600 lHeight pargh-block-inner">{{ $acceptedDriver->first_name. ' ' .$acceptedDriver->last_name }}</p>
                                        </div>
                                      </div>
                                    </td>
                                    <td>{{ $acceptedDriver->email }}</td>
                                      <td>{{ $acceptedDriver->country_code. ' ' .$acceptedDriver->phone }}</td>
                                      <td><p class="pargh-block-inner">{{ $acceptedDriver->address. ' ' .$acceptedDriver->country. ' ' .$acceptedDriver->postal_code }}</p></td>
                                        <td>{{ $acceptedDriver->unit_number }}</td>
                                         <td>
                                        @php
                                        if (!empty($acceptedDriver->user_last_active)) {
                                            date_default_timezone_set($userTimeZone);
                                            echo date( 'jS F Y H:i:s',strtotime($acceptedDriver->user_last_active .' UTC') );
                                            }
                                            else{
                                            echo 'N/A';
                                            }
                                        @endphp
                                      </td>
                                        <td>
                                            <div class="d-flex align-items-center gap-2">
                                                <a role="button" class="btn btnRed" href="{{ url('/admin/drivers/detail/'.$acceptedDriver->id) }}">View Details</a> 
                                                @if($acceptedDriver->status == 1)
                                                    <a href="{{ route('drivers.deactivate', $acceptedDriver->id) }}" class="btn btn-danger">Deactivate</a>
                                                @else
                                                    <a href="{{ route('drivers.activate', $acceptedDriver->id) }}" class="btn btn-success">Activate</a>
                                                @endif
                                                <a class="deleteBtn btn btndark" href="{{ url('/admin/drivers/delete/'.$acceptedDriver->id) }}" data-bs-toggle="modal" data-bs-target="#deleteModal">Delete</a>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                              </tbody>
                          </table>
                      </div>
                    </div>
                  </div>
                </div>
                </div>
              </div>
        </div>
      </div>
@endsection