@extends('admin/layouts.app') @section('title', 'Faq Management') @section('content') @if (session('success'))
<div class="alert alert-success alert-dismissible fade show" role="alert" id="alertSuccess">
    <div class="alert-body">
        {{ session('success') }}
    </div>
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif @if (session('error'))
<div class="alert alert-danger alert-dismissible fade show" role="alert" id="alertError">
    <div class="alert-body">
        {{ session('error') }}
    </div>
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

<!-- Page content-->
<div class="container-fluid">
    <div class="content-wrapper" id="dashboard">
        <div class="row">
            <div class="col-12">
                <div class="header">
                    <div class="d-block d-sm-flex align-items-center justify-content-between">
                        <p class="fs-18 mb-0 d-flex align-items-center bg-transparent titlebrown">
                            <span class="menu-icons">
                                <svg version="1.0" xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 512.000000 512.000000" preserveAspectRatio="xMidYMid meet">
                                    <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)" fill="#000000" stroke="none">
                                        <path d="M279 4646 c-106 -40 -191 -110 -234 -195 -46 -92 -46 -97 -43 -1346 l3 -1180 32 -67 c61 -129 173 -211 311 -229 37 -4 158 -8 270 -9 l202 0 0 -377 0 -376 25 -43 c28 -47 90 -84 143 -84 59 0 104 29 221 143 64 61 146 140 182 176 l67 63 47 -32 c90 -62 63 -60 934 -60 l797 0 227 -264 c142 -164 243 -271 267 -285 67 -37 157 -26 213 27 56 52 60 71 71 304 l10 217 430 3 c416 3 433 4 477 24 67 31 124 87 156 152 l28 57 0 1125 0 1125 -26 56 c-29 61 -85 121 -140 150 -41 20 -140 39 -211 39 l-48 0 0 264 c0 145 -5 288 -10 317 -23 124 -105 229 -220 283 l-65 31 -2040 2 c-1663 1 -2047 -1 -2076 -11z m4099 -172 c47 -19 88 -58 115 -109 l22 -40 0 -1180 c0 -1127 -1 -1182 -18 -1217 -25 -49 -63 -87 -112 -109 -38 -18 -98 -19 -1255 -19 l-1215 0 -460 -442 -460 -441 -3 441 -2 442 -323 0 -323 0 -51 25 c-56 28 -95 77 -112 140 -15 57 -15 2299 0 2360 14 55 70 122 123 146 39 18 120 19 2039 19 1784 0 2002 -2 2035 -16z"/>
                                        <path d="M3030 3710 c-212 -57 -301 -226 -300 -570 1 -330 103 -498 326 -539 83 -16 130 -14 207 8 l67 20 0 -33 0 -33 163 -33 c89 -18 166 -33 170 -34 4 0 28 45 51 101 l44 102 -64 36 c-35 20 -66 39 -68 44 -3 5 6 34 19 64 38 82 55 178 55 312 0 318 -80 480 -270 546 -95 33 -295 37 -400 9z m320 -534 c0 -320 10 -300 -155 -304 l-116 -4 3 256 c3 285 3 282 75 296 21 4 73 8 116 9 l77 1 0 -254z"/>
                                        <path d="M957 3703 c-4 -3 -7 -255 -7 -560 l0 -553 165 0 165 0 0 205 0 205 140 0 140 0 0 135 0 135 -140 0 -140 0 0 75 0 75 155 0 c85 0 155 3 155 8 0 4 9 66 20 137 11 72 20 133 20 138 0 9 -664 10 -673 0z"/>
                                        <path d="M1845 3513 c-26 -109 -87 -361 -135 -561 l-87 -362 156 2 156 3 19 88 19 87 173 0 174 0 6 -27 c3 -16 10 -44 14 -63 4 -19 11 -47 14 -62 l6 -28 156 0 c143 0 155 1 150 18 -3 9 -60 244 -126 522 -67 278 -125 522 -131 543 l-10 37 -253 0 -254 0 -47 -197z m378 -290 c16 -76 31 -146 33 -155 5 -16 -5 -18 -111 -18 -106 0 -116 2 -111 18 3 9 17 73 31 142 15 69 28 131 30 138 3 7 23 12 52 12 l48 0 28 -137z"/>
                                    </g>
                                </svg>
                            </span>
                                <span class="mt-1 ms-2">Faq's Management</span>
                        </p>
                        <div>
                            <a role="button" class="btn btnRed" href="javascript:;" data-bs-toggle="modal" data-bs-target="#addFaqModal">Add New Faq</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row pt-4">
            <div class="col-lg-12 position-relative">
                <div class="border-0">
                    <div class="card global-shadow p-4 w-100 table-responsive">
                        <table class="isplay w-100" id="upcomingReservation">
                            <thead>
                                <tr>
                                    <th scope="col">Title</th>
                                    <th scope="col">Description</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($faqs as $fq)
                                <tr>
                                    <td>
                                        <p>{{ $fq->title}}</p>
                                    </td>
                                    <!--<td><p class="pargh-block-inner">{{ $fq->description }}</p></td>-->
                                    <td>
                                        @if(strlen(strip_tags($fq->description)) > 100) {!! substr(strip_tags($fq->description),0,100) !!}
                                        <span><a href="javascript:;" class="faqEditReadMore" data-title="{{ $fq->title }}" data-description="{{ $fq->description }}">Read More...</a></span> @else {!! substr(strip_tags($fq->description),0,100) !!} @endif
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center gap-3">
                                            <a class="btn btnRed edit-faq" href="javascript:;" data-bs-toggle="modal" data-bs-target="#editFaqModal" data-id="{{ $fq->id }}" data-title="{{ $fq->title }}" data-description="{{ $fq->description }}">Edit</a>
                                            <a class="deleteBtn btn btndark" href="{{ url('/admin/faq/delete/'.$fq->id) }}" data-bs-toggle="modal" data-bs-target="#deleteModal">Delete</a>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal add-->
<div class="modal fade" id="addFaqModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add Faq</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <span id="error" class="text-danger"></span>
                    <span id="success" class="text-success"></span>
                </div>
                <form id="addFaqForm" method="post">
                    @csrf
                    <div class="mb-3">
                        <label class="form-label">Title</label>
                        <input type="text" name="title" class="form-control" placeholder="">

                    </div>
                    <div class="mb-3">
                        <label class="form-label">Description</label>
                        <textarea class="form-control" id="descTextarea" name="description" rows="3"></textarea>
                    </div>


                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btnRed">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Modal edit-->
<div class="modal fade" id="editFaqModal" tabindex="-1" aria-labelledby="editFaqModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editFaqModalLabel">Edit Faq</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{ route('editFaq') }}" method="POST">
                    @csrf
                    <input type="hidden" id="faqId" name="faq_id">
                    <div class="mb-3">
                        <label for="editFaqTitle" class="form-label">Title</label>
                        <input type="text" class="form-control" id="editFaqTitle" name="title" required>
                    </div>
                    <div class="mb-3">
                        <label for="editFaqDescription" class="form-label">Description</label>
                        <textarea class="form-control" id="editFaqDescription" name="description" rows="3" required></textarea>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btnRed">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Readmore Modal -->
<div class="modal fade" id="faqEditView" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="title"></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="description">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection