@extends('admin/layouts.app') 
@section('title', 'Fee Management') 
@section('content') 
@if (session('success'))
<div class="alert alert-success alert-dismissible fade show" role="alert" id="alertSuccess">
    <div class="alert-body">
        {{ session('success') }}
    </div>
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif
<!-- Page content-->
<div class="container-fluid">
    <div class="content-wrapper" id="dashboard">
        <div class="row">
            <div class="col-12">
                <div class="header">
                    <div class="d-block d-sm-flex align-items-center justify-content-between">
                        <p class="fs-18 mb-0 d-flex align-items-center bg-transparent titlebrown">
                            <span>
                           <svg version="1.1" id="Capa_1" width="24" height="25" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
	<g>
		<path d="M283.868,225.411c-5.856-5.858-15.355-5.859-21.213,0l-12.432,12.432c-16.724-7.967-37.383-5.045-51.211,8.782
			c-17.545,17.546-17.545,46.096,0,63.642c0.001,0.001,0.002,0.001,0.003,0.002c5.859,5.862,5.861,15.348-0.003,21.212
			c-5.861,5.861-15.35,5.863-21.214,0c-5.863-5.863-5.863-15.35,0-21.214c5.858-5.858,5.858-15.356,0-21.214
			c-5.857-5.858-15.356-5.858-21.214,0c-13.942,13.941-16.753,34.619-8.801,51.23l-12.413,12.412
			c-5.857,5.858-5.857,15.356,0,21.214c5.857,5.857,15.356,5.858,21.214,0l12.413-12.413c16.396,7.848,37.122,5.306,51.229-8.801
			c8.5-8.5,13.181-19.801,13.181-31.821c0-12.016-4.677-23.313-13.172-31.811c-0.003-0.003-0.006-0.007-0.009-0.01
			c-5.849-5.849-5.849-15.366,0-21.214c5.848-5.848,15.364-5.848,21.212-0.002c0.001,0.001,0.002,0.002,0.002,0.003
			c0,0,0.002,0.001,0.002,0.002c5.859,5.862,5.86,15.348-0.002,21.212c-5.858,5.858-5.858,15.356,0,21.214
			c5.857,5.858,15.357,5.858,21.214,0c8.5-8.499,13.181-19.801,13.181-31.82c0-6.83-1.515-13.426-4.379-19.409l12.413-12.414
			C289.725,240.766,289.725,231.269,283.868,225.411z"/>
	</g>
	<g>
		<path d="M406.996,0.001c-44.95,0-82.598,28.017-97.82,66.795l-64.445,20.833c-0.043,0.014-0.086,0.028-0.129,0.042
			c-10.988,3.662-21.126,9.928-29.317,18.12L13.159,307.914c-17.545,17.546-17.545,46.096,0,63.642L140.444,498.84
			c8.773,8.774,20.295,13.159,31.82,13.159c11.523,0,23.049-4.388,31.821-13.159l202.125-202.125
			c8.145-8.145,14.386-18.216,18.057-29.133l23.784-65.936C485.608,185.631,512,148.343,512,105.005
			C512,47.105,464.895,0.001,406.996,0.001z M430.59,161.642l-5.854,16.229c-11.807,2.875-24.011,2.852-35.823-0.073
			c0.426-2.501,0.656-5.053,0.656-7.642c0-12.021-4.681-23.321-13.182-31.82c-17.587-17.588-46.054-17.59-63.642,0
			c-17.546,17.546-17.546,46.096,0,63.642c16.594,16.595,43.084,17.534,60.8,2.593c12.739,4.29,26.123,6.045,39.666,5.251
			l-17.223,47.744c-0.041,0.115-0.081,0.23-0.12,0.346c-2.198,6.593-5.958,12.677-10.871,17.591L182.872,477.626
			c-5.848,5.849-15.365,5.849-21.214,0L34.373,350.343c-5.849-5.849-5.849-15.366,0-21.214l202.125-202.125
			c4.901-4.901,10.964-8.653,17.537-10.853c8.051-2.602,90.728-29.329,98.768-31.928c0.043-0.014,0.086-0.028,0.129-0.042
			c5.427-1.808,11.307-0.42,15.352,3.623l58.634,58.634C430.926,150.445,432.326,156.258,430.59,161.642z M355.173,180.762
			c-5.864,5.863-15.351,5.862-21.214,0c-5.848-5.849-5.848-15.366,0-21.214c5.862-5.862,15.35-5.863,21.214,0
			C361.036,165.411,361.036,174.898,355.173,180.762z M461.322,156.635c-0.079-11.602-4.651-22.875-13.19-31.412l-58.634-58.634
			c-9.931-9.93-23.558-14.513-37.104-12.875c13.913-14.712,33.572-23.712,54.601-23.712c41.357,0,75.003,33.646,75.003,75.003
			C481.999,124.999,474.119,143.176,461.322,156.635z"/>
	</g>
</svg>
                        </span>
                            <span class="mt-1 ms-2">Fee Management</span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="row pt-4">
            <div class="col-lg-12 position-relative">
                <div class="border-0">
                    <div class="card global-shadow p-4 w-100 table-responsive">
                        <table class="isplay w-100" id="upcomingReservation">
                            <thead>
                                <tr>
                                    <th scope="col">Fee Name</th>
                                    <th scope="col">Price</th>
                                    <th scope="col">Description</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($bookingFees as $bookingFee )
                                <tr>
                                    <td>{{ ucwords(str_replace('_', ' ', $bookingFee->fee_name)) }}</td>

                                    <td>${{ $bookingFee->fee_price }}</td>
                                    <td>{{ $bookingFee->description ? $bookingFee->description : '' }}</td>
                                    <td>
                                        <div class="d-flex align-items-center gap-3">
                                            <a class="btn btnRed edit-fee" href="javascript:;" data-bs-toggle="modal" data-bs-target="#editFeeModal" data-id="{{ $bookingFee->id }}" data-fee-name="{{ $bookingFee->fee_name }}" data-fee-price="{{ $bookingFee->fee_price }}" data-fee-name="{{ $bookingFee->fee_name }}" data-description="{{ $bookingFee->description }}">Edit</a>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!--Edit fee Modal -->
<div class="modal fade" id="editFeeModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Edit Fee</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{ route('editFee') }}" method="POST">
                    @csrf
                    <input type="hidden" id="feeId" name="fee_id">
                    <div class="col-md-12 mb-3">
                        <label class="form-label">Fee Name</label>
                        <input type="text" class="form-control" id="feeName" name="fee_name" readonly>
                    </div>
                    <div class="col-md-12 mb-3">
                        <label class="form-label">Price</label>
                        <input type="number" class="form-control" id="feeValoTakeRate" name="fee_price">
                    </div>
                     <div class="col-md-12 mb-3">
                        <label class="form-label">Description</label>
                        <textarea class="form-control" id="description" name="description"></textarea>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btnRed">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection