@extends('admin/layouts.app')

@section('title', 'Change Password')

@section('content')
@if(\Session::get('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert" id="alertSuccess">
        <div class="alert-body">
            {{ \Session::get('success') }}
        </div>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif
       <!-- Page content-->
        <div class="container-fluid">
          <div class="content-wrapper" id="dashboard">
            <div class="row">
                <div class="col-12">
                  <div class="header">
                    <div class="d-block d-sm-flex align-items-center justify-content-between">
                      <p class="fs-18 mb-0 d-flex align-items-center bg-transparent titlebrown">
                       <span class="menu-icons">
          <svg viewBox="0 0 32 32" width="24" height="25" xmlns="http://www.w3.org/2000/svg" id="fi_9512572"><g id="Layer_11" fill="rgb(0,0,0)" data-name="Layer 11">
            <path d="m24 11.57h-.53v-3.1a7.47 7.47 0 1 0 -14.94 0v3.1h-.53a4 4 0 0 0 -4 4v11.43a4 4 0 0 0 4 4h16a4 4 0 0 0 4-4v-11.43a4 4 0 0 0 -4-4zm-13.47-3.1a5.47 5.47 0 1 1 10.94 0v3.1h-10.94zm15.47 18.53a2 2 0 0 1 -2 2h-16a2 2 0 0 1 -2-2v-11.43a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2z"></path>
            <path d="m16 17.926a1.948 1.948 0 0 0 -1.354 3.348v2.371a1 1 0 0 0 1 1h.708a1 1 0 0 0 1-1v-2.371a1.948 1.948 0 0 0 -1.354-3.348z"></path></g></svg>
        </span>
                        <span class="mt-1 ms-2">Change Password</span>
                      </p>

                      <!-- <a role="button" class="btn btnRed" href="javascript:;" data-bs-toggle="modal" data-bs-target="#exampleModal">+ Add Fee</a> -->
                    </div>
                  </div>
                </div>
              </div>

            <div class="row pt-4">
              <div class="col-lg-8 position-relative">
                <div class="border-0">
                    <div class="card global-shadow p-4 w-100">
                        <div class="card-body pt-2">
                           <form action="{{ url('admin/change/password') }}" method="POST">
                                @csrf 
                                <div class="mb-3">
                                    <label class="form-label">Old Password</label>
                                    <input type="password" name="current_password"  class="form-control" autocomplete="off" required>
                                    @if ($errors->has('current_password'))
                                <span class="error text-danger">
                                    <i>{{ $errors->first('current_password') }}</i>
                                </span>
                                @endif
                                  </div>
                                  <div class="mb-3">
                                    <label class="form-label">New Password</label>
                                    <input type="password" name="password" class="form-control" placeholder="" autocomplete="off">
                                     @if ($errors->has('password'))
                                <span class="error text-danger">
                                    <i>{{ $errors->first('password') }}</i>
                                </span>
                                @endif
                                  </div>  
                                  <div class="mb-3">
                                    <label class="form-label">Confirm Password</label>
                                    <input type="password" name="password_confirmation" class="form-control" placeholder="" autocomplete="off">
                                     @if ($errors->has('password_confirmation'))
                                <span class="error text-danger">
                                    <i>{{ $errors->first('password_confirmation') }}</i>
                                </span>
                                @endif
                                  </div>   
                                  <div class="mt-4">
                                    <button type="submit" class="btnRed border py-2 rounded px-4">Save</button>
                                  </div> 
                              </form>
                          </div>      
                    </div>
                  </div>
                </div>
              </div>
        </div>
      </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
           
            setTimeout(function() {
                var alert = document.getElementById('alertSuccess');
                if (alert) {
                    // Use Bootstrap's alert 'close' method
                    var bsAlert = new bootstrap.Alert(alert);
                    bsAlert.close();
                }
            }, 3000);
        });
    </script> 
@endsection